/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.frameimport;

import com.excentis.products.byteblower.frame.FrameUtil;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.utils.OSValidator;
import com.excentis.products.byteblower.gui.widgets.project.EclipseProjectResource;
import com.excentis.products.byteblower.gui.wizards.frameimport.FrameImportPage;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.edit.tools.NamingTools;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

final class FrameImportPageContent
extends Composite {
    private static final String frameImportDirProperty = "byteblower.frame.import.dir";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Label label = null;
    private FrameImportPage page;
    private String location;
    private Button checkButton;
    private Button uncheckButton;
    private TableViewer tableViewer;
    private Collection<Frame> checkedFrames = new BasicEList();
    private Text locationPathField;
    private Button browseButton;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            FrameImportPageContent.this.page.setPageComplete(FrameImportPageContent.this.validatePage());
        }
    };

    FrameImportPageContent(Composite parent, FrameImportPage page, int style) {
        super(parent, style);
        this.page = page;
        this.initialize();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (FrameImportPageContent.this.label != null) {
                    FrameImportPageContent.this.label.dispose();
                }
            }
        });
    }

    private void initialize() {
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        Composite fileComposiste = new Composite((Composite)this, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        fileComposiste.setLayoutData((Object)gridData);
        fileComposiste.setLayout((Layout)new GridLayout(3, false));
        ByteBlowerProject project = this.getCurrentProject();
        this.label = new Label(fileComposiste, 0);
        this.label.setText("From file:");
        this.locationPathField = new Text(fileComposiste, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.locationPathField.setLayoutData((Object)gridData);
        this.locationPathField.setEditable(false);
        this.browseButton = new Button(fileComposiste, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FrameImportPageContent.this.handleLocationBrowseButtonPressed();
            }
        });
        if (project == null) {
            this.label.setEnabled(false);
            this.locationPathField.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
        Table frameTable = new Table((Composite)this, 2082);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        frameTable.setLayoutData((Object)gridData);
        Menu menu = this.createPopupMenu((Composite)frameTable);
        frameTable.setMenu(menu);
        this.tableViewer = new TableViewer(frameTable);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                return ((EList)object).toArray();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FrameImportPageContent.this.updateButtons();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.checkButton = new Button((Composite)this, 0);
        this.checkButton.setText("Check Selected");
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameImportPageContent.this.checkSelected(true);
            }
        });
        this.uncheckButton = new Button((Composite)this, 0);
        this.uncheckButton.setText("Uncheck Selected");
        this.uncheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameImportPageContent.this.checkSelected(false);
            }
        });
        Button invisiFill = new Button((Composite)this, 0);
        invisiFill.setVisible(false);
        invisiFill.setLayoutData((Object)new GridData(768));
        this.updateButtons();
    }

    private ByteBlowerProject getCurrentProject() {
        return ByteBlowerGuiResourceController.getProject();
    }

    private void checkAll() {
        Table table = this.tableViewer.getTable();
        int size = table.getItemCount();
        int i = 0;
        while (i < size) {
            table.getItem(i).setChecked(true);
            ++i;
        }
    }

    private void checkSelected(boolean check) {
        Table table = this.tableViewer.getTable();
        int[] selectionIndices = table.getSelectionIndices();
        int selectionSize = selectionIndices.length;
        int i = 0;
        while (i < selectionSize) {
            table.getItem(selectionIndices[i]).setChecked(check);
            ++i;
        }
        this.updateButtons();
    }

    private Menu createPopupMenu(Composite parent) {
        Menu popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                boolean selectionEmpty = FrameImportPageContent.this.tableViewer.getSelection().isEmpty();
                boolean checkSelected = !selectionEmpty;
                boolean uncheckSelected = !selectionEmpty;
                items[0].setEnabled(checkSelected);
                items[1].setEnabled(uncheckSelected);
            }
        });
        MenuItem item = new MenuItem(popUpMenu, 8);
        item.setText("Check");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameImportPageContent.this.checkSelected(true);
            }
        });
        item = new MenuItem(popUpMenu, 8);
        item.setText("Uncheck");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameImportPageContent.this.checkSelected(false);
            }
        });
        return popUpMenu;
    }

    private void updateButtons() {
        boolean enableCheck = false;
        boolean enableUncheck = false;
        TableItem[] sel = this.tableViewer.getTable().getSelection();
        int selPorts = sel.length;
        int i = 0;
        while (i < selPorts) {
            TableItem selectedItem = sel[i];
            if (selectedItem.getChecked()) {
                enableUncheck = true;
            } else {
                enableCheck = true;
            }
            ++i;
        }
        this.checkButton.setEnabled(enableCheck);
        this.uncheckButton.setEnabled(enableUncheck);
        this.page.setPageComplete(this.validatePage());
    }

    private Collection<Frame> updateAndGetSelectedByteBlowerFrames() {
        this.checkedFrames.clear();
        Object object = this.tableViewer.getInput();
        if (!(object instanceof EList)) {
            return this.checkedFrames;
        }
        EList frames = (EList)object;
        int nofFrames = frames.size();
        Frame frame = null;
        int i = 0;
        while (i < nofFrames) {
            Object tableObject = this.tableViewer.getElementAt(i);
            if (tableObject instanceof Frame) {
                frame = (Frame)tableObject;
            } else {
                Logger.getGlobal().warning("Unknown Frame class : " + tableObject);
            }
            if (this.tableViewer.getTable().getItem(i).getChecked()) {
                this.checkedFrames.add(frame);
            }
            ++i;
        }
        return this.checkedFrames;
    }

    public String getFilename() {
        this.location = this.locationPathField.getText().trim();
        return this.location;
    }

    public void handleLocationBrowseButtonPressed() {
        try {
            FileDialog dialog = new FileDialog(this.locationPathField.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.pcap"});
            dialog.setFilterNames(new String[]{"PCAP File (*.pcap)"});
            String curDir = ByteBlowerPreferences.getPreferences().get(frameImportDirProperty, null);
            if (curDir != null && curDir.length() != 0) {
                dialog.setFilterPath(curDir);
            } else {
                dialog.setFilterPath(EclipseProjectResource.getDefaultProjectLocation());
            }
            String selectedFile = dialog.open();
            if (selectedFile != null) {
                this.location = selectedFile;
                this.locationPathField.setText(this.location);
                Path path = new Path(selectedFile);
                String extension = path.getFileExtension();
                path = path.removeLastSegments(1);
                if (path.toFile().exists()) {
                    ByteBlowerPreferences.getPreferences().put(frameImportDirProperty, path.toOSString());
                }
                EList<Frame> frames = null;
                if ("bbf".equals(extension)) {
                    throw new UnsupportedOperationException("Cannot import frames from a .bbf file, feature disabled");
                }
                if ("pcap".equals(extension)) {
                    frames = this.getFramesFromPcap();
                }
                this.tableViewer.setInput(frames);
                this.checkAll();
                this.updateButtons();
            }
        }
        catch (Exception err) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"ByteBlower", (String)"An error occured while trying to load the requested frame.\n\nSee the ByteBlower Error Log for more details.");
            throw new FrameImportException(err);
        }
    }

    private EList<Frame> getFramesFromPcap() {
        int nrPacketsPresent;
        try {
            nrPacketsPresent = FrameUtil.getnrPacketsInPcap((String)this.location);
        }
        catch (FrameUtil.NoInstalledPCapException e) {
            Logger.getGlobal().log(Level.WARNING, "Pcap library not found/installed", e);
            this.getDisplay().syncExec((Runnable)new PcapInstallSuggestion());
            return null;
        }
        catch (RuntimeException e) {
            Logger.getGlobal().log(Level.WARNING, "Problem with pcap file", e);
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Problem with pcap file", (String)("The selected location is either not a valid pcap file or contains no packets: " + e.getMessage()));
                }
            });
            return null;
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "Problem with pcap file", e);
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Problem with pcap file", (String)"The selected location is either not a valid pcap file or contains no packets.");
                }
            });
            return null;
        }
        final ArrayList wantedFrames = new ArrayList();
        String detailMsg = "Number of packets: " + nrPacketsPresent + "\n\n" + " Enter the (Wireshark) indices of the packets that you would like to add." + "\nSeperate indices with comma's (,). Whitespace is allowed. Use a colon (:) or a hyphen (-) for a range of frames. E.g. \n\n";
        detailMsg = String.valueOf(detailMsg) + "First 3 frames:  1,2,3\n";
        detailMsg = String.valueOf(detailMsg) + "A couple of frames: 1,3, 4 - 10\n";
        detailMsg = String.valueOf(detailMsg) + "All frames:      1-" + nrPacketsPresent + "\n";
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                FrameAskDialog dlg = new FrameAskDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), nrPacketsPresent);
                if (dlg.open() == 0) {
                    wantedFrames.addAll(FrameUtil.parseCSV((String)dlg.getValue(), (int)nrPacketsPresent));
                }
            }
        });
        ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
        UniqueEList newFrameList = new UniqueEList();
        String basename = "PCAP_FRAME_";
        Iterator it = wantedFrames.iterator();
        while (it.hasNext()) {
            String file = this.location;
            int index = (Integer)it.next();
            String hexBytes = FrameUtil.pcapToHexString((String)file, (int)index);
            Frame frame = factory.createFrame();
            frame.setBytesHexString(hexBytes);
            Boolean value = Boolean.FALSE;
            frame.setL2AutoDestMac(value);
            frame.setL2AutoSourceMac(value);
            frame.setL3AutoArpSHA(value);
            frame.setL3AutoArpSPA(value);
            frame.setL3AutoArpTHA(value);
            frame.setL3AutoArpTPA(value);
            frame.setL3AutoDestIp(value);
            frame.setL3AutoHeaderCheck(value);
            frame.setL3AutoIpv6Destination(value);
            frame.setL3AutoIpv6PayloadLength(value);
            frame.setL3AutoIpv6Source(value);
            frame.setL3AutoSourceIp(value);
            frame.setL3AutoTotLen(value);
            frame.setL4AutoTcpChecksum(value);
            frame.setL4AutoTotLen(value);
            frame.setL4AutoUdpChecksum(value);
            ByteBlowerProject project = this.getCurrentProject();
            frame.setName(OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)frame, (String)basename));
            basename = frame.getName();
            newFrameList.add((Object)frame);
        }
        return newFrameList;
    }

    private boolean validatePage() {
        if (!ByteBlowerGuiResourceController.getInstance().isOpen()) {
            this.page.setErrorMessage("Please open a project first.");
            return false;
        }
        this.page.setMessage("Import Frames from a .pcap file into the current project.");
        return !this.updateAndGetSelectedByteBlowerFrames().isEmpty();
    }

    public Frame performFinish() {
        this.location = this.locationPathField.getText().trim();
        Frame first = null;
        UniqueEList frames = new UniqueEList(this.updateAndGetSelectedByteBlowerFrames());
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        if (project == null) {
            return null;
        }
        CompoundCommandController compound = CompoundCommandController.createInstance();
        ByteBlowerProjectController controller = new ByteBlowerProjectController(project);
        Command cmd = controller.createAddFrameCommand((Collection)frames);
        compound.appendCommand(cmd);
        ByteBlowerProjectController.CommandWithFrameBlastingFlowListReference addFbFlow = controller.addFrameBlastingFlow();
        FrameBlastingFlowController fb = (FrameBlastingFlowController)((List)addFbFlow.getCommandReference()).get(0);
        compound.appendCommand(addFbFlow.getCommand());
        String incrementedName = NamingTools.getUniqueName((ByteBlowerProject)this.getCurrentProject(), (EObject)fb.getObject(), (String)"PCAP_FRAMES_1");
        compound.appendCommand(fb.setName(incrementedName));
        for (Frame importedFrame : frames) {
            compound.appendCommand(fb.addFrame(importedFrame));
            if (first != null) continue;
            first = importedFrame;
        }
        UndoableByteBlowerControllerOperation op = new UndoableByteBlowerControllerOperation(project, "Importing frames", compound.unwrap());
        op.run();
        return first;
    }

    private static class FrameAskDialog
    extends InputDialog {
        private final int packetCount;

        public FrameAskDialog(Shell parentShell, int nrPacketsPresent) {
            super(parentShell, "Packet indices", "", "1", (IInputValidator)new IndexValidator(nrPacketsPresent));
            this.packetCount = nrPacketsPresent;
        }

        protected Control createContents(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)new GridLayout(2, false));
            Label nrPackets = new Label(container, 0);
            nrPackets.setLayoutData((Object)new GridData());
            nrPackets.setText("Number of frames:");
            Text packetCount = new Text(container, 8);
            packetCount.setText(Integer.toString(this.packetCount));
            packetCount.setLayoutData((Object)new GridData(4, 0, true, true));
            Label label = new Label(container, 68);
            label.setText("Help:\nEnter the (Wireshark) indices of the packets that you would like to add.\n Seperate indices with comma's (,). Whitespace is allowed.\nUse a colon (:) or a hyphen (-) for a range of frames.)");
            GridData data = new GridData(4);
            data.horizontalSpan = 2;
            data.horizontalAlignment = 4;
            label.setLayoutData((Object)data);
            Label lblAll = new Label(container, 0);
            lblAll.setText("All packets");
            Text t = new Text(container, 8);
            t.setText("1-" + this.packetCount);
            Label lblFirst = new Label(container, 0);
            lblFirst.setText("First four packets");
            t = new Text(container, 8);
            t.setText("1, 2, 3, 4");
            Label aNumber = new Label(container, 0);
            aNumber.setText("A number of packets");
            t = new Text(container, 8);
            t.setText("1, 2, 3, 4 - 7");
            return super.createContents(parent);
        }
    }

    private static class FrameImportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private FrameImportException(Exception base) {
            super("Import frame failed.", base);
        }
    }

    private static class IndexValidator
    implements IInputValidator {
        private ArrayList<Character> allowedChars = new ArrayList();
        int maxPackets;

        IndexValidator(int nrPacketsPresent) {
            this.allowedChars.add(Character.valueOf(','));
            this.allowedChars.add(Character.valueOf('-'));
            this.maxPackets = nrPacketsPresent;
        }

        private boolean isWithinBounds(int a) {
            return a > 0 && a <= this.maxPackets;
        }

        private boolean isNumeric(String str) {
            try {
                int val = Integer.parseInt(str.trim());
                return this.isWithinBounds(val);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        private boolean isaRange(String str) {
            try {
                String[] parts = str.split("-");
                if (parts.length == 1) {
                    return this.isNumeric(parts[0]);
                }
                if (parts.length == 2) {
                    int first = Integer.parseInt(parts[0].trim());
                    int second = Integer.parseInt(parts[1].trim());
                    return this.isWithinBounds(first) && this.isWithinBounds(second) && first < second;
                }
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        public String isValid(String input) {
            String[] parts;
            String[] stringArray = parts = input.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                boolean good;
                String part = stringArray[n2];
                boolean bl = good = part.trim().isEmpty() || this.isNumeric(part) || this.isaRange(part);
                if (!good) {
                    return "Incorrect value(s)";
                }
                ++n2;
            }
            return null;
        }
    }

    private static class PcapInstallSuggestion
    implements Runnable {
        private PcapInstallSuggestion() {
        }

        @Override
        public void run() {
            String longMsg = "The ByteBlower GUI uses the Pcap library for importing frames. \n Please install the third-party PCAP library.";
            if (OSValidator.isWindows()) {
                longMsg = String.valueOf(longMsg) + "This library can be installed from http://www.winpcap.org/";
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Pcap installation", (String)longMsg);
        }
    }
}

