/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.widgets.composites.FlowSizeComposite;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizTopology;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizard;
import com.excentis.products.byteblower.gui.wizards.framesize.composites.FrameSizeWizGeneralConfigComposite;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class FrameSizeWizGeneralConfigPage
extends WizardPage {
    private FrameSizeWizGeneralConfigComposite generalConfigComposite;
    private FrameSizeWizTopology topology;
    private FrameSizeWizard wizard;

    FrameSizeWizGeneralConfigPage(FrameSizeWizard wizard) {
        super("FrameSizeWizGeneralConfigPage");
        this.wizard = wizard;
        this.setTitle("General Configuration");
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/framesizewizard.gif"));
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new FrameSizeWizTopology((Composite)container, 2048);
        this.topology.showFlows();
        this.topology.applyChanges(false);
        this.generalConfigComposite = new FrameSizeWizGeneralConfigComposite((Composite)container, this.wizard, this.topology);
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
    }

    public List<Frame> getFrames() {
        return this.generalConfigComposite.getFrames();
    }

    public boolean isBidirectional() {
        return this.generalConfigComposite.isBidirectional();
    }

    public FrameSizeWizTopology getTopology() {
        return this.topology;
    }

    public int getTemplateType() {
        return this.generalConfigComposite.getTemplateType();
    }

    public HighResolutionCalendar getFrameInterval() {
        return this.generalConfigComposite.getFrameInterval();
    }

    public BigDecimal getFrameRate() {
        return this.generalConfigComposite.getFrameRate();
    }

    BigDecimal getThroughput(ThroughputType throughputType) {
        return this.generalConfigComposite.getThroughput(throughputType);
    }

    public DataRateUnit getThroughputUnit() {
        return this.generalConfigComposite.getThroughputUnit();
    }

    public FlowSizeComposite.FlowSizeType getFlowSizeType() {
        return this.generalConfigComposite.getFlowSizeType();
    }

    public HighResolutionCalendar getDuration() {
        return this.generalConfigComposite.getDuration();
    }

    public BigInteger getNofFrames() {
        return this.generalConfigComposite.getNofFrames();
    }
}

