/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.views.batch.BatchView;
import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizGeneralConfigPage;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizIntroPage;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizPortConfigPage;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.ScenarioFlowStartEvent;
import com.excentis.products.byteblower.model.ScenarioFlowStopEvent;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.BatchActionController;
import com.excentis.products.byteblower.model.control.BatchController;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameBlastingFrameController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;

public class FrameSizeWizard
extends Wizard {
    private FrameSizeWizIntroPage introPage = null;
    private FrameSizeWizGeneralConfigPage generalConfigPage = null;
    private FrameSizeWizPortConfigPage sourcePortPage = null;
    private ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
    private FrameBlastingFlow tempFlowTemplate = this.factory.createFrameBlastingFlow();
    private Flow frameSizeWizFlow = this.factory.createFlow();
    private FlowMeasurement flowMeasurement = this.factory.createFlowMeasurement();
    private int numberOfDestinationPorts = 0;
    private List<FrameSizeWizPortConfigPage> destinationPortPageList = new ArrayList<FrameSizeWizPortConfigPage>();
    private List<String> takenPortNames = new ArrayList<String>();
    private String templateName = null;
    private String scenarioName = null;
    private String flowName = null;

    public FrameSizeWizard() {
        this.init();
    }

    public int getNumberOfDestinations() {
        return this.numberOfDestinationPorts;
    }

    public void setNumberOfDestinations(int newNumberOfPorts) {
        if (newNumberOfPorts > this.numberOfDestinationPorts) {
            while (newNumberOfPorts > this.destinationPortPageList.size()) {
                FrameSizeWizPortConfigPage newPage = new FrameSizeWizPortConfigPage(this, false, this.destinationPortPageList.size() + 1);
                this.destinationPortPageList.add(newPage);
                this.addPage(2 + this.destinationPortPageList.size(), (IWizardPage)newPage);
            }
        } else if (newNumberOfPorts < this.numberOfDestinationPorts) {
            int i = this.numberOfDestinationPorts;
            while (i > newNumberOfPorts) {
                FrameSizeWizPortConfigPage page = this.destinationPortPageList.get(i - 1);
                this.removePage((IWizardPage)page);
                page.dispose();
                this.destinationPortPageList.remove(i - 1);
                --i;
            }
        }
        this.numberOfDestinationPorts = newNumberOfPorts;
    }

    private void init() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        for (ByteBlowerGuiPort port : project.getByteBlowerGuiPort()) {
            this.takenPortNames.add(port.getName());
        }
        this.tempFlowTemplate.setFrameInterval(new HighResolutionCalendar("1000000"));
        this.frameSizeWizFlow.setFlowTemplate((FlowTemplate)this.tempFlowTemplate);
        ScenarioFlowStartEvent start = ByteblowerguimodelFactoryImpl.eINSTANCE.createScenarioFlowStartEvent();
        ScenarioFlowStopEvent stop = ByteblowerguimodelFactoryImpl.eINSTANCE.createScenarioFlowStopEvent();
        this.flowMeasurement.setFlowStartEvent(start);
        this.flowMeasurement.setFlowStopEvent(stop);
        this.flowMeasurement.setFlow(this.frameSizeWizFlow);
        FlowMeasurementController controller = new FlowMeasurementController(this.flowMeasurement);
        controller.setNumberOfFrames(Long.valueOf(1000L)).execute();
    }

    @Override
    public boolean performCancel() {
        return super.performCancel();
    }

    private EList<ByteBlowerGuiPort> getDestinationPorts() {
        UniqueEList destinations = new UniqueEList();
        for (FrameSizeWizPortConfigPage destPage : this.destinationPortPageList) {
            destinations.add((Object)destPage.getPort());
        }
        return destinations;
    }

    @Override
    public boolean performFinish() {
        CompoundCommandController compoundController = CompoundCommandController.createStrictInstance((boolean)true);
        this.setNeedsProgressMonitor(false);
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        if (projectController == null) {
            return false;
        }
        UniqueEList ports = new UniqueEList();
        ports.add((Object)this.sourcePortPage.getPort());
        ports.addAll(this.getDestinationPorts());
        compoundController.appendCommand(this.createDhcp((Collection<ByteBlowerGuiPort>)ports));
        compoundController.appendCommand(projectController.createAddByteBlowerGuiPortCommand(this.sourcePortPage.getPort()));
        compoundController.appendCommand(projectController.createAddByteBlowerGuiPortCommand(this.getDestinationPorts()));
        EList<Scenario> scenarios = this.generateScenarios(compoundController, projectController);
        Batch batch = this.createBatch(compoundController, projectController, (List<Scenario>)scenarios);
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Frame Size Wizard", compoundController.unwrap());
        operation.run();
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.autoDock((ByteBlowerProjectReader)projectController);
        BatchView.showAndSelect(batch);
        return true;
    }

    private Command createDhcp(Collection<ByteBlowerGuiPort> ports) {
        Dhcp dhcp = null;
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPort port : ports) {
            if (port.getIpv4Configuration().getAddressConfiguration() != Ipv4AddressConfigType.DHC_PV4) continue;
            if (dhcp == null) {
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(ByteBlowerGuiResourceController.getProject());
                ByteBlowerProjectController.CommandWithDhcpListReference commandWithRef = projectController.addDhcp();
                compound.appendCommand(commandWithRef.getCommand());
                DhcpController dhcpController = (DhcpController)((List)commandWithRef.getCommandReference()).get(0);
                dhcp = (Dhcp)dhcpController.getObject();
            }
            ByteBlowerGuiPortController controller = new ByteBlowerGuiPortController(port);
            Ipv4ConfigurationController ipv4ConfigurationController = controller.getIpv4ConfigurationController();
            ipv4ConfigurationController.setDhcp(dhcp).getCommand().execute();
        }
        return compound.unwrap();
    }

    private Batch createBatch(CompoundCommandController compoundController, ByteBlowerProjectController byteblowerProjectController, List<Scenario> scenarios) {
        BatchController batchController;
        BatchController.CommandWithBatchActionListReference commandWithBatchActionListReference;
        ByteBlowerProjectController.CommandWithBatchListReference commandWithBatchListReference = byteblowerProjectController.addBatches("Frame Size Batch 1", 1, -1);
        compoundController.appendCommand(commandWithBatchListReference.getCommand());
        List batchControllers = (List)commandWithBatchListReference.getCommandReference();
        if (batchControllers != null && batchControllers.size() > 0 && (commandWithBatchActionListReference = (batchController = (BatchController)batchControllers.get(0)).addBatchActions(scenarios.size(), -1)) != null) {
            List batchActionControllers = (List)commandWithBatchActionListReference.getCommandReference();
            compoundController.appendCommand(commandWithBatchActionListReference.getCommand());
            int scenarioIndex = 0;
            for (BatchActionController batchActionController : batchActionControllers) {
                if (scenarioIndex >= scenarios.size()) break;
                compoundController.appendCommand(batchActionController.setScenario(scenarios.get(scenarioIndex++)));
            }
        }
        return (Batch)((BatchController)batchControllers.get(0)).getObject();
    }

    private EList<Scenario> generateScenarios(CompoundCommandController compoundController, final ByteBlowerProjectController byteblowerProjectController) {
        UniqueEList scenarios = new UniqueEList();
        List<Frame> frames = this.generalConfigPage.getFrames();
        final ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        for (Frame frame : frames) {
            compoundController.appendCommand(byteblowerProjectController.createAddFrameCommand(frame));
            FrameBlastingFlow dummy = ByteblowerguimodelFactory.eINSTANCE.createFrameBlastingFlow();
            if (this.templateName == null) {
                this.templateName = "Frame Size FlowTemplate 1";
                if (!OldNamingTools.nameIsUnique((ByteBlowerProject)project, (EObject)dummy, (String)this.templateName)) {
                    this.templateName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)dummy, (String)this.templateName);
                }
            } else {
                this.templateName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)dummy, (String)this.templateName);
            }
            ByteBlowerProjectController.CommandWithFrameBlastingFlowListReference ref = byteblowerProjectController.addFrameBlastingFlows(this.templateName, 1, -1);
            compoundController.appendCommand(ref.getCommand());
            UniqueEList newFrameBlastingFlowControllers = (UniqueEList)ref.getCommandReference();
            final FrameBlastingFlowController setController = (FrameBlastingFlowController)newFrameBlastingFlowControllers.get(0);
            FrameBlastingFlowController.CommandWithFrameBlastingFrameListReference commandWithRef = setController.addFrameBlastingFrame();
            compoundController.appendCommand(commandWithRef.getCommand());
            FrameBlastingFrameController frameBlastingFrameController = (FrameBlastingFrameController)((List)commandWithRef.getCommandReference()).get(0);
            compoundController.appendCommand(frameBlastingFrameController.setFrame(frame));
            FrameBlastingFlow newTemplate = (FrameBlastingFlow)setController.getObject();
            switch (this.generalConfigPage.getTemplateType()) {
                case 2: {
                    compoundController.appendCommand(setController.checkAndSetFrameInterval(this.generalConfigPage.getFrameInterval()));
                    break;
                }
                case 3: {
                    compoundController.appendCommand(setController.setFrameRate(this.generalConfigPage.getFrameRate()));
                    break;
                }
                case 0: {
                    compoundController.appendCommand((Command)new CommandWrapper(){

                        protected Command createCommand() {
                            BigDecimal throughput = FrameSizeWizard.this.generalConfigPage.getThroughput(byteblowerProjectController.getThroughputType());
                            return setController.setThroughput(throughput, DataRateUnit.BPS, project.getThroughputType(), false);
                        }
                    });
                    DataRateUnit unit = this.generalConfigPage.getThroughputUnit();
                    compoundController.appendCommand(setController.setDataRateUnit(unit));
                    break;
                }
                case 1: {
                    compoundController.appendCommand((Command)new CommandWrapper(){

                        protected Command createCommand() {
                            ThroughputType type = ThroughputType.FRAME_AND_ALL_OTHER_FIELDS;
                            BigDecimal throughput = FrameSizeWizard.this.generalConfigPage.getThroughput(type);
                            return setController.setThroughput(throughput, DataRateUnit.BPS, type, false);
                        }
                    });
                    DataRateUnit unit = this.generalConfigPage.getThroughputUnit();
                    compoundController.appendCommand(setController.setDataRateUnit(unit));
                }
            }
            Scenario scenarioDummy = ByteblowerguimodelFactoryImpl.eINSTANCE.createScenario();
            if (this.scenarioName == null) {
                this.scenarioName = "Frame Size Scenario 1";
                if (!OldNamingTools.nameIsUnique((ByteBlowerProject)project, (EObject)scenarioDummy, (String)this.scenarioName)) {
                    this.scenarioName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)scenarioDummy, (String)this.scenarioName);
                }
            } else {
                this.scenarioName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)scenarioDummy, (String)this.scenarioName);
            }
            ByteBlowerProjectController.CommandWithScenarioListReference reference = byteblowerProjectController.addScenarios(this.scenarioName, 1, -1);
            compoundController.appendCommand(reference.getCommand());
            UniqueEList newScenarioControllers = (UniqueEList)reference.getCommandReference();
            ScenarioController scenarioController = (ScenarioController)newScenarioControllers.get(0);
            scenarios.add((Object)((Scenario)scenarioController.getObject()));
            EList<Flow> flows = this.createFlows(compoundController, byteblowerProjectController, newTemplate, frame, false);
            if (this.generalConfigPage.isBidirectional()) {
                flows.addAll(this.createFlows(compoundController, byteblowerProjectController, newTemplate, frame, true));
            }
            for (Flow flow : flows) {
                ScenarioFlowEventController.CommandWithFlowMeasurementListReference info = scenarioController.addFlowMeasurement();
                compoundController.appendCommand(info.getCommand());
                UniqueEList controllers = (UniqueEList)info.getCommandReference();
                final FlowMeasurementController flowMeasurementController = (FlowMeasurementController)controllers.get(0);
                compoundController.appendCommand(flowMeasurementController.setFlow(flow));
                switch (this.generalConfigPage.getFlowSizeType()) {
                    case DURATION: {
                        HighResolutionCalendar duration = this.generalConfigPage.getDuration();
                        compoundController.appendCommand(flowMeasurementController.setDuration(duration));
                        break;
                    }
                    case NOF_FRAMES: {
                        compoundController.appendCommand((Command)new CommandWrapper(){

                            protected Command createCommand() {
                                BigInteger nofFrames = FrameSizeWizard.this.generalConfigPage.getNofFrames();
                                return flowMeasurementController.setNumberOfFrames(Long.valueOf(nofFrames.longValue()));
                            }
                        });
                        break;
                    }
                }
            }
        }
        return scenarios;
    }

    private EList<Flow> createFlows(CompoundCommandController compoundController, ByteBlowerProjectController byteblowerProjectController, FrameBlastingFlow flowTemplate, Frame frame, boolean bidirectional) {
        UniqueEList flows = new UniqueEList();
        ByteBlowerGuiPort source = this.sourcePortPage.getPort();
        EList<ByteBlowerGuiPort> destinations = this.getDestinationPorts();
        ByteBlowerProject project = (ByteBlowerProject)byteblowerProjectController.getObject();
        for (ByteBlowerGuiPort destination : destinations) {
            Flow dummy = ByteblowerguimodelFactory.eINSTANCE.createFlow();
            if (this.flowName == null) {
                this.flowName = "Frame Size Flow 1";
                if (!OldNamingTools.nameIsUnique((ByteBlowerProject)project, (EObject)dummy, (String)this.flowName)) {
                    this.flowName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)dummy, (String)this.flowName);
                }
            } else {
                this.flowName = OldNamingTools.getIncrementedName((ByteBlowerProject)project, (EObject)dummy, (String)this.flowName);
            }
            ByteBlowerProjectController.CommandWithFlowListReference info = byteblowerProjectController.addFlows(this.flowName, 1, -1);
            UniqueEList controllers = (UniqueEList)info.getCommandReference();
            compoundController.appendCommand(info.getCommand());
            FlowController controller = (FlowController)controllers.get(0);
            if (bidirectional) {
                compoundController.appendCommand(controller.setSource((AddressableSource)destination));
                compoundController.appendCommand(controller.setDestination((AddressableDestination)source));
            } else {
                compoundController.appendCommand(controller.setSource((AddressableSource)source));
                compoundController.appendCommand(controller.setDestination((AddressableDestination)destination));
            }
            Command command = controller.setFlowTemplate((FlowTemplate)flowTemplate);
            compoundController.appendCommand(command);
            flows.add((Object)((Flow)controller.getObject()));
        }
        return flows;
    }

    @Override
    public void addPages() {
        this.setWindowTitle("Frame Size Wizard");
        this.introPage = new FrameSizeWizIntroPage();
        this.addPage((IWizardPage)this.introPage);
        this.generalConfigPage = new FrameSizeWizGeneralConfigPage(this);
        this.addPage((IWizardPage)this.generalConfigPage);
        this.sourcePortPage = new FrameSizeWizPortConfigPage(this, true, 0);
        this.addPage((IWizardPage)this.sourcePortPage);
        this.setNumberOfDestinations(1);
    }

    public FlowMeasurement getAction() {
        return this.flowMeasurement;
    }

    @Override
    public boolean canFinish() {
        if (this.generalConfigPage == null || this.generalConfigPage.getFrames() == null || this.generalConfigPage.getFrames().size() == 0) {
            return false;
        }
        return super.canFinish();
    }

    public List<FrameSizeWizPortConfigPage> getDestinationPortPageList() {
        return this.destinationPortPageList;
    }

    public List<String> getTakenPortNames() {
        return this.takenPortNames;
    }

    void addTakenName(String portName) {
        this.takenPortNames.add(portName);
    }

    void removeTakenName(String portName) {
        this.takenPortNames.remove(portName);
    }
}

