/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.framesize.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.jface.viewers.BigIntegerCellEditor;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.table.TableColumnListener;
import com.excentis.products.byteblower.gui.utils.Defines;
import com.excentis.products.byteblower.gui.widgets.composites.FlowSizeComposite;
import com.excentis.products.byteblower.gui.widgets.composites.IRateCompositeListener;
import com.excentis.products.byteblower.gui.widgets.composites.RateComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.FrameLengthDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.IncrementFrameSizeDialog;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizTopology;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizard;
import com.excentis.products.byteblower.gui.wizards.framesize.composites.DeleteFrameAction;
import com.excentis.products.byteblower.gui.wizards.framesize.composites.FrameSizeWizCellModifier;
import com.excentis.products.byteblower.gui.wizards.framesize.composites.FrameSizeWizCellValidator;
import com.excentis.products.byteblower.gui.wizards.framesize.composites.WizardLabelProvider;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class FrameSizeWizGeneralConfigComposite
extends Composite
implements ModifyListener,
SelectionListener,
ControlListener,
MouseListener,
IRateCompositeListener {
    private FrameSizeWizard wizard;
    private List<Frame> frames = new ArrayList<Frame>(3);
    private static final int MIN_AMOUNT = 1;
    private static final int MAX_AMOUNT = 999;
    private DeleteFrameAction deleteAction;
    private FrameSizeWizTopology topology;
    private Button btnNew;
    private Button btnDelete;
    private Spinner spinFrameAmount;
    private Spinner spinDestinationAmount;
    private int[] selectedRowAndColumn = new int[2];
    private TableViewer tableViewer;
    private RateComposite rateComposite;
    private FlowSizeComposite flowSizeComposite;
    private Button chkBidirectional;
    private String[] framesColumnNames = new String[]{"Frame", "Size"};
    private static final ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(1), new ColumnWeightData(1)};
    private static final int popupPosChange = 0;
    private static final int popupPosSep1 = 1;
    private static final int popupPosDel = 2;
    private static final int popupPosSep2 = 3;
    private static final int popupPosCopyDown = 4;
    private static final int popupPosCopyDownInc = 5;
    private int frameSizeIncr;
    private boolean isHilited = false;
    static boolean allowEdit = true;

    public List<String> getColumnNames() {
        return Arrays.asList(this.framesColumnNames);
    }

    public FrameSizeWizGeneralConfigComposite(Composite parent, FrameSizeWizard wizard, FrameSizeWizTopology topology) {
        super(parent, 2048);
        this.wizard = wizard;
        this.topology = topology;
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
    }

    private void initialize() {
        GridLayout layout = new GridLayout(2, true);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText("Frame Sizes:");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(5, false));
        Label lblFrames = new Label((Composite)group, 0);
        lblFrames.setLayoutData((Object)new GridData(768));
        Label labelAmount = new Label((Composite)group, 131072);
        labelAmount.setText("Amount to create:");
        this.spinFrameAmount = new Spinner((Composite)group, 2048);
        this.spinFrameAmount.setMinimum(1);
        this.spinFrameAmount.setMaximum(999);
        this.btnNew = new Button((Composite)group, 0);
        this.btnNew.addSelectionListener((SelectionListener)this);
        this.btnDelete = new Button((Composite)group, 0);
        this.btnDelete.addSelectionListener((SelectionListener)this);
        Table table = new Table((Composite)group, 67586);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        table.addListener(3, (Listener)new TableColumnListener(table, this.selectedRowAndColumn));
        table.addMouseListener((MouseListener)this);
        this.tableViewer = new TableViewer(table);
        lblFrames.setText("Frames");
        this.btnNew.setText(Defines.BUTTON_NEW);
        this.btnDelete.setText(Defines.BUTTON_DELETE);
        this.deleteAction = new DeleteFrameAction(this);
        Menu menu = this.createPopupMenu(this);
        table.setMenu(menu);
        CellEditor[] editors = new CellEditor[this.framesColumnNames.length];
        editors[0] = null;
        BigIntegerCellEditor sizeEditor = new BigIntegerCellEditor((Composite)table, new BigInteger("9999"));
        sizeEditor.setValidator((ICellEditorValidator)new FrameSizeWizCellValidator());
        editors[1] = sizeEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new FrameSizeWizCellModifier(this));
        int i = 0;
        while (i < this.framesColumnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            String columnName = this.framesColumnNames[i];
            tableColumn.setText(columnName);
            ++i;
        }
        table.setHeaderVisible(true);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setColumnProperties(this.framesColumnNames);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public void notifyChanged(Notification notification) {
                int featureID;
                Object notifier = notification.getNotifier();
                if (notifier instanceof Frame) {
                    super.notifyChanged(notification);
                } else if (notifier instanceof ByteBlowerProject && (featureID = notification.getFeatureID(ByteBlowerProject.class)) == 9) {
                    super.notifyChanged(notification);
                }
            }

            public Object[] getElements(Object object) {
                return FrameSizeWizGeneralConfigComposite.this.frames.toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WizardLabelProvider((AdapterFactory)adapterFactory));
        this.tableViewer.setInput(this.frames);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FrameSizeWizGeneralConfigComposite.this.updateButtons();
            }
        });
        group = new Group((Composite)this, 0);
        group.setText("Speed");
        group.setLayout((Layout)new FillLayout());
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        this.createNewFrame(project, 100);
        this.createNewFrame(project, 200);
        this.createNewFrame(project, 300);
        this.rateComposite = new RateComposite((Composite)group, 0, ByteBlowerGuiResourceController.getProjectReader());
        group = new Group((Composite)this, 0);
        group.setText("Flow Size");
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new FillLayout());
        this.flowSizeComposite = new FlowSizeComposite((Composite)group, 0);
        group = new Group((Composite)this, 0);
        group.setText("Destinations");
        group.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        group.setLayout((Layout)gridLayout);
        Label lblDestinations = new Label((Composite)group, 0);
        lblDestinations.setText("Number of Destinations:");
        this.spinDestinationAmount = new Spinner((Composite)group, 2048);
        this.spinDestinationAmount.setMinimum(1);
        this.spinDestinationAmount.setMaximum(999);
        this.spinDestinationAmount.addModifyListener((ModifyListener)this);
        this.spinDestinationAmount.setLayoutData((Object)new GridData(768));
        group = new Group((Composite)this, 0);
        group.setText("Direction");
        group.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 5;
        group.setLayout((Layout)gridLayout);
        this.chkBidirectional = new Button((Composite)group, 32);
        this.chkBidirectional.setText("Bidirectional");
        this.chkBidirectional.addSelectionListener((SelectionListener)this);
        Spinner invisibleSpinForLayout = new Spinner((Composite)group, 2048);
        invisibleSpinForLayout.setVisible(false);
        this.rateComposite.addRateModificationListener((IRateCompositeListener)this);
        this.rateComposite.addSelectionListener((SelectionListener)this.flowSizeComposite);
        this.addControlListener(this);
        this.updateButtons();
    }

    private void updateButtons() {
        this.btnDelete.setEnabled(!this.tableViewer.getSelection().isEmpty());
    }

    public boolean isComplete() {
        return true;
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (control.isFocusControl() && control == this.spinDestinationAmount) {
            int nofDestinations = this.spinDestinationAmount.getSelection();
            this.wizard.setNumberOfDestinations(nofDestinations);
            this.topology.setNofDestinations(nofDestinations);
            this.topology.applyChanges(true);
        }
    }

    private Menu createPopupMenu(Composite parent) {
        Menu popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        ArmListener armForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                boolean enabled = ((MenuItem)e.getSource()).getEnabled();
                FrameSizeWizGeneralConfigComposite.this.hiliteCopyDownRange(enabled);
            }
        };
        ArmListener unArmForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                FrameSizeWizGeneralConfigComposite.this.hiliteCopyDownRange(false);
            }
        };
        MenuItem item = new MenuItem(popUpMenu, 8, 0);
        item.setText("Change");
        item.addArmListener(unArmForCopyDown);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameSizeWizGeneralConfigComposite.this.changeFrameSize();
            }
        });
        item = new MenuItem(popUpMenu, 2, 1);
        item = new MenuItem(popUpMenu, 8, 2);
        item.setText("Delete");
        item.addArmListener(unArmForCopyDown);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameSizeWizGeneralConfigComposite.this.deleteAction.run();
            }
        });
        item = new MenuItem(popUpMenu, 2, 3);
        item = new MenuItem(popUpMenu, 8, 4);
        item.setText("Copy Down");
        item.addArmListener(armForCopyDown);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameSizeWizGeneralConfigComposite.this.copyDown(false);
            }
        });
        item = new MenuItem(popUpMenu, 8, 5);
        item.setText("Copy Down Incrementing");
        item.addArmListener(armForCopyDown);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FrameSizeWizGeneralConfigComposite.this.copyDown(true);
                if (FrameSizeWizGeneralConfigComposite.this.selectedRowAndColumn[1] == 0) {
                    FrameSizeWizGeneralConfigComposite.this.copyDown(true);
                }
            }
        });
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                FrameSizeWizGeneralConfigComposite.this.hiliteCopyDownRange(false);
                super.menuHidden(e);
            }

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                boolean del = false;
                boolean copydown = false;
                boolean copyincr = false;
                Frame selectedFrame = (Frame)((StructuredSelection)FrameSizeWizGeneralConfigComposite.this.tableViewer.getSelection()).getFirstElement();
                if (selectedFrame != null) {
                    del = true;
                    switch (FrameSizeWizGeneralConfigComposite.this.selectedRowAndColumn[1]) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            copydown = true;
                            copyincr = true;
                            break;
                        }
                    }
                }
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                items[2].setImage(sharedImages.getImage(del ? "IMG_TOOL_DELETE" : "IMG_TOOL_DELETE_DISABLED"));
                items[4].setEnabled(copydown);
                items[5].setEnabled(copyincr);
            }
        });
        return popUpMenu;
    }

    private void copyDown(boolean incr) {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        Table table = this.tableViewer.getTable();
        TableItem sourceItem = table.getItem(this.selectedRowAndColumn[0]);
        Frame sourceFrame = (Frame)sourceItem.getData();
        int startIndex = table.getSelectionIndex();
        int selectionSize = selection.size();
        int size = this.getFrameSize(sourceFrame);
        Object previousObject = new Integer(size);
        if (incr && this.selectedRowAndColumn[1] == 1) {
            IncrementFrameSizeDialog dialog = new IncrementFrameSizeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            if (dialog.open() == 0) {
                this.frameSizeIncr = dialog.getIncrementSize();
            } else {
                return;
            }
        }
        int lastIndex = table.getItemCount();
        if (selectionSize == 1) {
            int i = startIndex + 1;
            while (i < lastIndex) {
                if ((previousObject = this.copyFrameDown(sourceFrame, i, incr, previousObject)) != null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = startIndex + 1;
            while (i < lastIndex) {
                Frame testFrame = (Frame)this.tableViewer.getElementAt(i);
                for (Frame destFrame : selection) {
                    if (testFrame == destFrame && (previousObject = this.copyFrameDown(sourceFrame, i, incr, previousObject)) == null) break;
                }
                ++i;
            }
        }
    }

    private int getFrameSize(Frame frame) {
        FrameReader reader = ReaderFactory.create((Frame)frame);
        int size = reader.getByteSize(ThroughputType.FRAME_ONLY);
        return size;
    }

    private Object copyFrameDown(Frame fromFrame, int row, boolean incr, Object previousObject) {
        Frame copyFrame = (Frame)this.tableViewer.getTable().getItem(row).getData();
        Integer returnObject = null;
        switch (this.selectedRowAndColumn[1]) {
            case 0: {
                break;
            }
            case 1: {
                int newSize = (Integer)previousObject;
                if (incr) {
                    newSize += this.frameSizeIncr;
                }
                if (newSize > 8192) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Copy Down Incrementing", (String)"The maximum Frame length was reached (8192 bytes)");
                    break;
                }
                this.resizeFrame(copyFrame, newSize);
                returnObject = new Integer(newSize);
                break;
            }
            default: {
                System.out.println("invalid case !");
                return "";
            }
        }
        return returnObject;
    }

    private void changeFrameSize() {
        int newLength;
        FrameLengthDialog dlg = new FrameLengthDialog(this.getShell());
        StructuredSelection sel = (StructuredSelection)this.tableViewer.getSelection();
        if (sel.size() != 1) {
            return;
        }
        Frame frame = (Frame)sel.getFirstElement();
        int oldLength = this.getFrameSize(frame);
        dlg.setLength(oldLength);
        if (dlg.open() == 0 && (newLength = dlg.getLength()) != oldLength) {
            this.resizeFrame(frame, newLength);
        }
    }

    private void hiliteCopyDownRange(boolean show) {
        StructuredSelection sel = (StructuredSelection)this.tableViewer.getSelection();
        if (sel.size() > 1) {
            return;
        }
        if (show == this.isHilited) {
            return;
        }
        this.isHilited = show;
        int selRow = this.selectedRowAndColumn[0];
        int selCol = this.selectedRowAndColumn[1];
        Table table = this.tableViewer.getTable();
        int i = selRow;
        while (i < table.getItemCount()) {
            Color color;
            TableItem row = table.getItem(i);
            if (show) {
                row.setData("oldColor" + selCol, (Object)row.getForeground(selCol));
                color = ExcentisColors.blue;
            } else {
                color = (Color)row.getData("oldColor" + selCol);
            }
            row.setForeground(selCol, color);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Control control = (Control)e.getSource();
        if (control == this.btnNew) {
            this.createNewFrames();
        } else if (control == this.btnDelete) {
            this.deleteSelectedFrames();
        } else if (control == this.chkBidirectional) {
            this.topology.setBidirectional(this.chkBidirectional.getSelection());
            this.topology.applyChanges(true);
        }
    }

    void deleteSelectedFrames() {
        StructuredSelection sel = (StructuredSelection)this.tableViewer.getSelection();
        for (Frame selectedFrame : sel) {
            this.deleteFrame(selectedFrame);
        }
        this.tableViewer.refresh();
        this.wizard.getContainer().updateButtons();
    }

    private void deleteFrame(Frame selectedFrame) {
        this.frames.remove(selectedFrame);
    }

    private void createNewFrames() {
        int amount = this.spinFrameAmount.getSelection();
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        int i = 0;
        while (i < amount) {
            this.createNewFrame(project);
            ++i;
        }
        this.wizard.getContainer().updateButtons();
    }

    private void createNewFrame(ByteBlowerProject project, int size) {
        Frame newFrame = this.createNewFrame(project);
        this.resizeFrame(newFrame, size);
    }

    private Frame createNewFrame(ByteBlowerProject project) {
        Frame newFrame = ByteblowerguimodelFactoryImpl.eINSTANCE.createFrame();
        FrameController.initializeFrame_Ipv4_UDP((Frame)newFrame);
        ArrayList<String> takenNames = new ArrayList<String>();
        for (Frame frame : project.getFrame()) {
            takenNames.add(frame.getName());
        }
        for (Frame frame : this.frames) {
            takenNames.add(frame.getName());
        }
        String frameName = "Frame Size Frame ";
        frameName = OldNamingTools.getIncrementedName((String)frameName, takenNames);
        newFrame.setName(frameName);
        this.frames.add(newFrame);
        this.tableViewer.refresh();
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)newFrame));
        return newFrame;
    }

    private void tableLayout() {
        TableLayout tableLayout = new TableLayout();
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        int i = 0;
        while (i < columnLayouts.length) {
            tableLayout.addColumnData(columnLayouts[i]);
            ++i;
        }
    }

    public void controlResized(ControlEvent e) {
        this.tableLayout();
    }

    public void controlMoved(ControlEvent e) {
    }

    void resizeFrame(Frame frame, int size) {
        FrameController controller = ControllerFactory.create((Frame)frame);
        Command command = controller.setFrameSize(size);
        if (command != null) {
            command.execute();
        }
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public boolean isBidirectional() {
        return this.chkBidirectional.getSelection();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        allowEdit = e.button == 1;
    }

    public void mouseUp(MouseEvent e) {
    }

    public int getTemplateType() {
        return this.rateComposite.getFixedType();
    }

    public HighResolutionCalendar getFrameInterval() {
        return this.rateComposite.getFrameInterval();
    }

    public BigDecimal getFrameRate() {
        return this.rateComposite.getFrameRate();
    }

    public BigDecimal getThroughput(ThroughputType throughputType) {
        return this.rateComposite.getThroughput(throughputType);
    }

    public DataRateUnit getThroughputUnit() {
        return this.rateComposite.getThroughputUnit();
    }

    public void rateChanged() {
    }

    public FlowSizeComposite.FlowSizeType getFlowSizeType() {
        return this.flowSizeComposite.getFlowSizeType();
    }

    public HighResolutionCalendar getDuration() {
        return this.flowSizeComposite.getDuration();
    }

    public BigInteger getNofFrames() {
        return this.flowSizeComposite.getNofFrames();
    }
}

