/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.fullmeshwizard;

import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.AddressConfigurationPage;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.FlowConfigurationWizardPage;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.Messages;
import com.excentis.products.byteblower.gui.wizards.fullmeshwizard.TopologyConfigurationPage;
import com.excentis.products.byteblower.gui.wizards.pages.GenericIntroPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

class FullMeshWizard
extends Wizard {
    private GenericIntroPage introPage;
    private int numberOfPorts = 0;
    private List<AddressConfigurationPage> portPageList = new ArrayList<AddressConfigurationPage>();

    public FullMeshWizard() {
        this.setNeedsProgressMonitor(false);
    }

    @Override
    public void addPages() {
        this.setWindowTitle("Full Mesh Test Wizard");
        this.introPage = new GenericIntroPage(Messages.getString("IntroPage.Title"), Messages.getString("IntroPage.Description"), Messages.getString("IntroPage.IntroductionText"), "images/mesh.png", "images/mesh.png");
        this.addPage((IWizardPage)this.introPage);
        TopologyConfigurationPage topologyPage = new TopologyConfigurationPage();
        this.addPage((IWizardPage)topologyPage);
        FlowConfigurationWizardPage flowPage = new FlowConfigurationWizardPage();
        this.addPage((IWizardPage)flowPage);
    }

    @Override
    public boolean performFinish() {
        return true;
    }

    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public void setNumberOfPorts(int newNumberOfPorts) {
        if (newNumberOfPorts > this.numberOfPorts) {
            while (newNumberOfPorts > this.portPageList.size()) {
                AddressConfigurationPage newPage = new AddressConfigurationPage(this.portPageList.size() + 1);
                this.portPageList.add(newPage);
                this.addPage(1 + this.portPageList.size(), (IWizardPage)newPage);
            }
        } else if (newNumberOfPorts < this.numberOfPorts) {
            int i = this.numberOfPorts;
            while (i > newNumberOfPorts) {
                AddressConfigurationPage page = this.portPageList.get(i - 1);
                this.removePage((IWizardPage)page);
                page.dispose();
                this.portPageList.remove(i - 1);
                --i;
            }
        }
        this.numberOfPorts = newNumberOfPorts;
    }
}

