/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.newproject;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.WizardLauncher;
import com.excentis.products.byteblower.gui.swt.ImageDataFactory;
import com.excentis.products.byteblower.gui.widgets.dialogs.GeneralPropertiesComposite;
import com.excentis.products.byteblower.gui.widgets.project.EclipseProjectResource;
import com.excentis.products.byteblower.gui.wizards.newproject.Messages;
import com.excentis.products.byteblower.gui.wizards.newproject.NewProjectPage;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

final class NewProjectPageContent
extends SashForm {
    private static final String SAMPLE_FILENAME_POST = ".bbp";
    private final ArrayList<WizardLauncher> wizLaunchers = new ArrayList(WizardLauncher.wizards());
    private ImageData imageData = null;
    private Canvas imageGroup = null;
    private Composite labelGroup = null;
    private Composite labelTopGroup = null;
    private Composite labelBottomGroup = null;
    private Text authorNameField;
    private NewProjectPage page;
    private boolean useDefaults = true;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private String initialLocationFieldValue;
    private String projectName;
    private String authorName;
    private String location;
    private WizardLauncher selectedWizard;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = NewProjectPageContent.this.validatePage();
            NewProjectPageContent.this.page.setPageComplete(valid);
        }
    };
    private Combo wizardsSelection;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            NewProjectPageContent.this.page.setPageComplete(NewProjectPageContent.this.validatePage());
        }
    };

    public String getProjectName() {
        return this.projectName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getProjectLocation() {
        return this.location;
    }

    NewProjectPageContent(Composite parent, NewProjectPage page, int style, String imageFile, String text) {
        super(parent, style);
        this.getShell().setMinimumSize(new Point(600, 500));
        this.getShell().setSize(new Point(600, 500));
        this.initialize();
        this.setImage(imageFile);
        this.page = page;
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                NewProjectPageContent.this.imageGroup.setFocus();
            }
        });
    }

    private void initialize() {
        GridLayout localGridlayout = new GridLayout(2, false);
        localGridlayout.numColumns = 2;
        localGridlayout.marginWidth = 5;
        localGridlayout.marginHeight = 5;
        localGridlayout.horizontalSpacing = 5;
        localGridlayout.verticalSpacing = 5;
        this.setLayout((Layout)localGridlayout);
        this.imageGroup = new Canvas((Composite)this, 0);
        this.imageGroup.setBackground(ColorConstants.white);
        this.imageGroup.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.labelGroup = new Composite((Composite)this, 2048);
        this.labelGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        GridLayout labelGridlayout = new GridLayout();
        this.labelGroup.setLayout((Layout)labelGridlayout);
        this.labelTopGroup = new Composite(this.labelGroup, 0);
        this.labelTopGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout topGridlayout = new GridLayout();
        topGridlayout.numColumns = 2;
        topGridlayout.marginWidth = 5;
        topGridlayout.marginHeight = 5;
        topGridlayout.horizontalSpacing = 5;
        topGridlayout.verticalSpacing = 5;
        this.labelTopGroup.setLayout((Layout)topGridlayout);
        this.labelBottomGroup = new Composite(this.labelGroup, 0);
        this.labelBottomGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout bottomGridlayout = new GridLayout();
        bottomGridlayout.numColumns = 1;
        this.labelBottomGroup.setLayout((Layout)bottomGridlayout);
        Label oLabelProjectName = new Label(this.labelTopGroup, 0);
        this.projectNameField = new Text(this.labelTopGroup, 2048);
        this.projectNameField.setTextLimit(60);
        this.projectNameField.addVerifyListener(GeneralPropertiesComposite.noAccentOrPercent);
        Label oLabelAuthorName = new Label(this.labelTopGroup, 0);
        this.authorNameField = new Text(this.labelTopGroup, 2048);
        this.authorNameField.setTextLimit(60);
        this.authorNameField.addVerifyListener(GeneralPropertiesComposite.noAccentOrPercent);
        String startName = ByteBlowerPreferences.getDefaultAuthor();
        if (startName != null) {
            this.authorNameField.setText(startName);
        }
        oLabelProjectName.setText("Project Name:");
        oLabelAuthorName.setText("Author:");
        Label oLabelWizards = new Label(this.labelTopGroup, 0);
        oLabelWizards.setText("From wizard:");
        this.wizardsSelection = new Combo(this.labelTopGroup, -1);
        String[] names = new String[this.wizLaunchers.size()];
        int ctr = 0;
        while (ctr < names.length) {
            names[ctr] = this.wizLaunchers.get(ctr).name();
            ++ctr;
        }
        this.wizardsSelection.setItems(names);
        this.wizardsSelection.select(0);
        this.wizardsSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectPageContent.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NewProjectPageContent.this.validatePage();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        oLabelProjectName.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        this.projectNameField.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, false, false);
        oLabelAuthorName.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0x1000000, true, false);
        this.authorNameField.setLayoutData((Object)gridData);
        this.createProjectLocationGroup(this.labelBottomGroup);
        if (this.customLocationFieldValue != null) {
            String suggestion = this.suggestProjectName(this.customLocationFieldValue);
            this.projectNameField.setText(suggestion);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
        this.authorNameField.addListener(24, this.nameModifyListener);
        int[] weights = new int[]{20, 80};
        this.setWeights(weights);
        this.doAsyncVerification();
    }

    private void doAsyncVerification() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewProjectPageContent.this.page.setPageComplete(NewProjectPageContent.this.validatePage());
            }
        });
    }

    private String suggestProjectName(String verifyPath) {
        String defaultProjectName = String.valueOf(ByteBlowerPreferences.getDefaultProjectName()) + "_";
        String result = String.valueOf(defaultProjectName) + "1";
        File targetPath = new File(verifyPath);
        File[] files = targetPath.listFiles();
        Pattern regex = Pattern.compile(String.valueOf(defaultProjectName) + "([0-9]+)" + SAMPLE_FILENAME_POST);
        TreeSet<Integer> forbiddenIdx = new TreeSet<Integer>();
        if (targetPath.isDirectory() && files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File exist = fileArray[n2];
                String name = exist.getName();
                Matcher match = regex.matcher(name);
                if (match.matches() && match.groupCount() >= 1) {
                    try {
                        int value = Integer.parseInt(match.group(1));
                        forbiddenIdx.add(value);
                    }
                    catch (NumberFormatException ex) {
                        Logger.getGlobal().log(Level.INFO, "Unintended number", ex);
                    }
                }
                ++n2;
            }
            int ctr = 1;
            while (ctr < Integer.MAX_VALUE) {
                if (!forbiddenIdx.contains(ctr)) {
                    result = String.valueOf(defaultProjectName) + ctr;
                    break;
                }
                ++ctr;
            }
        }
        return result;
    }

    private void setImage(String imageFile) {
        this.imageData = ImageDataFactory.instance().create(imageFile);
        this.imageGroup.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                Rectangle r = NewProjectPageContent.this.imageGroup.getClientArea();
                Image image = new Image((Device)event.display, NewProjectPageContent.this.imageData);
                int x = (r.width - 106) / 2;
                int y = (r.height - 208) / 2;
                gc.drawImage(image, x, y);
                image.dispose();
            }
        });
    }

    public void addControlListener(ControlListener listener) {
        super.addControlListener(listener);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Font font = this.getFont();
        Group projectGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(font);
        projectGroup.setText(Messages.getString("WizardNewProjectCreationPage_projectContentsGroupLabel"));
        final Button useDefaultsButton = new Button((Composite)projectGroup, 131104);
        useDefaultsButton.setText(Messages.getString("WizardNewProjectCreationPage_useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setFont(font);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup((Composite)projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectPageContent.this.useDefaults = useDefaultsButton.getSelection();
                NewProjectPageContent.this.browseButton.setEnabled(!NewProjectPageContent.this.useDefaults);
                NewProjectPageContent.this.locationPathField.setEnabled(!NewProjectPageContent.this.useDefaults);
                NewProjectPageContent.this.locationLabel.setEnabled(!NewProjectPageContent.this.useDefaults);
                if (NewProjectPageContent.this.useDefaults) {
                    NewProjectPageContent.this.customLocationFieldValue = NewProjectPageContent.this.locationPathField.getText();
                } else {
                    NewProjectPageContent.this.locationPathField.setText(NewProjectPageContent.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        Font font = projectGroup.getFont();
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(Messages.getString("WizardNewProjectCreationPage_locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationLabel.setFont(font);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(Messages.getString("WizardNewProjectCreationPage_browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewProjectPageContent.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.browseButton.setFont(font);
        if (this.initialLocationFieldValue == null) {
            String initialLocation = EclipseProjectResource.getDefaultProjectLocation();
            this.locationPathField.setText(initialLocation);
        } else {
            this.locationPathField.setText(this.initialLocationFieldValue);
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
        this.customLocationFieldValue = this.locationPathField.getText();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(Messages.getString("WizardNewProjectCreationPage_directoryLabel"));
        String dirName = this.locationPathField.getText().trim();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    private boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.projectName = this.projectNameField.getText().trim();
        if (this.projectName.equals("")) {
            this.page.setErrorMessage(null);
            this.page.setMessage(Messages.getString("WizardNewProjectCreationPage_projectNameEmpty"));
            return false;
        }
        this.authorName = this.authorNameField.getText().trim();
        if (this.authorName.equals("")) {
            this.page.setErrorMessage(null);
            this.page.setMessage(Messages.getString("NewProjectPage.AuthorEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(this.projectName, 4);
        if (!nameStatus.isOK()) {
            this.page.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        this.location = this.locationPathField.getText().trim();
        if (this.location.equals("")) {
            this.page.setErrorMessage(null);
            this.page.setMessage(Messages.getString("WizardNewProjectCreationPage_projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(this.location)) {
            this.page.setErrorMessage(Messages.getString("WizardNewProjectCreationPage_locationError"));
            return false;
        }
        String selectedName = this.wizardsSelection.getText();
        for (WizardLauncher launcher : this.wizLaunchers) {
            if (!selectedName.equals(launcher.name())) continue;
            this.selectedWizard = launcher;
            break;
        }
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        return true;
    }

    public WizardLauncher getSelectedWizard() {
        return this.selectedWizard;
    }
}

