/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.rfc2544;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.swt.widgets.text.DoubleTextFactory;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.model.BenchmarkFrame;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.reader.FrameBlastingBenchmarkReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class GeneralConfiguration
extends WizardPage {
    private static final String title = "RFC 2544 General configuration";
    private static final HighResolutionCalendar DEFAULT_ITERATION_DURATION = new HighResolutionCalendar(Long.valueOf(120000000000L));
    private static final double DEFAULT_LOSS = 0.0;
    private static final double DEFAULT_RESOLUTION = 0.001;
    private int[] defaultSizes = new int[]{60, 128, 1024, 1500};
    private CSVFormatter formatter;
    private Text iterationDurationText;
    private Text lossText;
    private double resolution;
    private HighResolutionCalendar iterationDuration;
    private double loss;
    private final boolean hasDuration;
    private Label durationLabel;

    public GeneralConfiguration(boolean hasDuration) {
        super(title);
        this.setTitle(title);
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/framesizewizard.gif"));
        this.iterationDuration = DEFAULT_ITERATION_DURATION;
        this.loss = 0.0;
        this.resolution = 0.001;
        this.hasDuration = hasDuration;
    }

    public GeneralConfiguration() {
        this(true);
    }

    public GeneralConfiguration(FrameBlastingBenchmark benchmark) {
        super(title);
        this.setTitle(title);
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/framesizewizard.gif"));
        this.hasDuration = false;
        this.iterationDuration = benchmark.getDuration();
        this.loss = benchmark.getAcceptableLoss() * 100.0;
        this.resolution = benchmark.getResolution();
        EList currentSizes = benchmark.getFrames();
        this.defaultSizes = new int[currentSizes.size()];
        int idx = 0;
        while (idx < currentSizes.size()) {
            this.defaultSizes[idx] = ((BenchmarkFrame)currentSizes.get(idx)).getSize();
            ++idx;
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        Label frameSizes = new Label(container, 128);
        frameSizes.setText("Frame sizes");
        Text frameTxt = new Text(container, 2048);
        this.formatter = new CSVFormatter(frameTxt, 60, 8192, false);
        this.formatter.setValues(this.defaultSizes);
        frameTxt.setLayoutData((Object)new GridData(768));
        Label frameSizesHelp = new Label(container, 128);
        frameSizesHelp.setText("\t On which frames do you want to measure? Sizes are counted without CRC\n Use a comma to separate them.\n A common list is 60,128,512,1024,1500\n");
        FontData fontData = frameSizes.getFont().getFontData()[0];
        Font font = new Font((Device)frameSizesHelp.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        frameSizesHelp.setFont(font);
        GridData gridDataFrameHelp = new GridData();
        gridDataFrameHelp.horizontalSpan = 2;
        frameSizesHelp.setLayoutData((Object)gridDataFrameHelp);
        if (this.hasDuration) {
            Label iterationLength = new Label(container, 128);
            iterationLength.setText("Duration of a single iteration");
            this.iterationDurationText = TimeTextFactory.instance().create(container, 2048);
            this.iterationDurationText.setText(HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.iterationDuration));
            this.iterationDurationText.setLayoutData((Object)new GridData(768));
            this.iterationDurationText.addModifyListener((ModifyListener)new DurationHook());
            this.iterationDurationText.addModifyListener((ModifyListener)new UpdateDuration());
            frameTxt.addModifyListener((ModifyListener)new UpdateDuration());
            Label iterationLengthHelp = new Label(container, 128);
            iterationLengthHelp.setText("\t Over how long should we measure the loss? Remember, RFC-2544 repeats this step many times. \n");
            iterationLengthHelp.setFont(font);
            GridData gridDataIterHelp = new GridData();
            gridDataIterHelp.horizontalSpan = 2;
            iterationLengthHelp.setLayoutData((Object)gridDataIterHelp);
        }
        Label acceptableLoss = new Label(container, 128);
        acceptableLoss.setText("Acceptable loss (%)");
        this.lossText = DoubleTextFactory.instance().create(container, 2048, 2, 100.0);
        this.lossText.setText(Double.toString(this.loss));
        this.lossText.setLayoutData((Object)new GridData(768));
        this.lossText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    GeneralConfiguration.this.loss = Double.parseDouble(GeneralConfiguration.this.lossText.getText()) / 100.0;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        Label acceptLossHelp = new Label(container, 128);
        acceptLossHelp.setText("\t How much traffic can the network lose? 0% is no frame lost. Pick 1% for a good default. \n");
        acceptLossHelp.setFont(font);
        GridData gridDataAcceptLoss = new GridData();
        gridDataAcceptLoss.horizontalSpan = 2;
        acceptLossHelp.setLayoutData((Object)gridDataAcceptLoss);
        if (this.hasDuration) {
            this.durationLabel = new Label(container, 128);
            this.durationLabel.setLayoutData((Object)new GridData(768));
            Label durationHelp = new Label(container, 128);
            durationHelp.setText("\t Overal expected duration of the test");
            durationHelp.setFont(font);
            GridData durationGrid = new GridData();
            durationGrid.horizontalSpan = 2;
            durationHelp.setLayoutData((Object)durationGrid);
            this.updateTotalDurationLabel();
        }
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
    }

    public List<Integer> getSizes() {
        return Collections.unmodifiableList(this.formatter.getValues());
    }

    private void updateTotalDurationLabel() {
        int nofFrames = this.formatter.getValues().size();
        HighResolutionDuration totalDuration = FrameBlastingBenchmarkReader.getEstimatedDuration((HighResolutionCalendar)this.iterationDuration, (int)nofFrames);
        String strDuration = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)totalDuration);
        this.durationLabel.setText(String.format("Total time: %s", strDuration));
    }

    public double getLoss() {
        return this.loss;
    }

    public HighResolutionCalendar getIterationDuration() {
        return this.iterationDuration;
    }

    public double getResolution() {
        return this.resolution;
    }

    private static final class CSVFormatter
    implements VerifyListener,
    ModifyListener,
    FocusListener {
        private final Text frameTxt;
        private final int minVal;
        private final int maxVal;
        private final boolean allowRepeated;
        private List<Integer> vals = Collections.emptyList();

        private CSVFormatter(Text frameTxt, int minVal, int maxVal, boolean allowRepeated) {
            this.frameTxt = frameTxt;
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.allowRepeated = allowRepeated;
            frameTxt.addModifyListener((ModifyListener)this);
            frameTxt.addVerifyListener((VerifyListener)this);
            frameTxt.addFocusListener((FocusListener)this);
        }

        private static String neatString(List<Integer> values) {
            String separator = "";
            StringBuilder txt = new StringBuilder();
            for (int val : values) {
                txt.append(separator);
                txt.append(val);
                separator = ", ";
            }
            return txt.toString();
        }

        private List<Integer> getParts(String txt) {
            List<Integer> errorResult = Collections.emptyList();
            String[] subStrings = txt.split("(,|;|\\|)");
            ArrayList<Integer> result = new ArrayList<Integer>();
            HashSet<Integer> seen = new HashSet<Integer>();
            String[] stringArray = subStrings;
            int n = subStrings.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    String part = stringArray[n2];
                    try {
                        Integer intVal = Integer.parseInt(part.trim());
                        if (this.minVal <= intVal && intVal <= this.maxVal && (this.allowRepeated || !seen.contains(intVal))) {
                            result.add(intVal);
                            seen.add(intVal);
                            break block4;
                        }
                        return errorResult;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.frameTxt.setForeground(ExcentisColors.red);
                        return errorResult;
                    }
                }
                ++n2;
            }
            return result;
        }

        public void setValues(List<Integer> values) {
            String txt = CSVFormatter.neatString(values);
            this.frameTxt.setText(txt.toString());
        }

        public void setValues(int ... values) {
            ArrayList<Integer> listValues = new ArrayList<Integer>();
            int[] nArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                listValues.add(i);
                ++n2;
            }
            this.setValues(listValues);
        }

        public void verifyText(VerifyEvent e) {
            Color DEFAULT_COLOR = null;
            String txt = this.frameTxt.getText();
            List<Integer> parsed = this.getParts(txt = String.valueOf(txt.substring(0, e.start)) + e.text + txt.substring(e.end, txt.length()));
            if (parsed.isEmpty()) {
                this.frameTxt.setForeground(ExcentisColors.red);
            } else {
                this.frameTxt.setForeground(DEFAULT_COLOR);
            }
        }

        public void modifyText(ModifyEvent e) {
            String txt = this.frameTxt.getText();
            this.vals = this.getParts(txt);
        }

        public List<Integer> getValues() {
            return this.vals;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (!this.vals.isEmpty()) {
                this.frameTxt.setText(CSVFormatter.neatString(this.vals));
            }
        }
    }

    private final class DurationHook
    implements ModifyListener {
        private DurationHook() {
        }

        public void modifyText(ModifyEvent e) {
            String txt = GeneralConfiguration.this.iterationDurationText.getText();
            HighResolutionCalendar output = new HighResolutionCalendar();
            HighResolutionCalendarParser.parseToRelativeTime((String)txt, (HighResolutionCalendar)output);
            GeneralConfiguration.this.iterationDuration = output;
        }
    }

    private final class UpdateDuration
    implements ModifyListener {
        private UpdateDuration() {
        }

        public void modifyText(ModifyEvent arg0) {
            GeneralConfiguration.this.updateTotalDurationLabel();
        }
    }
}

