/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.rfc2544;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.rfc2544.GeneralConfiguration;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingBenchmarkController;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class RFC2544EditWizard
extends Wizard {
    private GeneralConfiguration generalConfig;
    private FrameBlastingBenchmark benchmark;

    public RFC2544EditWizard(FrameBlastingBenchmark benchmark) {
        this.generalConfig = new GeneralConfiguration(benchmark);
        this.benchmark = benchmark;
    }

    @Override
    public boolean performFinish() {
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        if (projectController == null) {
            return false;
        }
        this.updateThroughputTest(compoundController, projectController, this.generalConfig.getSizes());
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(projectController.getProject(), "RFC-2544 Wizard", compoundController.unwrap());
        operation.run();
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.autoDock((ByteBlowerProjectReader)projectController);
        return true;
    }

    private void updateThroughputTest(CompoundCommandController compoundController, ByteBlowerProjectController projectController, List<Integer> frames) {
        FrameBlastingBenchmarkController benchmarkTemplate = ControllerFactory.create((FrameBlastingBenchmark)this.benchmark);
        compoundController.appendCommand(benchmarkTemplate.clearSizes());
        compoundController.appendCommand(benchmarkTemplate.addSizes(frames));
        compoundController.appendCommand(benchmarkTemplate.setResolution(this.generalConfig.getResolution()));
        compoundController.appendCommand(benchmarkTemplate.setAcceptableLoss(this.generalConfig.getLoss()));
    }

    @Override
    public void addPages() {
        this.setWindowTitle("RFC 2544 Benchmark");
        this.addPage((IWizardPage)this.generalConfig);
    }
}

