/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.rfc2544;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.wizards.BackToBackPortConfigPage;
import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.pages.GenericIntroPage;
import com.excentis.products.byteblower.gui.wizards.rfc2544.GeneralConfiguration;
import com.excentis.products.byteblower.gui.wizards.rfc2544.TestSelectionPage;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.FrameBlastingBenchmarkController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.edit.tools.NamingTools;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingBenchmarkReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;

public class RFC2544Wizard
extends Wizard {
    private TestSelectionPage testSelection = new TestSelectionPage();
    private GeneralConfiguration generalConfig = new GeneralConfiguration();
    private BackToBackPortConfigPage sourcePage;
    private BackToBackPortConfigPage destinationPage;

    public RFC2544Wizard() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        BackToBackPortConfigPage.BackToBackPortFactory factory = new BackToBackPortConfigPage.BackToBackPortFactory();
        this.sourcePage = factory.makeSource(project, "RFC_2544_SOURCE_1");
        this.destinationPage = factory.makeDestination(project, "RFC_2544_DESTINATION_1");
    }

    private Command createDhcp(Collection<ByteBlowerGuiPort> backToBackPorts) {
        Dhcp dhcp = null;
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPort port : backToBackPorts) {
            if (port.getIpv4Configuration().getAddressConfiguration() != Ipv4AddressConfigType.DHC_PV4) continue;
            if (dhcp == null) {
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(ByteBlowerGuiResourceController.getProject());
                ByteBlowerProjectController.CommandWithDhcpListReference commandWithRef = projectController.addDhcp();
                compound.appendCommand(commandWithRef.getCommand());
                DhcpController dhcpController = (DhcpController)((List)commandWithRef.getCommandReference()).get(0);
                dhcp = (Dhcp)dhcpController.getObject();
            }
            ByteBlowerGuiPortController controller = new ByteBlowerGuiPortController(port);
            Ipv4ConfigurationController ipv4ConfigurationController = controller.getIpv4ConfigurationController();
            ipv4ConfigurationController.setDhcp(dhcp).getCommand().execute();
        }
        return compound.unwrap();
    }

    @Override
    public boolean performFinish() {
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        if (projectController == null) {
            return false;
        }
        UniqueEList backToBackPorts = new UniqueEList();
        backToBackPorts.add(this.sourcePage.getPort());
        backToBackPorts.add(this.destinationPage.getPort());
        compoundController.appendCommand(this.createDhcp((Collection<ByteBlowerGuiPort>)backToBackPorts));
        compoundController.appendCommand(projectController.createAddByteBlowerGuiPortCommand((Collection)backToBackPorts));
        if (this.testSelection.isThroughputEnabled()) {
            this.createThroughputTest(compoundController, projectController, this.generalConfig.getSizes());
        }
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "RFC-2544 Wizard", compoundController.unwrap());
        operation.run();
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.autoDock((ByteBlowerProjectReader)projectController);
        return true;
    }

    private void createThroughputTest(CompoundCommandController compoundController, ByteBlowerProjectController projectController, List<Integer> frames) {
        ByteBlowerProjectController.CommandWithFrameBlastingBenchmarkReference benchCommand = projectController.addFrameBlastingBenchmark();
        compoundController.appendCommand(benchCommand.getCommand());
        FrameBlastingBenchmarkController benchmarkTemplate = (FrameBlastingBenchmarkController)((List)benchCommand.getCommandReference()).get(0);
        compoundController.appendCommand(benchmarkTemplate.addSizes(frames));
        compoundController.appendCommand(benchmarkTemplate.setName(NamingTools.getUniqueName((ByteBlowerProject)projectController.getProject(), (EObject)benchmarkTemplate.getObject(), (String)"RFC_2544_TEMPLATE_1")));
        compoundController.appendCommand(benchmarkTemplate.setResolution(this.generalConfig.getResolution()));
        compoundController.appendCommand(benchmarkTemplate.setAcceptableLoss(this.generalConfig.getLoss()));
        HighResolutionCalendar iterationDuration = this.generalConfig.getIterationDuration();
        compoundController.appendCommand(benchmarkTemplate.setIterationDuration(iterationDuration));
        ByteBlowerProjectController.CommandWithFlowListReference flowCommand = projectController.addFlows(1);
        compoundController.appendCommand(flowCommand.getCommand());
        FlowController flowController = (FlowController)((List)flowCommand.getCommandReference()).get(0);
        compoundController.appendCommand(flowController.setName(NamingTools.getUniqueName((ByteBlowerProject)projectController.getProject(), (EObject)flowController.getObject(), (String)"RFC_2544_FLOW_1")));
        compoundController.appendCommand(flowController.setFlowTemplate((FlowTemplate)benchmarkTemplate.getObject()));
        compoundController.appendCommand(flowController.setSource((AddressableSource)this.sourcePage.getPort()));
        compoundController.appendCommand(flowController.setDestination((AddressableDestination)this.destinationPage.getPort()));
        ByteBlowerProjectController.CommandWithScenarioListReference scenarioCommand = projectController.addScenario();
        compoundController.appendCommand(scenarioCommand.getCommand());
        ScenarioController scenario = (ScenarioController)((List)scenarioCommand.getCommandReference()).get(0);
        compoundController.appendCommand(scenario.setName(NamingTools.getUniqueName((ByteBlowerProject)projectController.getProject(), (EObject)scenario.getObject(), (String)"RFC_2544_SCENARIO_1")));
        ScenarioFlowEventController.CommandWithFlowMeasurementListReference flowMeasurementCommand = scenario.addFlowMeasurement();
        compoundController.appendCommand(flowMeasurementCommand.getCommand());
        FlowMeasurementController action = (FlowMeasurementController)((List)flowMeasurementCommand.getCommandReference()).get(0);
        compoundController.appendCommand(action.setFlow((Flow)flowController.getObject()));
        HighResolutionDuration estimatedDuration = FrameBlastingBenchmarkReader.getEstimatedDuration((HighResolutionCalendar)iterationDuration, (int)frames.size());
        compoundController.appendCommand(action.setDuration((HighResolutionCalendar)estimatedDuration));
    }

    @Override
    public void addPages() {
        this.setWindowTitle("RFC 2544 Benchmark");
        String longDescription = "This wizard creates an RFC 2544 benchmark. This test measures the maximum throughput of a network device at different packet sizes.\n\n You will be asked the source, destination and other test parameters.";
        longDescription = WordUtils.wrap((String)longDescription, (int)80);
        GenericIntroPage introPage = new GenericIntroPage("RFC 2544 benchmark", "", longDescription, "wizards/backtobackwizard.gif", "images/backtobackwizard_left.gif");
        this.addPage((IWizardPage)introPage);
        this.addPage((IWizardPage)this.sourcePage);
        this.addPage((IWizardPage)this.destinationPage);
        this.addPage((IWizardPage)this.generalConfig);
    }
}

