/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.throughput.Messages;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputTopology;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizard;
import com.excentis.products.byteblower.gui.wizards.throughput.composites.SpeedIncrementComposite;
import com.excentis.products.byteblower.gui.wizards.throughput.composites.ThroughputFlowSpeedConfigComposite;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import java.math.BigInteger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class ThroughputFlowSpeedConfigPage
extends WizardPage {
    private ThroughputWizard wizard;
    private ThroughputTopology topology;
    private ThroughputFlowSpeedConfigComposite flowSpeedConfigComposite;
    private Frame throughputFrame;
    private FrameBlastingFlow minSpeedFlowTemplate;
    private FrameBlastingFlow incrSpeedFlowTemplate;
    private FrameBlastingFlow maxSpeedFlowTemplate;

    public ThroughputFlowSpeedConfigPage(Frame throughputFrame, FrameBlastingFlow minSpeedFlowTemplate, FrameBlastingFlow incrSpeedFlowTemplate, FrameBlastingFlow maxSpeedFlowTemplate, ThroughputWizard wizard) {
        super("ThroughputFlowSpeedConfigPage");
        this.wizard = wizard;
        this.throughputFrame = throughputFrame;
        this.minSpeedFlowTemplate = minSpeedFlowTemplate;
        this.incrSpeedFlowTemplate = incrSpeedFlowTemplate;
        this.maxSpeedFlowTemplate = maxSpeedFlowTemplate;
        this.setTitle(Messages.getString("FlowSpeedConfigPage.Title"));
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/throughputwizard.gif"));
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new ThroughputTopology((Composite)container, 2048);
        this.topology.showFlow();
        this.topology.applyChanges();
        this.flowSpeedConfigComposite = new ThroughputFlowSpeedConfigComposite((Composite)container, this.throughputFrame, this.minSpeedFlowTemplate, this.incrSpeedFlowTemplate, this.maxSpeedFlowTemplate, this.wizard);
        this.flowSpeedConfigComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ThroughputFlowSpeedConfigPage.this.onChange();
            }
        });
        this.flowSpeedConfigComposite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ThroughputFlowSpeedConfigPage.this.onChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
    }

    private void onChange() {
        if (this.flowSpeedConfigComposite.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(this.flowSpeedConfigComposite.getErrorMessage());
            this.setPageComplete(false);
        }
    }

    public int getFlowCount() {
        return this.flowSpeedConfigComposite.getFlowCount();
    }

    public BigInteger getMinimumFlowDuration() {
        return this.flowSpeedConfigComposite.getMinimumFlowDuration();
    }

    public SpeedIncrementComposite.ESpeedIncrementType getSpeedIncrementType() {
        return this.flowSpeedConfigComposite.getSpeedIncrementType();
    }
}

