/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.utils.GuiUtils;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.gui.wizards.BackToBackPortConfigPage;
import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.pages.GenericIntroPage;
import com.excentis.products.byteblower.gui.wizards.throughput.Messages;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputFlowSizeConfigPage;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputFlowSpeedConfigPage;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizardCommandWrapper;
import com.excentis.products.byteblower.gui.wizards.throughput.composites.SpeedIncrementComposite;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.SequenceModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameBlastingFrameController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.object.control.CommandWithStringReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;

public class ThroughputWizard
extends Wizard {
    private GenericIntroPage introPage = null;
    private ThroughputFlowSpeedConfigPage flowSpeedPage = null;
    private ThroughputFlowSizeConfigPage flowSizePage = null;
    private final BackToBackPortConfigPage sourcePortPage;
    private final BackToBackPortConfigPage destinationPortPage;
    private ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
    private Frame throughputFrame = this.factory.createFrame();
    private FrameBlastingFlow minSpeedFlowTemplate = this.factory.createFrameBlastingFlow();
    private FrameBlastingFlow incrSpeedFlowTemplate = this.factory.createFrameBlastingFlow();
    private FrameBlastingFlow maxSpeedFlowTemplate = this.factory.createFrameBlastingFlow();
    private FrameBlastingFlowController minController;
    private FrameBlastingFlowController incrController;
    private FrameBlastingFlowController maxController;
    private BigDecimal cur;
    private List<String> takenNames;

    public ThroughputWizard() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        BackToBackPortConfigPage.BackToBackPortFactory factory = new BackToBackPortConfigPage.BackToBackPortFactory();
        this.sourcePortPage = factory.makeSource(project, "Throughput Source 1");
        this.destinationPortPage = factory.makeDestination(project, "Throughput Destination 1");
        this.initThroughputFlowTemplates();
    }

    private void initThroughputFlowTemplates() {
        this.minController = ControllerFactory.create((FrameBlastingFlow)this.minSpeedFlowTemplate);
        this.incrController = ControllerFactory.create((FrameBlastingFlow)this.incrSpeedFlowTemplate);
        this.maxController = ControllerFactory.create((FrameBlastingFlow)this.maxSpeedFlowTemplate);
        FrameController.initializeFrame_Ipv4_UDP((Frame)this.throughputFrame);
        CompoundCommandController compound = CompoundCommandController.createInstance();
        this.addFrame(this.minController, this.throughputFrame);
        compound.appendCommand(this.minController.setFrameRate(new BigDecimal(100)));
        this.addFrame(this.incrController, this.throughputFrame);
        compound.appendCommand(this.incrController.setFrameRate(new BigDecimal(100)));
        this.addFrame(this.maxController, this.throughputFrame);
        compound.appendCommand(this.maxController.setFrameRate(new BigDecimal(1000)));
        compound.execute();
    }

    private void addFrame(FrameBlastingFlowController controller, Frame frame) {
        FrameBlastingFlowController.CommandWithFrameBlastingFrameListReference ref = controller.addFrameBlastingFrame();
        ref.getCommand().execute();
        FrameBlastingFrameController frameBlastingFrameController = (FrameBlastingFrameController)((List)ref.getCommandReference()).get(0);
        frameBlastingFrameController.setFrame(frame).execute();
    }

    @Override
    public boolean performCancel() {
        return super.performCancel();
    }

    @Override
    public boolean performFinish() {
        BigDecimal last;
        BigDecimal add;
        BigDecimal first;
        CompoundCommandController compound = CompoundCommandController.createStrictInstance((boolean)true);
        this.setNeedsProgressMonitor(false);
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        ByteBlowerProjectReader reader = ReaderFactory.create((ByteBlowerProject)project);
        this.takenNames = reader.getTakenNames();
        UniqueEList throughputPorts = new UniqueEList();
        throughputPorts.add(this.sourcePortPage.getPort());
        throughputPorts.add(this.destinationPortPage.getPort());
        compound.appendCommand(this.createDhcp((Collection<ByteBlowerGuiPort>)throughputPorts));
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        compound.appendCommand(projectController.createAddByteBlowerGuiPortCommand((Collection)throughputPorts));
        final Long pauseTimeNs = this.flowSizePage.getPauseTime().getTimeInNanoseconds();
        final HighResolutionCalendar duration = this.flowSizePage.getDuration();
        short s = this.getFlowCount();
        SpeedIncrementComposite.ESpeedIncrementType speedIncrementType = this.flowSpeedPage.getSpeedIncrementType();
        if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_FRAME_RATE) {
            first = this.minController.getFrameRate();
            add = this.incrController.getFrameRate();
            last = this.maxController.getFrameRate();
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.DECREMENT_FRAME_INTERVAL) {
            first = new BigDecimal(this.minSpeedFlowTemplate.getFrameInterval().toString());
            add = new BigDecimal(this.incrSpeedFlowTemplate.getFrameInterval().toString());
            last = new BigDecimal(this.maxSpeedFlowTemplate.getFrameInterval().toString());
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_INTENDED_LOAD) {
            first = this.minController.getThroughput(this.getThroughputType());
            add = this.incrController.getThroughput(this.getThroughputType());
            last = this.maxController.getThroughput(this.getThroughputType());
        } else {
            return false;
        }
        this.cur = first;
        final ArrayList<FlowMeasurementController> flowMeasurementControllers = new ArrayList<FlowMeasurementController>();
        Scenario throughputScenario = this.factory.createScenario();
        ScenarioController scenarioController = ControllerFactory.create((Scenario)throughputScenario);
        short i = 0;
        while (i < s) {
            Frame frame = (Frame)EByteBlowercoreUtil.copy((EObject)this.throughputFrame);
            CommandWithStringReference commandRef = this.setName("Throughput Frame 1", (EByteBlowerObject)frame, this.takenNames);
            compound.appendCommand(commandRef.getCommand());
            this.takenNames.add((String)commandRef.getCommandReference());
            FrameController frameController = new FrameController(frame);
            Command command = frameController.makeUdpPayloadUnique(i);
            command.execute();
            compound.appendCommand(projectController.createAddFrameCommand(frame));
            FrameBlastingFlow throughputFrameBlasting = this.factory.createFrameBlastingFlow();
            final FrameBlastingFlowController controller = ControllerFactory.create((FrameBlastingFlow)throughputFrameBlasting);
            commandRef = this.setName("Throughput Template 1", (EByteBlowerObject)throughputFrameBlasting, this.takenNames);
            compound.appendCommand(commandRef.getCommand());
            this.takenNames.add((String)commandRef.getCommandReference());
            throughputFrameBlasting.setSequenceModifier((SequenceModifier)this.factory.createAlternateModifier());
            FrameBlastingFlowController.CommandWithFrameBlastingFrameListReference ref = controller.addFrameBlastingFrame();
            compound.appendCommand(ref.getCommand());
            final FrameBlastingFrameController frameBlastingFrameController = (FrameBlastingFrameController)((List)ref.getCommandReference()).get(0);
            final Frame finalFrame = frame;
            compound.appendCommand((Command)new CommandWrapper(){

                protected Command createCommand() {
                    return frameBlastingFrameController.setFrame(finalFrame);
                }
            });
            if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_FRAME_RATE) {
                if (this.cur.compareTo(last) == 1) {
                    this.cur = last;
                }
                compound.appendCommand((Command)new CommandWrapper(){
                    private BigDecimal rate;
                    {
                        this.rate = ThroughputWizard.this.cur;
                    }

                    protected Command createCommand() {
                        return controller.setFrameRate(this.rate);
                    }
                });
                this.cur = this.cur.add(add);
            } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.DECREMENT_FRAME_INTERVAL) {
                if (this.cur.compareTo(last) == -1) {
                    this.cur = last;
                }
                compound.appendCommand((Command)new CommandWrapper(){
                    private HighResolutionCalendar frameInterval;
                    {
                        this.frameInterval = new HighResolutionCalendar(Long.valueOf(ThroughputWizard.this.cur.toBigInteger().longValue()));
                    }

                    protected Command createCommand() {
                        return controller.setFrameInterval(this.frameInterval);
                    }
                });
                this.cur = this.cur.subtract(add);
            } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_INTENDED_LOAD) {
                if (this.cur.compareTo(last) == 1) {
                    this.cur = last;
                }
                compound.appendCommand((Command)new CommandWrapper(){
                    private BigDecimal throughput;
                    {
                        this.throughput = ThroughputWizard.this.cur;
                    }

                    protected Command createCommand() {
                        return controller.setThroughput(this.throughput, DataRateUnit.BPS, ThroughputWizard.this.getThroughputType(), false);
                    }
                });
                this.cur = this.cur.add(add);
            } else {
                return false;
            }
            compound.appendCommand(projectController.createAddFlowTemplateCommand((FlowTemplate)throughputFrameBlasting));
            Flow throughputFlow = this.factory.createFlow();
            FlowController flowController = ControllerFactory.create((Flow)throughputFlow);
            commandRef = this.setName("Throughput Flow 1", (EByteBlowerObject)throughputFlow, this.takenNames);
            compound.appendCommand(commandRef.getCommand());
            this.takenNames.add((String)commandRef.getCommandReference());
            compound.appendCommand(flowController.setSource((AddressableSource)this.sourcePortPage.getPort()));
            compound.appendCommand(flowController.setDestination((AddressableDestination)this.destinationPortPage.getPort()));
            compound.appendCommand(flowController.setFlowTemplate((FlowTemplate)throughputFrameBlasting));
            compound.appendCommand(projectController.createAddFlowCommand(throughputFlow));
            ScenarioFlowEventController.CommandWithFlowMeasurementListReference measurementRef = scenarioController.addFlowMeasurement();
            compound.appendCommand(measurementRef.getCommand());
            final FlowMeasurementController measurementController = (FlowMeasurementController)((List)measurementRef.getCommandReference()).get(0);
            flowMeasurementControllers.add(i, measurementController);
            Flow finalFlow = throughputFlow;
            compound.appendCommand((Command)new CommandWrapper(finalFlow){
                private Flow flow;
                {
                    this.flow = flow;
                }

                protected Command createCommand() {
                    return measurementController.setFlow(this.flow);
                }
            });
            if (this.flowSizePage.getIsFixedNofFrames()) {
                final String nofFrames = this.flowSizePage.getNofFrames();
                compound.appendCommand((Command)new CommandWrapper(){

                    protected Command createCommand() {
                        return measurementController.setNumberOfFrames(Long.valueOf(new BigInteger(nofFrames).longValue()));
                    }
                });
            } else {
                compound.appendCommand((Command)new CommandWrapper(){

                    protected Command createCommand() {
                        return measurementController.setDuration(duration);
                    }
                });
            }
            compound.appendCommand((Command)new ThroughputWizardCommandWrapper(i){

                protected Command createCommand() {
                    HighResolutionCalendar startTime = new HighResolutionCalendar();
                    int currentIndex = this.getIndex();
                    if (currentIndex > 0) {
                        FlowMeasurementController previousMeasurementController = (FlowMeasurementController)flowMeasurementControllers.get(currentIndex - 1);
                        FlowMeasurement previousMeasurement = (FlowMeasurement)previousMeasurementController.getObject();
                        FlowMeasurementReaderImpl reader = new FlowMeasurementReaderImpl(previousMeasurement);
                        Long previousStopTime = reader.getStopTime().getTimeInNanoseconds();
                        startTime = new HighResolutionCalendar(Long.valueOf(previousStopTime + pauseTimeNs));
                    }
                    return measurementController.delayStartTime(startTime);
                }
            });
            i = (short)(i + 1);
        }
        CommandWithStringReference commandRef = this.setName("Throughput Scenario 1", (EByteBlowerObject)throughputScenario, this.takenNames);
        compound.appendCommand(commandRef.getCommand());
        this.takenNames.add((String)commandRef.getCommandReference());
        compound.appendCommand(projectController.createAddScenarioCommand(throughputScenario));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Throughput Wizard", compound.unwrap());
        operation.run();
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.autoDock((ByteBlowerProjectReader)projectController);
        ScenarioView.showAndSelect(throughputScenario);
        return true;
    }

    private CommandWithStringReference setName(String newName, EByteBlowerObject eByteBlowerObject, List<String> takenNames) {
        EByteBlowerObjectController controller = ControllerFactory.create((EByteBlowerObject)eByteBlowerObject);
        return controller.setUniqueName(newName, takenNames);
    }

    private ThroughputType getThroughputType() {
        return ByteBlowerGuiResourceController.getProject().getThroughputType();
    }

    private Command createDhcp(Collection<ByteBlowerGuiPort> ports) {
        Dhcp dhcp = null;
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPort port : ports) {
            if (port.getIpv4Configuration().getAddressConfiguration() != Ipv4AddressConfigType.DHC_PV4) continue;
            if (dhcp == null) {
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(ByteBlowerGuiResourceController.getProject());
                ByteBlowerProjectController.CommandWithDhcpListReference commandWithRef = projectController.addDhcp();
                compound.appendCommand(commandWithRef.getCommand());
                DhcpController dhcpController = (DhcpController)((List)commandWithRef.getCommandReference()).get(0);
                dhcp = (Dhcp)dhcpController.getObject();
            }
            ByteBlowerGuiPortController controller = new ByteBlowerGuiPortController(port);
            Ipv4ConfigurationController ipv4ConfigurationController = controller.getIpv4ConfigurationController();
            ipv4ConfigurationController.setDhcp(dhcp).getCommand().execute();
        }
        return compound.unwrap();
    }

    @Override
    public void addPages() {
        this.setWindowTitle("Throughput Wizard");
        this.introPage = new GenericIntroPage(Messages.getString("IntroPage.Title"), "", Messages.getString("IntroPage.IntroductionText"), "wizards/throughputwizard.gif", "images/throughputwizard_left.gif");
        this.addPage((IWizardPage)this.introPage);
        this.flowSpeedPage = new ThroughputFlowSpeedConfigPage(this.throughputFrame, this.minSpeedFlowTemplate, this.incrSpeedFlowTemplate, this.maxSpeedFlowTemplate, this);
        this.flowSizePage = new ThroughputFlowSizeConfigPage(this);
        this.addPage((IWizardPage)this.flowSpeedPage);
        this.addPage((IWizardPage)this.flowSizePage);
        this.addPage((IWizardPage)this.sourcePortPage);
        this.addPage((IWizardPage)this.destinationPortPage);
    }

    public void flowCountChanged() {
        this.flowSizePage.flowCountChanged();
    }

    public List<BigDecimal> getFramesPerSecondList() {
        int flowCount = this.flowSpeedPage.getFlowCount();
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(flowCount);
        SpeedIncrementComposite.ESpeedIncrementType speedIncrementType = this.flowSpeedPage.getSpeedIncrementType();
        if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_FRAME_RATE) {
            BigDecimal cur = this.minController.getFrameRate();
            BigDecimal incr = this.incrController.getFrameRate();
            BigDecimal max = this.maxController.getFrameRate();
            while (cur.compareTo(max) < 0) {
                list.add(cur);
                cur = cur.add(incr);
            }
            list.add(max);
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.DECREMENT_FRAME_INTERVAL) {
            BigInteger decr = BigInteger.valueOf(this.incrSpeedFlowTemplate.getFrameInterval().getTimeInNanoseconds());
            BigInteger min = BigInteger.valueOf(this.maxSpeedFlowTemplate.getFrameInterval().getTimeInNanoseconds());
            BigInteger cur = BigInteger.valueOf(this.minSpeedFlowTemplate.getFrameInterval().getTimeInNanoseconds());
            while (cur.compareTo(min) > 0) {
                list.add(GuiUtils.frameIntervalToFramesPerSecond((BigInteger)cur));
                cur = cur.subtract(decr);
            }
            list.add(GuiUtils.frameIntervalToFramesPerSecond((BigInteger)min));
        } else if (speedIncrementType == SpeedIncrementComposite.ESpeedIncrementType.INCREMENT_INTENDED_LOAD) {
            BigDecimal cur = this.minController.getFrameRate();
            BigDecimal incr = this.incrController.getFrameRate();
            BigDecimal max = this.maxController.getFrameRate();
            while (cur.compareTo(max) < 0) {
                list.add(cur);
                cur = cur.add(incr);
            }
            list.add(max);
        }
        return list;
    }

    public int getFlowCount() {
        return this.flowSpeedPage.getFlowCount();
    }

    public BigInteger getMinimumFlowDuration() {
        return this.flowSpeedPage.getMinimumFlowDuration();
    }
}

