/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.throughput.composites;

import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizard;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ThroughputFlowDurationConfigComposite
extends Composite
implements ModifyListener {
    private ThroughputWizard wizard;
    private Button btnFixedFlowDuration;
    private Button btnFixedNofFrames;
    private Text txtFlowDuration;
    private Text txtFlowNofFrames;
    private Text txtPauseDuration;
    private Text txtTotalDuration;
    private String errorMessage;
    private static final int minNofFramesPerFlow = 2;
    private static BigDecimal secondsToNanoSeconds = new BigDecimal(1000000000);

    public ThroughputFlowDurationConfigComposite(Composite parent, ThroughputWizard wizard) {
        super(parent, 2048);
        this.wizard = wizard;
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setText("Size of each Flow");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        this.btnFixedFlowDuration = new Button((Composite)group, 16);
        this.btnFixedFlowDuration.setText("Fixed Duration:");
        this.btnFixedFlowDuration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = ThroughputFlowDurationConfigComposite.this.btnFixedFlowDuration.getSelection();
                ThroughputFlowDurationConfigComposite.this.txtFlowDuration.setEnabled(sel);
                ThroughputFlowDurationConfigComposite.this.txtFlowNofFrames.setEnabled(!sel);
                ThroughputFlowDurationConfigComposite.this.updateTotalDuration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.txtFlowDuration = TimeTextFactory.instance().create((Composite)group, 2048);
        this.txtFlowDuration.setLayoutData((Object)new GridData(768));
        this.txtFlowDuration.addModifyListener((ModifyListener)this);
        this.btnFixedNofFrames = new Button((Composite)group, 16);
        this.btnFixedNofFrames.setText("Fixed number of Frames:");
        this.btnFixedNofFrames.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = ThroughputFlowDurationConfigComposite.this.btnFixedNofFrames.getSelection();
                ThroughputFlowDurationConfigComposite.this.txtFlowNofFrames.setEnabled(sel);
                ThroughputFlowDurationConfigComposite.this.txtFlowDuration.setEnabled(!sel);
                ThroughputFlowDurationConfigComposite.this.updateTotalDuration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.txtFlowNofFrames = IntegerTextFactory.instance().createWithTextLimit((Composite)group, 20);
        this.txtFlowNofFrames.setLayoutData((Object)new GridData(768));
        this.txtFlowNofFrames.addModifyListener((ModifyListener)this);
        group = new Group((Composite)this, 0);
        group.setText("Pause between Flows");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblNofFrames = new Label((Composite)group, 0);
        lblNofFrames.setText("Duration:");
        this.txtPauseDuration = TimeTextFactory.instance().create((Composite)group, 2048);
        this.txtPauseDuration.setLayoutData((Object)new GridData(768));
        this.txtPauseDuration.addModifyListener((ModifyListener)this);
        group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblDuration = new Label((Composite)group, 0);
        lblDuration.setText("Scenario Duration:");
        this.txtTotalDuration = TimeTextFactory.instance().create((Composite)group, 2048);
        this.txtTotalDuration.setLayoutData((Object)new GridData(768));
        this.txtTotalDuration.setEditable(false);
        this.initializeValues();
    }

    private void initializeValues() {
        this.btnFixedFlowDuration.setSelection(true);
        this.txtFlowNofFrames.setEnabled(false);
        String flowDurationString = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)new HighResolutionCalendar(Long.valueOf(10000000000L)), (boolean)false, (boolean)true);
        this.txtFlowDuration.setText(flowDurationString);
        this.txtFlowNofFrames.setText("1000");
        String pauseDurationString = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)new HighResolutionCalendar(Long.valueOf(1000000000L)), (boolean)false, (boolean)true);
        this.txtPauseDuration.setText(pauseDurationString);
        this.updateTotalDuration();
    }

    public void addModifyListener(ModifyListener listener) {
        this.txtFlowDuration.addModifyListener(listener);
        this.txtFlowNofFrames.addModifyListener(listener);
        this.txtPauseDuration.addModifyListener(listener);
    }

    private void updateTotalDuration() {
        String totalDuration = "";
        BigInteger totalDurationInNs = null;
        int flowCount = this.wizard.getFlowCount();
        BigInteger flowCountBigInt = new BigInteger(Integer.toString(flowCount));
        String pause = this.txtPauseDuration.getText();
        BigInteger pauseDurationInNs = null;
        HighResolutionCalendar highResolutionCalendar = new HighResolutionCalendar();
        pauseDurationInNs = HighResolutionCalendarParser.setRelativeTime((String)pause, (HighResolutionCalendar)highResolutionCalendar) ? BigInteger.valueOf(highResolutionCalendar.getTimeInNanoseconds()) : BigInteger.ZERO;
        BigInteger nofPauses = flowCountBigInt.subtract(BigInteger.ONE);
        BigInteger totalPauseTime = nofPauses.multiply(pauseDurationInNs);
        BigDecimal totalFlowDuration = new BigDecimal(0);
        if (this.btnFixedFlowDuration.getSelection()) {
            String flowDuration = this.txtFlowDuration.getText();
            BigInteger flowDurationInNs = null;
            flowDurationInNs = HighResolutionCalendarParser.setRelativeTime((String)flowDuration, (HighResolutionCalendar)highResolutionCalendar) ? BigInteger.valueOf(highResolutionCalendar.getTimeInNanoseconds()) : BigInteger.ZERO;
            totalDurationInNs = totalPauseTime.add(flowDurationInNs.multiply(flowCountBigInt));
        } else {
            BigDecimal nofFramesPerFlow = new BigDecimal(this.txtFlowNofFrames.getText());
            List<BigDecimal> fpsList = this.wizard.getFramesPerSecondList();
            nofFramesPerFlow = nofFramesPerFlow.multiply(secondsToNanoSeconds);
            int listSize = fpsList.size();
            int i = 0;
            while (i < listSize) {
                BigDecimal fps = fpsList.get(i);
                BigDecimal flowDuration = nofFramesPerFlow.divide(fps, 11, 6);
                totalFlowDuration = totalFlowDuration.add(flowDuration);
                ++i;
            }
            totalDurationInNs = totalPauseTime.add(totalFlowDuration.toBigInteger());
        }
        totalDuration = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)new HighResolutionCalendar(Long.valueOf(totalDurationInNs.longValue())), (boolean)false, (boolean)true);
        this.txtTotalDuration.setText(totalDuration);
    }

    public boolean isComplete() {
        this.errorMessage = "";
        this.txtFlowDuration.setForeground(null);
        this.txtFlowNofFrames.setForeground(null);
        if (this.btnFixedFlowDuration.getSelection()) {
            BigInteger minDuration = this.wizard.getMinimumFlowDuration();
            HighResolutionCalendar highResolutionCalendar = new HighResolutionCalendar();
            BigInteger flowDuration = HighResolutionCalendarParser.setRelativeTime((String)this.txtFlowDuration.getText(), (HighResolutionCalendar)highResolutionCalendar) ? BigInteger.valueOf(highResolutionCalendar.getTimeInNanoseconds()) : BigInteger.ZERO;
            if (flowDuration.compareTo(minDuration) < 0) {
                this.txtFlowDuration.setForeground(ColorConstants.red);
                this.errorMessage = "The Flow duration is too short. The minimum duration is " + HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)new HighResolutionCalendar(Long.valueOf(minDuration.longValue())), (boolean)false, (boolean)true) + ".";
                return false;
            }
        } else {
            int nofFrames = Integer.parseInt(this.txtFlowNofFrames.getText());
            if (nofFrames < 2) {
                this.txtFlowNofFrames.setForeground(ColorConstants.red);
                this.errorMessage = "The number of Frames is too small. The minimum number of Frames is 2.";
                return false;
            }
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (control.isFocusControl()) {
            if (control == this.txtFlowDuration) {
                this.updateTotalDuration();
            } else if (control == this.txtFlowNofFrames) {
                this.updateTotalDuration();
            } else if (control == this.txtPauseDuration) {
                this.updateTotalDuration();
            }
        }
    }

    public void flowCountChanged() {
        this.updateTotalDuration();
    }

    public boolean getIsFixedNofFrames() {
        return this.btnFixedNofFrames.getSelection();
    }

    public HighResolutionCalendar getDuration() {
        String duration = this.txtFlowDuration.getText();
        HighResolutionCalendar highResolutionCalendar = new HighResolutionCalendar();
        HighResolutionCalendarParser.setRelativeTime((String)duration, (HighResolutionCalendar)highResolutionCalendar);
        return highResolutionCalendar;
    }

    public String getNofFrames() {
        String nofFrames = this.txtFlowNofFrames.getText();
        return nofFrames;
    }

    public HighResolutionCalendar getPauseTime() {
        HighResolutionCalendar highResolutionCalendar;
        String pause = this.txtPauseDuration.getText();
        if (!HighResolutionCalendarParser.setRelativeTime((String)pause, (HighResolutionCalendar)(highResolutionCalendar = new HighResolutionCalendar()))) {
            System.err.println("ThroughputFlowDurationConfigComposite::getPauseTime : error while setting relative pause time");
        }
        return highResolutionCalendar;
    }
}

