/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.topology.layout;

import com.excentis.products.byteblower.gui.wizards.topology.TopologyConnection;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyDevice;
import com.excentis.products.byteblower.gui.wizards.topology.TopologyFlow;
import com.excentis.products.byteblower.gui.wizards.topology.layout.TreeLayout;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Node;

public class CroppedTreeLayout
extends TreeLayout {
    private int xOffset;

    public CroppedTreeLayout(Figure parent) {
        super(parent);
        this.graph = new DirectedGraph();
    }

    @Override
    public void Update(boolean animation) {
        new DirectedGraphLayout().visit(this.graph);
        int mininumX = 1000;
        int maximumX = 0;
        for (Object element : this.objectMapper.keySet()) {
            try {
                Node n = (Node)this.objectMapper.get(element);
                if (n.x + n.width > maximumX) {
                    maximumX = n.x + n.width;
                }
                if (n.x >= mininumX) continue;
                mininumX = n.x;
            }
            catch (Exception exception) {}
        }
        int width = maximumX - mininumX;
        this.xOffset = (this.parentFigure.getBounds().width - width) / 2;
        this.start = System.currentTimeMillis();
        this.finish = this.start + 230L;
        this.current = this.start + 20L;
        if (animation) {
            while (this.step()) {
                this.UpdateLayout();
            }
        }
        this.start = -1L;
        Iterator temp = this.objectMapper.keySet().iterator();
        ArrayList edgeList = new ArrayList();
        while (temp.hasNext()) {
            Object element = temp.next();
            try {
                Node n = (Node)this.objectMapper.get(element);
                ((TopologyDevice)((Object)element)).setBounds(new Rectangle(n.x + this.xOffset, n.y, n.width, n.height));
                if (n.x + this.xOffset < 0 || n.x + this.xOffset + n.width > this.parentFigure.getBounds().width) {
                    ((TopologyDevice)((Object)element)).setVisible(false);
                    continue;
                }
                ((TopologyDevice)((Object)element)).setVisible(true);
            }
            catch (Exception exception) {
                try {
                    edgeList.add(element);
                }
                catch (Exception exception2) {}
            }
        }
        for (TopologyConnection connection : edgeList) {
            connection.Update();
        }
        for (TopologyFlow flow : this.flowList) {
            flow.Update();
        }
        this.parentFigure.getUpdateManager().performUpdate();
    }

    @Override
    protected void UpdateLayout() {
        Iterator nodeVisitor = this.objectMapper.keySet().iterator();
        ArrayList edgeList = new ArrayList();
        while (nodeVisitor.hasNext()) {
            Object element = nodeVisitor.next();
            try {
                Node n = (Node)this.objectMapper.get(element);
                TopologyDevice device = (TopologyDevice)((Object)element);
                int newX = device.getBounds().x;
                int newY = device.getBounds().y;
                newX = (int)((long)newX + (long)(n.x + this.xOffset - newX) / (this.finish - this.current));
                newY = (int)((long)newY + (long)(n.y - newY) / (this.finish - this.current));
                device.setBounds(new Rectangle(newX, newY, n.width, n.height));
            }
            catch (Exception exception) {
                try {
                    edgeList.add(element);
                }
                catch (Exception exception2) {}
            }
        }
        for (TopologyConnection connection : edgeList) {
            connection.Update();
        }
        for (TopologyFlow flow : this.flowList) {
            flow.Update();
        }
        this.parentFigure.getUpdateManager().performUpdate();
    }
}

