/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class DhcpPropertiesComposite
extends PropertiesComposite {
    protected IWorkbench workbench;
    private Text txtDhcpTimeout;
    private Text txtDhcpRetries;

    public DhcpPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    protected void createContents() {
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblTimeout = new Label((Composite)this, 0);
        lblTimeout.setText("Default Initial Timeout:");
        final HighResolutionCalendar minNanoseconds = new HighResolutionCalendar(new Long("1000000"));
        final HighResolutionCalendar maxNanoseconds = new HighResolutionCalendar(new Long("64000000000"));
        this.txtDhcpTimeout = TimeTextFactory.instance().create((Composite)this, 2048, maxNanoseconds);
        this.txtDhcpTimeout.setLayoutData((Object)new GridData(768));
        this.txtDhcpTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HighResolutionCalendar currentTime;
                Text t = (Text)arg0.widget;
                String timeText = t.getText();
                boolean valid = HighResolutionCalendarParser.setRelativeTime((String)timeText, (HighResolutionCalendar)(currentTime = new HighResolutionCalendar()));
                if (!valid) {
                    DhcpPropertiesComposite.this.setInvalid("Enter a valid time value");
                } else if (currentTime.after((Object)maxNanoseconds)) {
                    DhcpPropertiesComposite.this.setInvalid("The timeout must be smaller than 64s");
                } else if (currentTime.before((Object)minNanoseconds)) {
                    DhcpPropertiesComposite.this.setInvalid("The timeout must be bigger than 1ms");
                } else {
                    DhcpPropertiesComposite.this.setInvalid(null);
                }
            }
        });
        Label lblRetries = new Label((Composite)this, 0);
        lblRetries.setText("Default Number of Retries:");
        this.txtDhcpRetries = IntegerTextFactory.instance().create((Composite)this, "999999");
        this.txtDhcpRetries.setLayoutData((Object)new GridData(768));
        this.showValues();
    }

    private void showValues() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String dhcpTimeout = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)(currentProject == null ? new HighResolutionCalendar(ByteBlowerPreferences.getDhcpTimeout()) : currentProject.getDhcpTimeout()), (boolean)false, (boolean)true);
        this.txtDhcpTimeout.setText(dhcpTimeout);
        String retries = currentProject == null ? ByteBlowerPreferences.getDhcpRetries() : currentProject.getDhcpRetries();
        this.txtDhcpRetries.setText(retries);
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String dhcpRetries = this.txtDhcpRetries.getText();
        HighResolutionCalendar timeout = new HighResolutionCalendar();
        boolean success = HighResolutionCalendarParser.setRelativeTime((String)this.txtDhcpTimeout.getText(), (HighResolutionCalendar)timeout);
        if (!success) {
            return;
        }
        if (currentProject.getDhcpTimeout().equals((Object)timeout) && currentProject.getDhcpRetries().equals(dhcpRetries)) {
            return;
        }
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setDhcpTimeout(timeout));
        compCommCtlr.appendCommand(projectCtlr.setDhcpRetries(dhcpRetries));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "DHCP project preferences", compCommCtlr.unwrap());
        operation.run();
    }

    @Override
    public void setAsDefault() {
        HighResolutionCalendar timeout;
        String dhcpTimeout = this.txtDhcpTimeout.getText();
        if (HighResolutionCalendarParser.setRelativeTime((String)dhcpTimeout, (HighResolutionCalendar)(timeout = new HighResolutionCalendar()))) {
            String timeoutInNanos = timeout.toString();
            ByteBlowerPreferences.setDhcpTimeout((String)timeoutInNanos);
        }
        String retries = this.txtDhcpRetries.getText();
        ByteBlowerPreferences.setDhcpRetries((String)retries);
    }
}

