/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.widgets.composites.RateComposite;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.FrameSizeModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Calendar;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class FrameBlastingSettingsDialog
extends TitleAreaDialog {
    private static final int MAX_FRAME_SIZE = 8192;
    private Button okButton;
    private FrameBlastingFlowController origController;
    private FrameBlastingFlowController tempController;
    private FrameBlastingFlow frameBlastingFlow;
    private Image dlgTitleImage = null;
    private RateComposite rateComposite;
    private Group timingGroup;
    private Label lblTimingSize;
    private Combo comboTimingType;
    private Label lblInterBurstGap;
    private Text txtInterBurstGap;
    private Label lblNofFramesPerBurst;
    private Text txtNofFramesPerBurst;
    private Button checkUseTimingModifier;
    private Button checkUseFrameModifier;
    private Label lblMinSize;
    private Text txtMinSize;
    private Label lblMaxSize;
    private Text txtMaxSize;
    private Label lblStepSize;
    private Text txtStepSize;
    private Label lblFrameIteration;
    private Text txtFrameIteration;
    private Label lblFrameSize;
    private Combo comboFrameSize;
    private boolean noValidation = false;

    public FrameBlastingSettingsDialog(Shell parentShell, FrameBlastingFlow frameBlastingFlow) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.frameBlastingFlow = frameBlastingFlow;
        this.origController = ControllerFactory.create((FrameBlastingFlow)frameBlastingFlow);
        FrameBlastingFlow tempFrameBlastingFlow = this.origController.copy();
        this.tempController = ControllerFactory.create((FrameBlastingFlow)tempFrameBlastingFlow);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("FrameBlastingSettingsDialog.settings"));
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setDialogComplete(this.validatePage());
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(String.valueOf(Messages.getString("FrameBlastingSettingsDialog.info")) + " " + this.tempController.getName());
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/FrameBlastingSettings.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite settingsComposite = new Composite(parentComposite, 0);
        settingsComposite.setLayoutData((Object)new GridData(1808));
        this.fillSettingsComposite(settingsComposite);
        this.initializeControls();
        return parentComposite;
    }

    private void fillSettingsComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        Composite compositeGeneral = new Composite((Composite)folder, 0);
        TabItem generalTab = new TabItem(folder, 0);
        generalTab.setText(Messages.getString("FrameBlastingSettingsDialog.generalTab"));
        generalTab.setControl((Control)compositeGeneral);
        Composite compositeTimingModifier = new Composite((Composite)folder, 0);
        TabItem timingModifierTab = new TabItem(folder, 0);
        timingModifierTab.setText(Messages.getString("FrameBlastingSettingsDialog.timingModifierTab"));
        timingModifierTab.setControl((Control)compositeTimingModifier);
        Composite compositeFrameModifier = new Composite((Composite)folder, 0);
        TabItem frameModifierTab = new TabItem(folder, 0);
        frameModifierTab.setText(Messages.getString("FrameBlastingSettingsDialog.frameModifierTab"));
        frameModifierTab.setControl((Control)compositeFrameModifier);
        this.fillTimingModifierTab(compositeTimingModifier);
        this.fillGeneralTab(compositeGeneral);
        this.fillFrameModifierTab(compositeFrameModifier);
    }

    private void fillGeneralTab(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.rateComposite = new RateComposite(parent, 0, this.tempController);
        this.rateComposite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void fillTimingModifierTab(Composite parent) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        parent.setLayout((Layout)formLayout);
        this.checkUseTimingModifier = new Button(parent, 32);
        this.checkUseTimingModifier.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.useTimingModifier"));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0);
        this.checkUseTimingModifier.setLayoutData((Object)formData);
        this.timingGroup = new Group(parent, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.checkUseTimingModifier, 10);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        this.timingGroup.setLayoutData((Object)formData);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.spacing = 5;
        this.timingGroup.setLayout((Layout)layout);
        this.lblTimingSize = new Label((Composite)this.timingGroup, 0);
        this.comboTimingType = new Combo((Composite)this.timingGroup, 8);
        this.lblTimingSize.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.TimingModifier.labelType"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.comboTimingType, 0, 0x1000000);
        formData.left = new FormAttachment(0);
        this.lblTimingSize.setLayoutData((Object)formData);
        this.comboTimingType.add(Messages.getString("FrameBlastingSettingsDialog.frameblasting.TimingModifier.MultipleBurst"));
        this.comboTimingType.select(0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment((Control)this.lblTimingSize);
        this.comboTimingType.setLayoutData((Object)formData);
        Composite composite = new Composite((Composite)this.timingGroup, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.comboTimingType);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblInterBurstGap = new Label(composite, 0);
        this.lblInterBurstGap.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.TimingModifier.labelInterBurstGap"));
        this.txtInterBurstGap = TimeTextFactory.instance().create(composite, 2048);
        this.txtInterBurstGap.setLayoutData((Object)new GridData(768));
        this.txtInterBurstGap.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.updateTempTimingModifier();
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.lblNofFramesPerBurst = new Label(composite, 0);
        this.lblNofFramesPerBurst.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.TimingModifier.labelNofFramesPerBurst"));
        this.txtNofFramesPerBurst = IntegerTextFactory.instance().createWithTextLimit(composite, 8);
        this.txtNofFramesPerBurst.setLayoutData((Object)new GridData(768));
        this.txtNofFramesPerBurst.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.updateTempTimingModifier();
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.checkUseTimingModifier.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FrameBlastingSettingsDialog.this.updateTempTimingModifier();
                FrameBlastingSettingsDialog.this.updateTimingModifierWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkUseTimingModifier.setSelection(false);
        this.updateTimingModifierWidgets();
    }

    private void updateTimingModifierWidgets() {
        boolean enable = this.checkUseTimingModifier.getSelection();
        this.lblTimingSize.setEnabled(enable);
        this.comboTimingType.setEnabled(enable);
        this.lblInterBurstGap.setEnabled(enable);
        this.txtInterBurstGap.setEnabled(enable);
        this.lblNofFramesPerBurst.setEnabled(enable);
        this.txtNofFramesPerBurst.setEnabled(enable);
    }

    private void fillFrameModifierTab(Composite parent) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        parent.setLayout((Layout)formLayout);
        this.checkUseFrameModifier = new Button(parent, 32);
        this.checkUseFrameModifier.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.useFrameModifier"));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0);
        this.checkUseFrameModifier.setLayoutData((Object)formData);
        Group group = new Group(parent, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.checkUseFrameModifier, 10);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        group.setLayoutData((Object)formData);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.spacing = 5;
        group.setLayout((Layout)layout);
        this.lblFrameSize = new Label((Composite)group, 0);
        this.comboFrameSize = new Combo((Composite)group, 8);
        this.lblFrameSize.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.labelSize"));
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.comboFrameSize, 0, 0x1000000);
        formData.left = new FormAttachment(0);
        this.lblFrameSize.setLayoutData((Object)formData);
        this.comboFrameSize.add(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.random"));
        this.comboFrameSize.add(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.growing"));
        this.comboFrameSize.select(0);
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment((Control)this.lblFrameSize);
        this.comboFrameSize.setLayoutData((Object)formData);
        Composite composite = new Composite((Composite)group, 0);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.comboFrameSize);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.bottom = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblMinSize = new Label(composite, 0);
        this.lblMinSize.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.labelMinSize"));
        this.txtMinSize = new Text(composite, 2048);
        this.txtMinSize.setLayoutData((Object)new GridData(768));
        this.txtMinSize.setTextLimit(4);
        this.txtMinSize.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.txtMinSize.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.updateTempFrameModifier();
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.lblMaxSize = new Label(composite, 0);
        this.lblMaxSize.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.labelMaxSize"));
        this.txtMaxSize = new Text(composite, 2048);
        this.txtMaxSize.setLayoutData((Object)new GridData(768));
        this.txtMaxSize.setTextLimit(4);
        this.txtMaxSize.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.txtMaxSize.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.updateTempFrameModifier();
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.lblStepSize = new Label(composite, 0);
        this.lblStepSize.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.labelStepSize"));
        this.txtStepSize = new Text(composite, 2048);
        this.txtStepSize.setLayoutData((Object)new GridData(768));
        this.txtStepSize.setTextLimit(4);
        this.txtStepSize.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.txtStepSize.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.lblFrameIteration = new Label(composite, 0);
        this.lblFrameIteration.setText(Messages.getString("FrameBlastingSettingsDialog.frameblasting.FrameModifier.labelFrameIteration"));
        this.txtFrameIteration = new Text(composite, 2048);
        this.txtFrameIteration.setLayoutData((Object)new GridData(768));
        this.txtFrameIteration.setTextLimit(9);
        this.txtFrameIteration.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.txtFrameIteration.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FrameBlastingSettingsDialog.this.setDialogComplete(FrameBlastingSettingsDialog.this.validatePage());
            }
        });
        this.comboFrameSize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = FrameBlastingSettingsDialog.this.comboFrameSize.getSelectionIndex();
                if (selection == 0) {
                    FrameBlastingSettingsDialog.this.lblStepSize.setVisible(false);
                    FrameBlastingSettingsDialog.this.txtStepSize.setVisible(false);
                    FrameBlastingSettingsDialog.this.lblFrameIteration.setVisible(false);
                    FrameBlastingSettingsDialog.this.txtFrameIteration.setVisible(false);
                } else if (selection == 1) {
                    FrameBlastingSettingsDialog.this.lblStepSize.setVisible(true);
                    FrameBlastingSettingsDialog.this.txtStepSize.setVisible(true);
                    FrameBlastingSettingsDialog.this.lblFrameIteration.setVisible(true);
                    FrameBlastingSettingsDialog.this.txtFrameIteration.setVisible(true);
                } else {
                    System.out.println("ERROR : invalid combobox selection");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkUseFrameModifier.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FrameBlastingSettingsDialog.this.updateFrameModifierWidgets();
                FrameBlastingSettingsDialog.this.updateTempFrameModifier();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkUseFrameModifier.setSelection(false);
        this.updateFrameModifierWidgets();
    }

    private void updateTempFrameModifier() {
        if (this.noValidation) {
            return;
        }
        RandomSizeModifier frameModifier = null;
        if (this.checkUseFrameModifier.getSelection()) {
            if (this.comboFrameSize.getSelectionIndex() == 0) {
                RandomSizeModifier randomSizeModifier = frameModifier = ByteblowerguimodelFactoryImpl.eINSTANCE.createRandomSizeModifier();
                randomSizeModifier.setMinSize(Integer.parseInt(this.txtMinSize.getText()));
                randomSizeModifier.setMaxSize(Integer.parseInt(this.txtMaxSize.getText()));
            } else if (this.comboFrameSize.getSelectionIndex() == 1) {
                frameModifier = ByteblowerguimodelFactoryImpl.eINSTANCE.createGrowingSizeModifier();
                GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameModifier;
                growingSizeModifier.setMinSize(Integer.parseInt(this.txtMinSize.getText()));
                growingSizeModifier.setMaxSize(Integer.parseInt(this.txtMaxSize.getText()));
                growingSizeModifier.setFrameIteration(Integer.parseInt(this.txtFrameIteration.getText()));
                growingSizeModifier.setStepSize(Integer.parseInt(this.txtStepSize.getText()));
            }
        }
        this.tempController.setFrameModifier(frameModifier).execute();
    }

    private void updateTempTimingModifier() {
        if (this.noValidation) {
            return;
        }
        MultipleBurst timingModifier = null;
        if (this.checkUseTimingModifier.getSelection()) {
            HighResolutionCalendar interBurstGap = new HighResolutionCalendar();
            HighResolutionCalendarParser.setRelativeTime((String)this.txtInterBurstGap.getText(), (HighResolutionCalendar)interBurstGap);
            timingModifier = ByteblowerguimodelFactory.eINSTANCE.createMultipleBurst();
            timingModifier.setInterBurstGap(String.valueOf(interBurstGap.getTimeInNanoseconds()));
            timingModifier.setNofFramesPerBurst(this.txtNofFramesPerBurst.getText());
        }
        this.tempController.setMultipleBurstModifier(timingModifier).execute();
    }

    private void updateFrameModifierWidgets() {
        boolean enable = this.checkUseFrameModifier.getSelection();
        this.lblFrameSize.setEnabled(enable);
        this.comboFrameSize.setEnabled(enable);
        this.lblMinSize.setEnabled(enable);
        this.txtMinSize.setEnabled(enable);
        this.lblMaxSize.setEnabled(enable);
        this.txtMaxSize.setEnabled(enable);
        this.lblStepSize.setEnabled(enable);
        this.txtStepSize.setEnabled(enable);
        this.lblFrameIteration.setEnabled(enable);
        this.txtFrameIteration.setEnabled(enable);
        if (this.comboFrameSize.getSelectionIndex() == 0) {
            this.lblStepSize.setVisible(false);
            this.txtStepSize.setVisible(false);
            this.lblFrameIteration.setVisible(false);
            this.txtFrameIteration.setVisible(false);
        } else if (this.comboFrameSize.getSelectionIndex() == 1) {
            this.lblStepSize.setVisible(true);
            this.txtStepSize.setVisible(true);
            this.lblFrameIteration.setVisible(true);
            this.txtFrameIteration.setVisible(true);
        } else {
            System.out.println("invalid framesize combobox selection");
            return;
        }
    }

    private void initializeControls() {
        this.noValidation = true;
        TimingModifier timingModifier = this.tempController.getTimingModifier();
        boolean useTimingModifier = timingModifier != null;
        this.checkUseTimingModifier.setSelection(useTimingModifier);
        this.updateTimingModifierWidgets();
        if (!useTimingModifier) {
            this.comboTimingType.select(0);
            this.txtInterBurstGap.setText("10ms");
            this.txtNofFramesPerBurst.setText("1000");
        } else if (timingModifier instanceof MultipleBurst) {
            MultipleBurst multipleBurst = (MultipleBurst)timingModifier;
            HighResolutionCalendar interBurstGap = new HighResolutionCalendar(multipleBurst.getInterBurstGap());
            this.comboTimingType.select(0);
            this.txtInterBurstGap.setText(HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)interBurstGap, (boolean)false, (boolean)true));
            this.txtNofFramesPerBurst.setText(multipleBurst.getNofFramesPerBurst());
        } else {
            this.comboTimingType.setEnabled(false);
            System.out.println("invalid Timing Modifier");
            return;
        }
        FrameModifier frameModifier = this.tempController.getFrameModifier();
        boolean useFrameModifier = frameModifier != null;
        this.checkUseFrameModifier.setSelection(useFrameModifier);
        this.updateFrameModifierWidgets();
        if (!useFrameModifier) {
            this.txtMaxSize.setText("1514");
            this.txtMinSize.setText("60");
            this.txtFrameIteration.setText("1");
            this.txtStepSize.setText("1");
        }
        if (frameModifier instanceof FrameSizeModifier) {
            FrameSizeModifier frameSizeModifier = (FrameSizeModifier)frameModifier;
            if (frameSizeModifier instanceof RandomSizeModifier) {
                RandomSizeModifier randomSizeModifier = (RandomSizeModifier)frameSizeModifier;
                this.comboFrameSize.select(0);
                this.txtMinSize.setText(Integer.toString(randomSizeModifier.getMinSize()));
                this.txtMaxSize.setText(Integer.toString(randomSizeModifier.getMaxSize()));
                this.txtFrameIteration.setText("1");
                this.txtStepSize.setText("1");
            } else if (frameSizeModifier instanceof GrowingSizeModifier) {
                GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameSizeModifier;
                this.comboFrameSize.select(1);
                this.txtMinSize.setText(Integer.toString(growingSizeModifier.getMinSize()));
                this.txtMaxSize.setText(Integer.toString(growingSizeModifier.getMaxSize()));
                this.txtFrameIteration.setText(Integer.toString(growingSizeModifier.getFrameIteration()));
                this.txtStepSize.setText(Integer.toString(growingSizeModifier.getStepSize()));
            } else {
                System.out.println("invalid Frame Size Modifier");
                return;
            }
            this.updateFrameModifierWidgets();
        }
        this.noValidation = false;
    }

    protected void okPressed() {
        ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change FrameBlasting Flow Template");
        operation.appendCommand(this.origController.setFrameInterval(this.tempController.getFrameInterval()));
        operation.appendCommand(this.origController.setDataRateUnit(this.tempController.getDataRateUnit()));
        if (this.checkUseTimingModifier.getSelection()) {
            if (this.comboTimingType.getSelectionIndex() == 0) {
                TimingModifier oldTimingModifier = this.frameBlastingFlow.getTimingModifier();
                MultipleBurst multipleBurst = null;
                HighResolutionCalendar interBurstGap = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)this.txtInterBurstGap.getText(), (HighResolutionCalendar)interBurstGap);
                if (oldTimingModifier != null && oldTimingModifier instanceof MultipleBurst) {
                    multipleBurst = (MultipleBurst)oldTimingModifier;
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)multipleBurst, (Object)ByteblowerguimodelPackage.Literals.MULTIPLE_BURST__INTER_BURST_GAP, (Object)String.valueOf(interBurstGap.getTimeInNanoseconds())));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)multipleBurst, (Object)ByteblowerguimodelPackage.Literals.MULTIPLE_BURST__NOF_FRAMES_PER_BURST, (Object)this.txtNofFramesPerBurst.getText()));
                } else {
                    multipleBurst = ByteblowerguimodelFactoryImpl.eINSTANCE.createMultipleBurst();
                    multipleBurst.setInterBurstGap(String.valueOf(interBurstGap.getTimeInNanoseconds()));
                    multipleBurst.setNofFramesPerBurst(this.txtNofFramesPerBurst.getText());
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.frameBlastingFlow, (Object)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__TIMING_MODIFIER, (Object)multipleBurst));
                }
            }
        } else {
            operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.frameBlastingFlow, (Object)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__TIMING_MODIFIER, null));
        }
        if (this.checkUseFrameModifier.getSelection()) {
            FrameModifier oldFrameModifier = this.frameBlastingFlow.getFrameModifier();
            if (this.comboFrameSize.getSelectionIndex() == 0) {
                RandomSizeModifier random = null;
                if (oldFrameModifier instanceof RandomSizeModifier) {
                    random = (RandomSizeModifier)oldFrameModifier;
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)random, (Object)ByteblowerguimodelPackage.Literals.RANDOM_SIZE_MODIFIER__MIN_SIZE, (Object)Integer.parseInt(this.txtMinSize.getText())));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)random, (Object)ByteblowerguimodelPackage.Literals.RANDOM_SIZE_MODIFIER__MAX_SIZE, (Object)Integer.parseInt(this.txtMaxSize.getText())));
                } else {
                    random = ByteblowerguimodelFactoryImpl.eINSTANCE.createRandomSizeModifier();
                    random.setMinSize(Integer.parseInt(this.txtMinSize.getText()));
                    random.setMaxSize(Integer.parseInt(this.txtMaxSize.getText()));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.frameBlastingFlow, (Object)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, (Object)random));
                }
            } else if (this.comboFrameSize.getSelectionIndex() == 1) {
                GrowingSizeModifier growing = null;
                if (oldFrameModifier instanceof GrowingSizeModifier) {
                    growing = (GrowingSizeModifier)oldFrameModifier;
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)growing, (Object)ByteblowerguimodelPackage.Literals.GROWING_SIZE_MODIFIER__MIN_SIZE, (Object)Integer.parseInt(this.txtMinSize.getText())));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)growing, (Object)ByteblowerguimodelPackage.Literals.GROWING_SIZE_MODIFIER__MAX_SIZE, (Object)Integer.parseInt(this.txtMaxSize.getText())));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)growing, (Object)ByteblowerguimodelPackage.Literals.GROWING_SIZE_MODIFIER__STEP_SIZE, (Object)Integer.parseInt(this.txtStepSize.getText())));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)growing, (Object)ByteblowerguimodelPackage.Literals.GROWING_SIZE_MODIFIER__FRAME_ITERATION, (Object)Integer.parseInt(this.txtFrameIteration.getText())));
                } else {
                    growing = ByteblowerguimodelFactoryImpl.eINSTANCE.createGrowingSizeModifier();
                    growing.setMinSize(Integer.parseInt(this.txtMinSize.getText()));
                    growing.setMaxSize(Integer.parseInt(this.txtMaxSize.getText()));
                    growing.setStepSize(Integer.parseInt(this.txtStepSize.getText()));
                    growing.setFrameIteration(Integer.parseInt(this.txtFrameIteration.getText()));
                    operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.frameBlastingFlow, (Object)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, (Object)growing));
                }
            } else {
                System.out.println("error while saving : FrameModifier is of unknown type");
            }
        } else {
            operation.appendCommand(SetCommand.create((EditingDomain)ByteBlowerEditingDomainProvider.getEditingDomain(), (Object)this.frameBlastingFlow, (Object)ByteblowerguimodelPackage.Literals.FRAME_BLASTING_FLOW__FRAME_MODIFIER, null));
        }
        operation.run();
        this.rateComposite.dispose();
        this.rateComposite = null;
        this.close();
    }

    private void setDialogComplete(boolean value) {
        if (this.okButton != null) {
            this.okButton.setEnabled(value);
        }
    }

    private boolean validatePage() {
        HighResolutionCalendar MIN_INTER_BURST_GAP = new HighResolutionCalendar(Long.valueOf(960000L));
        if (this.noValidation) {
            return false;
        }
        if (this.frameBlastingFlow == null) {
            return false;
        }
        String string = this.txtInterBurstGap.getText();
        if (string.equals("")) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.mininterburstgap"));
            return false;
        }
        string = this.txtNofFramesPerBurst.getText();
        if (this.getLong(this.txtNofFramesPerBurst.getText(), -1L) < 1L) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframeinburst"));
            return false;
        }
        HighResolutionCalendar interBurstGap = new HighResolutionCalendar();
        HighResolutionCalendarParser.parseToRelativeTime((String)this.txtInterBurstGap.getText(), (HighResolutionCalendar)interBurstGap);
        if (MIN_INTER_BURST_GAP.compareTo((Calendar)interBurstGap) == 1) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.mininterburstgap"));
            return false;
        }
        string = this.txtMinSize.getText();
        if (string == "") {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframesize"));
            return false;
        }
        int min = Integer.parseInt(string);
        if (min < 60) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframesize"));
            return false;
        }
        if (min > 8192) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.maxframesize"));
            return false;
        }
        string = this.txtMaxSize.getText();
        if (string == "") {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframesize"));
            return false;
        }
        int max = Integer.parseInt(string);
        if (max < 60) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframesize"));
            return false;
        }
        if (max > 8192) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.maxframesize"));
            return false;
        }
        if (min >= max) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.min_biggerthan_maxframesize"));
            return false;
        }
        string = this.txtStepSize.getText();
        if (string == "") {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minstepsize"));
            return false;
        }
        int step = Integer.parseInt(string);
        if (step < 1) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minstepsize"));
            return false;
        }
        if (step > max) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.maxstepsize"));
            return false;
        }
        string = this.txtFrameIteration.getText();
        if (string == "") {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframeiteration"));
            return false;
        }
        if (Integer.parseInt(string) < 1) {
            this.setErrorMessage(Messages.getString("FrameBlastingSettingsDialog.error.minframeiteration"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private long getLong(String text, long invalid) {
        if (text == null) {
            return invalid;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            return invalid;
        }
    }
}

