/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FrameLengthDialog
extends TitleAreaDialog {
    private Button okButton;
    private Text txtLength;
    private int length = 0;

    public FrameLengthDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String shellText = Messages.getString("FrameLengthDialog.shell");
        shell.setText(shellText);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("FrameLengthDialog.title"));
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Label lblTotalLength = new Label(composite, 0);
        lblTotalLength.setText(Messages.getString("FrameLengthDialog.label"));
        this.txtLength = IntegerTextFactory.instance().create(composite, 9999L);
        this.txtLength.setLayoutData((Object)new GridData(768));
        this.txtLength.setText(Integer.toString(this.length));
        this.txtLength.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String txt;
                boolean ok = FrameLengthDialog.this.validateDialog();
                if (ok && (txt = FrameLengthDialog.this.txtLength.getText()).length() != 0) {
                    FrameLengthDialog.this.length = Integer.parseInt(txt);
                }
                FrameLengthDialog.this.setDialogComplete(ok);
            }
        });
        Label lblUnit = new Label(composite, 0);
        lblUnit.setText(Messages.getString("FrameLengthDialog.unit"));
        return parentComposite;
    }

    private boolean validateDialog() {
        String lenTxt = this.txtLength.getText();
        if (lenTxt == "") {
            return false;
        }
        int len = Integer.parseInt(lenTxt);
        if (len < 60) {
            this.setErrorMessage("The minimum Frame length is " + Integer.toString(60) + " bytes.");
            this.txtLength.setForeground(ColorConstants.red);
            return false;
        }
        if (len > 8192) {
            this.setErrorMessage("The maximum Frame length is " + Integer.toString(8192) + " bytes.");
            this.txtLength.setForeground(ColorConstants.red);
            return false;
        }
        this.txtLength.setForeground(null);
        this.setErrorMessage(null);
        return true;
    }

    private void setDialogComplete(boolean value) {
        if (this.okButton != null) {
            this.okButton.setEnabled(value);
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

