/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

abstract class IncrementDialog
extends TitleAreaDialog
implements ModifyListener {
    private int incrementSize;
    private int maxDigits;
    private String typeName;
    private Button okButton;
    private Text txtIncrement;

    IncrementDialog(Shell parentShell, int initialIncrementSize, int maxDigits, String typeName) {
        super(parentShell);
        this.incrementSize = initialIncrementSize;
        this.maxDigits = maxDigits;
        this.typeName = typeName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.typeName);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Copy Down Incrementing");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Label label = new Label(composite, 0);
        label.setText("Increment " + this.typeName + " with:");
        this.txtIncrement = IntegerTextFactory.instance().createWithTextLimit(composite, this.maxDigits);
        this.txtIncrement.addModifyListener((ModifyListener)this);
        int caretPos = this.txtIncrement.getCaretPosition();
        this.txtIncrement.setText(Integer.toString(this.incrementSize));
        this.txtIncrement.setSelection(caretPos, caretPos);
        this.txtIncrement.setLayoutData((Object)new GridData(768));
        this.txtIncrement.setFocus();
        this.txtIncrement.selectAll();
        return parentComposite;
    }

    private void setDialogComplete(boolean value) {
        if (this.okButton != null) {
            this.okButton.setEnabled(value);
        }
    }

    private boolean validateDialog() {
        String duration = this.txtIncrement.getText();
        return duration.length() != 0;
    }

    public void modifyText(ModifyEvent e) {
        String value;
        Control control = (Control)e.widget;
        if (!control.isFocusControl()) {
            return;
        }
        if (control == this.txtIncrement && (value = this.txtIncrement.getText()).length() != 0) {
            this.incrementSize = Integer.parseInt(value);
        }
        this.setDialogComplete(this.validateDialog());
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }
}

