/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.IProjectProperties;
import com.excentis.products.byteblower.gui.widgets.dialogs.PropertiesComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.regex.Pattern;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class LossPropertiesComposite
extends PropertiesComposite
implements VerifyListener,
ModifyListener,
IProjectProperties {
    protected IWorkbench workbench;
    private Float warningLossLevel;
    private Float errorLossLevel;
    private Text aText;
    private Label aText2;
    private Text bText;
    private Label bText2;
    private static String editPattern = "^(((\\d?\\d?)?([.]\\d?\\d?)?)?)$";

    public LossPropertiesComposite(Composite parent) {
        super(parent);
        this.createContents();
    }

    private void createLossTab(Composite composite) {
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        Label info = new Label(composite, 0);
        info.setText("In the ByteBlower Reports, loss percentages are displayed in different colours.\nThe loss percentages associated with each colour can be defined here:\n\n\n");
        info.setLayoutData((Object)new GridData(512));
        Composite parameterComposite = new Composite(composite, 2048);
        parameterComposite.setLayoutData((Object)new GridData(64));
        parameterComposite.setLayout((Layout)new GridLayout(3, false));
        parameterComposite.setBackground(ExcentisColors.lightgrey);
        Label aLossLeft = new Label(parameterComposite, 0);
        aLossLeft.setVisible(false);
        this.createLossText(parameterComposite, ExcentisColors.magenta);
        Composite aLossRightComposite = new Composite(parameterComposite, 0);
        aLossRightComposite.setLayout((Layout)new GridLayout(3, false));
        Label aLossRight = new Label(aLossRightComposite, 0);
        aLossRight.setText("<");
        Label aLossRightText = new Label(aLossRightComposite, 0);
        aLossRightText.setText("0");
        Label aLossRightLabel = new Label(aLossRightComposite, 0);
        aLossRightLabel.setText(" %");
        Composite bLossLeftComposite = new Composite(parameterComposite, 0);
        bLossLeftComposite.setLayout((Layout)new GridLayout(2, false));
        Label bLossLeftVal = new Label(bLossLeftComposite, 0);
        bLossLeftVal.setText("0");
        Label bLossLeft = new Label(bLossLeftComposite, 0);
        bLossLeft.setText("% <=");
        this.createLossText(parameterComposite, ColorConstants.black);
        Composite bLossRightComposite = new Composite(parameterComposite, 0);
        bLossRightComposite.setLayout((Layout)new GridLayout(3, false));
        Label bLossRight = new Label(bLossRightComposite, 0);
        bLossRight.setText("<");
        this.aText = new Text(bLossRightComposite, 2048);
        this.aText.setTextLimit(5);
        Label bLossRightLabel = new Label(bLossRightComposite, 0);
        bLossRightLabel.setText(" %");
        Composite cLossLeftComposite = new Composite(parameterComposite, 0);
        cLossLeftComposite.setLayout((Layout)new GridLayout(2, false));
        this.aText2 = new Label(cLossLeftComposite, 0);
        Label cLossLeft = new Label(cLossLeftComposite, 0);
        cLossLeft.setText("% <=");
        this.createLossText(parameterComposite, ColorConstants.orange);
        Composite cLossRightComposite = new Composite(parameterComposite, 0);
        cLossRightComposite.setLayout((Layout)new GridLayout(3, false));
        Label cLossRight = new Label(cLossRightComposite, 0);
        cLossRight.setText("<");
        this.bText = new Text(cLossRightComposite, 2048);
        this.bText.setTextLimit(5);
        Label cLossRightLabel = new Label(cLossRightComposite, 0);
        cLossRightLabel.setText(" %");
        Composite dLossLeftComposite = new Composite(parameterComposite, 0);
        dLossLeftComposite.setLayout((Layout)new GridLayout(2, false));
        this.bText2 = new Label(dLossLeftComposite, 0);
        Label dLossLeft = new Label(dLossLeftComposite, 0);
        dLossLeft.setText("% <=");
        this.createLossText(parameterComposite, ColorConstants.red);
        Composite dLossRightComposite = new Composite(parameterComposite, 0);
        dLossRightComposite.setLayout((Layout)new GridLayout(3, false));
        Label dLossRight = new Label(dLossRightComposite, 0);
        dLossRight.setText("<=");
        Label dLossRightText = new Label(dLossRightComposite, 0);
        dLossRightText.setText("100");
        Label dLossRightLabel = new Label(dLossRightComposite, 0);
        dLossRightLabel.setText(" %");
        this.copyBackgroundToChildren(parameterComposite);
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String warningLevel = "";
        warningLevel = currentProject == null ? ByteBlowerPreferences.getWarningLossLevel() : currentProject.getWarningLossLevel();
        if (warningLevel == "") {
            warningLevel = "0.01";
        }
        Float warning = new Float(warningLevel);
        float percentage = warning.floatValue() * 100.0f;
        this.aText.setText(Float.toString(percentage));
        String errorLevel = "";
        errorLevel = currentProject == null ? ByteBlowerPreferences.getErrorLossLevel() : currentProject.getErrorLossLevel();
        if (errorLevel == "") {
            errorLevel = "0.02";
        }
        Float error = new Float(errorLevel);
        percentage = error.floatValue() * 100.0f;
        this.bText.setText(Float.toString(percentage));
        this.aText.addVerifyListener((VerifyListener)this);
        this.aText.addModifyListener((ModifyListener)this);
        this.bText.addVerifyListener((VerifyListener)this);
        this.bText.addModifyListener((ModifyListener)this);
    }

    private void copyBackgroundToChildren(Composite parentComposite) {
        Control[] controlArray = parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!(control instanceof Text)) {
                control.setBackground(parentComposite.getBackground());
            }
            if (control instanceof Composite) {
                this.copyBackgroundToChildren((Composite)control);
            }
            ++n2;
        }
    }

    private void createLossText(Composite parameterComposite, Color color) {
        StyledText lossText1 = new StyledText(parameterComposite, 8);
        lossText1.setText("LOSS");
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = 4;
        styleRange.fontStyle = 1;
        styleRange.foreground = color;
        lossText1.setStyleRange(styleRange);
    }

    private boolean updateWidgets() {
        this.aText2.setText(this.aText.getText());
        this.bText2.setText(this.bText.getText());
        String errorMessageInvalidPercentages = "Invalid loss percentages";
        try {
            String warningPercentage = this.aText.getText().replaceAll("\\,", "\\.");
            this.warningLossLevel = new Float(warningPercentage);
            if (this.warningLossLevel.floatValue() < 0.0f || this.warningLossLevel.floatValue() > 100.0f) {
                this.setInvalid(errorMessageInvalidPercentages);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setInvalid(errorMessageInvalidPercentages);
            return false;
        }
        try {
            String errorPercentage = this.bText.getText().replaceAll("\\,", "\\.");
            this.errorLossLevel = new Float(errorPercentage);
            if (this.errorLossLevel.floatValue() < 0.0f || this.errorLossLevel.floatValue() > 100.0f) {
                this.setInvalid(errorMessageInvalidPercentages);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setInvalid(errorMessageInvalidPercentages);
            return false;
        }
        if (this.warningLossLevel.compareTo(this.errorLossLevel) >= 0) {
            this.setInvalid(errorMessageInvalidPercentages);
            return false;
        }
        this.setInvalid(null);
        return true;
    }

    @Override
    public void setAsDefault() {
        float warnLevel = this.warningLossLevel.floatValue() / 100.0f;
        ByteBlowerPreferences.setWarningLossLevel((String)Float.toString(warnLevel));
        float lossLevel = this.errorLossLevel.floatValue() / 100.0f;
        ByteBlowerPreferences.setErrorLossLevel((String)Float.toString(lossLevel));
    }

    public void verifyText(VerifyEvent e) {
        Text t = (Text)e.widget;
        String previous = t.getText();
        String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
        e.doit = Pattern.matches(editPattern, result);
    }

    public void modifyText(ModifyEvent e) {
        this.updateWidgets();
    }

    protected void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.createLossTab(this);
        this.updateWidgets();
    }

    @Override
    public void performOk() {
        ByteBlowerProject currentProject = ByteBlowerGuiResourceController.getInstance().getActiveProject();
        String warnLevel = Float.toString(this.warningLossLevel.floatValue() / 100.0f);
        String errorLevel = Float.toString(this.errorLossLevel.floatValue() / 100.0f);
        if (currentProject.getWarningLossLevel().equals(warnLevel) && currentProject.getErrorLossLevel().equals(errorLevel)) {
            return;
        }
        CompoundCommandController compCommCtlr = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectCtlr = new ByteBlowerProjectController(currentProject);
        compCommCtlr.appendCommand(projectCtlr.setWarningLossLevel(warnLevel));
        compCommCtlr.appendCommand(projectCtlr.setErrorLossLevel(errorLevel));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(currentProject, "Loss Project Preferences", compCommCtlr.unwrap());
        operation.run();
    }
}

