/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.swt.dialogs.PcapCaptureDialog;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.gui.widgets.dialogs.ProjectPropertiesDialog;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ScenarioPauseDialog
extends MessageDialog {
    private Button keepWaitingButton = null;
    private final String scenarioName;
    private final Shell parentShell;

    private static boolean canCapture(ByteBlowerGuiPortReader port) {
        return port.isDocked() && port.isDockingOk() && !port.isDockedOnMobileDevice();
    }

    private ScenarioPauseDialog(Shell parentShell, String dialogTitle, String dialogMessage, String[] dialogButtonLabels, String scenarioName) {
        super(parentShell, dialogTitle, null, dialogMessage, 5, dialogButtonLabels, 0);
        this.scenarioName = scenarioName;
        this.parentShell = parentShell;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    public static boolean open(String scenarioName, String title, String description) {
        Shell sh = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return ScenarioPauseDialog.open(sh, scenarioName, title, description);
    }

    private static boolean open(Shell parent, String scenarioName, String title, String message) {
        String[] dialogButtonLabels = new String[]{Messages.getString("ScenarioPauseDialog.resumeScenario"), Messages.getString("ScenarioPauseDialog.cancelScenario")};
        ScenarioPauseDialog dialog = new ScenarioPauseDialog(parent, title, message, dialogButtonLabels, scenarioName);
        int dialogReturn = dialog.open();
        return dialogReturn == 0 || dialogReturn == -1;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite line = new Composite(parent, 0);
        line.setLayout((Layout)new GridLayout(2, false));
        this.keepWaitingButton = new Button(line, 32);
        this.keepWaitingButton.setText(Messages.getString("ScenarioPauseDialog.keepWaiting"));
        this.keepWaitingButton.setSelection(true);
        this.keepWaitingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean keepWaiting = ScenarioPauseDialog.this.keepWaitingButton.getSelection();
                ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
                UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(projectController.getProject(), Messages.getString("ScenarioPauseDialog.changePreference"), projectController.setScenarioPauseAfterDhcp(keepWaiting));
                operation.run();
            }
        });
        Link propertiesLink = new Link(line, 0);
        propertiesLink.setLayoutData((Object)new GridData(4, 4, true, true));
        propertiesLink.setText("Config also found in <a>the Project Properties</a>");
        propertiesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertiesDialog dialog = new ProjectPropertiesDialog(ScenarioPauseDialog.this.getShell(), 6);
                dialog.open();
            }
        });
        Group inviteCaptures = new Group(parent, 0);
        inviteCaptures.setText("Start capture on:");
        inviteCaptures.setLayout((Layout)new GridLayout());
        inviteCaptures.setLayoutData((Object)new GridData(1808));
        ScrolledComposite scrollPane = new ScrolledComposite((Composite)inviteCaptures, 512);
        scrollPane.setAlwaysShowScrollBars(true);
        scrollPane.setExpandHorizontal(true);
        scrollPane.setLayoutData((Object)new GridData(1808));
        Composite scrolledContent = new Composite((Composite)scrollPane, 0);
        scrollPane.setContent((Control)scrolledContent);
        scrolledContent.setLayoutData((Object)new GridData(600, 4, true, true));
        ByteBlowerProjectController project = ByteBlowerGuiResourceController.getProjectController();
        scrolledContent.setLayout((Layout)new GridLayout(1, true));
        this.createCaptureButtons(scrolledContent, project);
        scrolledContent.setLayout((Layout)new GridLayout(1, true));
        Point computedSize = scrolledContent.computeSize(-1, -1);
        scrolledContent.setSize(computedSize);
        return parent;
    }

    private void createCaptureButtons(Composite scrolledContent, ByteBlowerProjectController project) {
        Button allPorts = new Button(scrolledContent, 32);
        allPorts.setText("All Interfaces in the Project");
        Button allScenario = new Button(scrolledContent, 32);
        allScenario.setText("All interfaces in the current Scenario");
        HashMap<String, ByteBlowerGuiPortReader> scenarioPorts = new HashMap<String, ByteBlowerGuiPortReader>();
        ArrayList<Button> scenarioButtons = new ArrayList<Button>();
        scenarioButtons.add(allScenario);
        ArrayList<Button> allButtons = new ArrayList<Button>();
        allButtons.add(allPorts);
        allButtons.add(allScenario);
        for (ByteBlowerGuiPort aPort : project.getScenarioControllerByName(this.scenarioName).getInvolvedPorts()) {
            scenarioPorts.put(aPort.getName(), ReaderFactory.create((ByteBlowerGuiPort)aPort));
        }
        DependedPcapCapures dependancyManager = new DependedPcapCapures();
        ArrayList<ByteBlowerGuiPortReader> goodPorts = new ArrayList<ByteBlowerGuiPortReader>();
        for (ByteBlowerGuiPortReader port : project.getByteBlowerGuiPortReaders()) {
            Button aCapture = new Button(scrolledContent, 32);
            aCapture.setText(port.getName());
            aCapture.setLayoutData((Object)new GridData(600, -1));
            boolean canCapture = ScenarioPauseDialog.canCapture(port);
            aCapture.setEnabled(canCapture);
            if (canCapture) {
                goodPorts.add(port);
            }
            allButtons.add(aCapture);
            if (scenarioPorts.containsKey(port.getName())) {
                scenarioButtons.add(aCapture);
            }
            aCapture.addSelectionListener((SelectionListener)new StartCapture(dependancyManager, port, aCapture));
        }
        allPorts.addSelectionListener((SelectionListener)new StartCapture(dependancyManager, goodPorts, allButtons));
        allScenario.addSelectionListener((SelectionListener)new StartCapture(dependancyManager, scenarioPorts.values(), scenarioButtons));
    }

    private static final class DependedPcapCapures {
        private final HashSet<String> hasBeenStarted = new HashSet();
        private final Collection<PcapStarted> dependants = new ArrayList<PcapStarted>();

        private DependedPcapCapures() {
        }

        public void addDependant(PcapStarted starter) {
            this.dependants.add(starter);
        }

        private String calculateId(ByteBlowerGuiPortReader port) {
            PhysicalConfigurationReader actualServerConfig = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
            PhysicalDockable dockable = actualServerConfig.getPhysicalDockable(port);
            return PcapCaptureDialog.captureLocationId((EByteBlowerServerObject)dockable);
        }

        private boolean tryStart(ByteBlowerGuiPortReader port) {
            String id = this.calculateId(port);
            boolean canStart = !this.hasBeenStarted.contains(id);
            this.hasBeenStarted.add(id);
            this.dependants.stream().forEach(a -> a.started(id));
            return canStart;
        }

        public boolean canStart(ByteBlowerGuiPortReader port) {
            String id = this.calculateId(port);
            return !this.hasBeenStarted.contains(id);
        }

        static interface PcapStarted {
            public void started(String var1);
        }
    }

    private final class StartCapture
    extends SelectionAdapter
    implements DependedPcapCapures.PcapStarted {
        private Collection<ByteBlowerGuiPortReader> ports;
        private final Collection<Button> aCapture;
        private final DependedPcapCapures dependancyManager;

        private StartCapture(DependedPcapCapures mng, Collection<ByteBlowerGuiPortReader> toOpen, Collection<Button> aCapture) {
            mng.addDependant(this);
            this.ports = new ArrayList<ByteBlowerGuiPortReader>();
            for (ByteBlowerGuiPortReader aPort : toOpen) {
                if (!ScenarioPauseDialog.canCapture(aPort)) continue;
                this.ports.add(aPort);
            }
            this.aCapture = new ArrayList<Button>(aCapture);
            this.dependancyManager = mng;
        }

        private StartCapture(DependedPcapCapures mng, ByteBlowerGuiPortReader port, Button aCapture) {
            this(mng, Arrays.asList(port), Arrays.asList(aCapture));
        }

        public void widgetSelected(SelectionEvent e) {
            this.disableButtons();
            for (ByteBlowerGuiPortReader port : this.ports) {
                if (!this.dependancyManager.tryStart(port)) continue;
                PhysicalConfigurationReader actualServerConfig = PhysicalConfigurationManager.getInstance().getPhysicalConfigurationReader();
                PhysicalDockable dockable = actualServerConfig.getPhysicalDockable(port);
                PcapCaptureDialog captureDialog = new PcapCaptureDialog(ScenarioPauseDialog.this.parentShell, (EByteBlowerServerObject)dockable);
                captureDialog.open();
                captureDialog.startCapture();
            }
            Display.getCurrent().asyncExec(() -> {
                boolean bl = ScenarioPauseDialog.this.getShell().forceFocus();
            });
        }

        private void disableButtons() {
            for (Button b : this.aCapture) {
                b.setEnabled(false);
                b.setSelection(true);
            }
        }

        @Override
        public void started(String id) {
            ArrayList<ByteBlowerGuiPortReader> newPorts = new ArrayList<ByteBlowerGuiPortReader>(this.ports.size());
            for (ByteBlowerGuiPortReader port : this.ports) {
                if (!this.dependancyManager.canStart(port)) continue;
                newPorts.add(port);
            }
            this.ports = newPorts;
            if (this.ports.isEmpty()) {
                this.disableButtons();
            }
        }
    }
}

