/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.dialogs;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.widgets.dialogs.Messages;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import java.util.AbstractCollection;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SelectByteBlowerPortDialog
extends TitleAreaDialog {
    private Button okButton;
    private ByteBlowerGuiPort selectedPort;
    private ByteBlowerGuiPort initialSelectedPort;
    private Collection<ByteBlowerGuiPort> tempByteBlowerPorts;
    private String shellText;
    private TableViewer tableViewer;
    private Image dlgTitleImage = null;

    public SelectByteBlowerPortDialog(Shell parentShell, String shellText, ByteBlowerGuiPort initialSelectedPort) {
        super(parentShell);
        this.shellText = shellText;
        this.initialSelectedPort = initialSelectedPort;
        this.tempByteBlowerPorts = ByteBlowerGuiResourceController.getProject().getByteBlowerGuiPort();
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.shellText);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.setTitle(Messages.getString("SelectByteBlowerPortDialog.info"));
        ImageDescriptor imagedescr = ImageDescriptor.createFromFile(ImageCache.class, (String)"dialogs/SelectByteBlowerPort.gif");
        this.dlgTitleImage = imagedescr.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Table portTable = new Table(composite, 2048);
        portTable.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(portTable);
        ComposedAdapterFactory adapterFactory = ByteBlowerEditingDomainProvider.getAdapterFactory();
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                AbstractCollection byteBlowerPorts = (AbstractCollection)object;
                return byteBlowerPorts.toArray();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectByteBlowerPortDialog.this.setDialogComplete(SelectByteBlowerPortDialog.this.validatePage());
            }
        });
        portTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectByteBlowerPortDialog.this.validatePage()) {
                    SelectByteBlowerPortDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.tableViewer.setInput(this.tempByteBlowerPorts);
        return parentComposite;
    }

    public ByteBlowerGuiPort getSelectedByteBlowerPort() {
        return this.selectedPort;
    }

    private void initializeControls() {
        if (this.initialSelectedPort != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialSelectedPort));
        }
        this.setDialogComplete(this.validatePage());
    }

    protected void okPressed() {
        this.selectedPort = (ByteBlowerGuiPort)((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        this.close();
    }

    private void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        return ((StructuredSelection)this.tableViewer.getSelection()).size() == 1;
    }
}

