/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.widgets.project;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class EclipseProjectResource {
    private static final String projects = "Projects";
    private static final String reportdata = "ReportData";

    private static IProject getHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projects);
    }

    public static String getDefaultProjectLocation() {
        Path path = new Path(ByteBlowerPreferences.getRuntimeWorkspaceLocation());
        path = path.append(projects);
        return path.toOSString();
    }

    public static String getDefaultReportDataLocation() {
        Path path = new Path(ByteBlowerPreferences.getRuntimeWorkspaceLocation());
        path = path.append(reportdata);
        return path.toOSString();
    }

    private static void createEclipseProject() {
        try {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IProject project = ws.getRoot().getProject(projects);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IProject getProject() throws CoreException {
        IProject project = EclipseProjectResource.getHandle();
        if (!project.exists()) {
            EclipseProjectResource.createEclipseProject();
        }
        project.refreshLocal(2, null);
        return project;
    }
}

