/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui;

import com.excentis.products.byteblower.gui.ByteBlowerPlugin;
import com.excentis.products.byteblower.gui.actions.ByteBlowerWorkbenchWindowAdvisor;
import com.excentis.products.byteblower.gui.logger.GuiLogger;
import com.excentis.products.byteblower.gui.perspectives.ByteBlowerWorkbenchAdvisor;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Version;

public class ByteBlowerApplication
implements IApplication {
    private static String autoOpenProjectFile = null;
    private static boolean showCltHelp = false;

    private String parseArguments(String[] args) {
        System.out.println("Program arguments:");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            System.out.print(String.valueOf(arg) + ", ");
            ++n2;
        }
        System.out.println();
        int argLen = args.length;
        String errorInfo = "";
        int i = 0;
        while (i < argLen) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-custom-update-site")) {
                String nextArg = i + 1 < argLen ? args[i + 1] : "";
                PlatformUI.getPreferenceStore().setValue("custom-update-site", nextArg);
                System.out.println("Updating to the update site! " + nextArg);
            }
            if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("--help")) {
                showCltHelp = true;
            } else if (arg.indexOf(".bbp") != -1) {
                File file = new File(arg);
                if (file.exists()) {
                    autoOpenProjectFile = arg;
                }
            } else if (arg.startsWith("-") && i + 1 < argLen) {
                String nextArg = args[i + 1];
                if (arg.equalsIgnoreCase("-project")) {
                    autoOpenProjectFile = nextArg;
                    ++i;
                }
            }
            ++i;
        }
        if (autoOpenProjectFile != null) {
            ByteBlowerWorkbenchWindowAdvisor.setAutoOpenProjectFile((String)autoOpenProjectFile);
        }
        return errorInfo == "" ? null : errorInfo;
    }

    public Object start(IApplicationContext context) throws Exception {
        String errorInfo = this.parseArguments(Platform.getCommandLineArgs());
        if (errorInfo != null) {
            GuiLogger.log("Arguments Error : " + errorInfo);
            if (!showCltHelp) {
                System.out.println("Use option -h for help.\n");
            }
        }
        Version thisVersion = ByteBlowerPlugin.getDefault().getBundle().getVersion();
        Display display = PlatformUI.createDisplay();
        String startTxt = String.format("ByteBlower GUI %s is running !", thisVersion.toString());
        ByteBlowerPlugin.getDefault().getLog().log((IStatus)new Status(1, "com.excentis.products.byteblower.gui", startTxt));
        System.out.println(startTxt);
        try {
            ByteBlowerWorkbenchAdvisor workbenchAdvisor = new ByteBlowerWorkbenchAdvisor();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            if (display != null && !display.isDisposed()) {
                display.dispose();
            }
        }
    }

    public void stop() {
    }
}

