/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.RealTimeSortBatchActionBlocksCommand;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigInteger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class BatchActionController
extends EByteBlowerObjectController<BatchAction> {
    public BatchActionController(BatchAction myBatchAction) {
        super(myBatchAction);
    }

    protected static final BatchAction create() {
        BatchAction newBatchAction = EByteBlowerObjectController.getByteblowerguimodelFactory().createBatchAction();
        newBatchAction.setStartTime(new HighResolutionCalendar());
        return newBatchAction;
    }

    public boolean isContained() {
        Batch batch;
        BatchActionBlock batchActionBlock;
        BatchAction myBatchAction = (BatchAction)this.getObject();
        return myBatchAction != null && (batchActionBlock = myBatchAction.getBatchActionBlock()) != null && (batch = batchActionBlock.getBatch()) != null;
    }

    public Batch getBatch() {
        BatchActionBlock batchActionBlock;
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null && (batchActionBlock = myBatchAction.getBatchActionBlock()) != null) {
            return batchActionBlock.getBatch();
        }
        return null;
    }

    public BatchActionBlock getBatchActionBlock() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getBatchActionBlock();
        }
        return null;
    }

    public final HighResolutionCalendar getStartTime() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getStartTime();
        }
        return null;
    }

    private boolean isValidRelativeStartTimeString(String relativeStartTimeString) {
        return HighResolutionCalendarParser.relativeTimeInputPatternMatches((String)relativeStartTimeString);
    }

    public boolean isValidStartTimeString(String startTimeString, TimedStartType startType) {
        switch (startType.getValue()) {
            case 0: {
                return this.isValidRelativeStartTimeString(startTimeString);
            }
        }
        return false;
    }

    public final Scenario getScenario() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getScenario();
        }
        return null;
    }

    private final Command createSetScenarioCommand(Scenario newScenario) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__SCENARIO, newScenario);
    }

    public final Command setScenario(Scenario newScenario) {
        return this.createSetScenarioCommand(newScenario);
    }

    public final CommandWithScenarioReference copyScenario(Scenario scenario) {
        Command command = this.createSetScenarioCommand(scenario);
        return new CommandWithScenarioReference(command, scenario);
    }

    public final HighResolutionCalendar getInitializationTime() {
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null) {
            return myBatchAction.getInitializationTime();
        }
        return null;
    }

    private final Command createSetInitializationTimeCommand(HighResolutionCalendar newInitializationTime) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__INITIALIZATION_TIME, newInitializationTime);
    }

    public final Command setInitializationTime(HighResolutionCalendar newInitializationTime) {
        return this.createSetInitializationTimeCommand(newInitializationTime);
    }

    public final CommandWithTimeReference copyInitializationTime(HighResolutionCalendar newInitializationTime) {
        Command command = this.createSetInitializationTimeCommand(newInitializationTime);
        return new CommandWithTimeReference(command, newInitializationTime);
    }

    public final CommandWithTimeReference setIncrementedInitializationTime(HighResolutionCalendar newInitializationTime, BigInteger amount) {
        Long referenceInitializationTimeNs = newInitializationTime.getTimeInNanoseconds();
        newInitializationTime.setTimeInNanoseconds(referenceInitializationTimeNs + amount.longValue());
        Command command = this.createSetInitializationTimeCommand(newInitializationTime);
        return new CommandWithTimeReference(command, newInitializationTime);
    }

    public final Command setStartTime(HighResolutionCalendar newStartTime) {
        HighResolutionCalendar batchActionStartTime;
        BatchAction myBatchAction = (BatchAction)this.getObject();
        if (myBatchAction != null && ((batchActionStartTime = myBatchAction.getStartTime()) != newStartTime || newStartTime != null && batchActionStartTime.getTimeInNanoseconds() != newStartTime.getTimeInNanoseconds())) {
            return this.createSetStartTimeCommand(newStartTime);
        }
        return null;
    }

    public final TimedStartType getStartType() {
        BatchActionReader reader = this.getReader();
        return reader.getStartType();
    }

    private final Command createSortBlocksCommand(Batch batch) {
        return new RealTimeSortBatchActionBlocksCommand(batch);
    }

    private final Command createSetStartTimeCommand(HighResolutionCalendar newStartTime) {
        Command setCommand = this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__START_TIME, newStartTime);
        if (this.getStartType() == TimedStartType.RELATIVE) {
            return setCommand;
        }
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        compoundCommandController.appendCommand(setCommand);
        compoundCommandController.appendCommand(this.createSortBlocksCommand(this.getBatch()));
        return compoundCommandController.unwrap();
    }

    private BatchActionReader getReader() {
        return ReaderFactory.create((BatchAction)((BatchAction)this.getObject()));
    }

    private final class CommandWithScenarioReference
    extends CommandWithReference<Scenario> {
        private CommandWithScenarioReference(Command myCommand, Scenario myScenarioCommandReference) {
            super(myCommand, (Object)myScenarioCommandReference);
        }
    }

    private final class CommandWithTimeReference
    extends CommandWithReference<HighResolutionCalendar> {
        private CommandWithTimeReference(Command myCommand, HighResolutionCalendar reference) {
            super(myCommand, (Object)reference);
        }
    }
}

