/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.control.BatchActionBlockController;
import com.excentis.products.byteblower.model.control.BatchActionController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.reader.BatchActionBlockReader;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CommandWithStringReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class BatchController
extends EByteBlowerObjectController<Batch>
implements BatchReader {
    private static final String newBatchPrefix = "BATCH_";
    private BatchReader reader;

    BatchController(Batch myBatch) {
        super(myBatch);
    }

    private static final Batch create() {
        Batch newBatch = EByteBlowerObjectController.getByteblowerguimodelFactory().createBatch();
        BatchActionBlock newBlock = EByteBlowerObjectController.getByteblowerguimodelFactory().createBatchActionBlock();
        newBatch.getBatchActionBlocks().add((Object)newBlock);
        return newBatch;
    }

    protected static final Batch create(ByteBlowerProject byteblowerProject, String referenceBatchName) {
        String newBatchName;
        Batch newBatch = BatchController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newBatch, (String)(newBatchName = referenceBatchName))) {
            newBatchName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newBatch, (String)newBatchName, (String)newBatchPrefix);
        }
        newBatch.setName(newBatchName);
        return newBatch;
    }

    public boolean isContained() {
        Batch myBatch = (Batch)this.getObject();
        return myBatch != null && myBatch.eContainer() != null;
    }

    public final Object[] copyBatchActions(Collection<BatchAction> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (BatchAction object : objects) {
            BatchAction copy = (BatchAction)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        BatchAction[] array = (BatchAction[])copiedObjects.toArray((Object[])new BatchAction[objects.size()]);
        return new Object[]{array};
    }

    public final CommandWithBatchActionListReference pasteBatchActions(BatchAction[] copiedBatchActions, int pasteIndex) {
        BatchActionBlockController batchActionBlockController = this.getFirstBatchActionBlockController();
        return batchActionBlockController.pasteBatchActions(copiedBatchActions, pasteIndex);
    }

    public EList<BatchActionBlock> getBatchActionBlocks() {
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null) {
            return myBatch.getBatchActionBlocks();
        }
        return null;
    }

    private final Command createAddCommand(BatchActionBlock batchActionBlock) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH__BATCH_ACTION_BLOCKS, batchActionBlock);
    }

    private final Command createAddCommand(BatchActionBlock batchActionBlock, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH__BATCH_ACTION_BLOCKS, batchActionBlock, index);
    }

    protected final BatchActionBlockController.CommandWithBatchActionBlockReference splitAt(BatchActionBlock batchActionBlock) {
        int index;
        EList batchActionBlocks;
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null && (batchActionBlocks = myBatch.getBatchActionBlocks()) != null && (index = batchActionBlocks.indexOf((Object)batchActionBlock)) >= 0) {
            BatchActionBlock newBatchActionBlock = BatchActionBlockController.create();
            return new BatchActionBlockController.CommandWithBatchActionBlockReference(this.createAddCommand(newBatchActionBlock, index + 1), newBatchActionBlock);
        }
        return null;
    }

    protected final BatchActionBlockController.CommandWithBatchActionBlockReference splitAt(int index) {
        EList batchActionBlocks;
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null && (batchActionBlocks = myBatch.getBatchActionBlocks()) != null && index >= 0) {
            BatchActionBlock newBatchActionBlock = BatchActionBlockController.create();
            return new BatchActionBlockController.CommandWithBatchActionBlockReference(this.createAddCommand(newBatchActionBlock, index + 1), newBatchActionBlock);
        }
        return null;
    }

    public int getNumberOfBatchActions() {
        int nrOfBatchActions = 0;
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null) {
            for (BatchActionBlock batchActionBlock : myBatch.getBatchActionBlocks()) {
                EList addBatchActions = batchActionBlock.getBatchActions();
                if (addBatchActions == null) continue;
                nrOfBatchActions += addBatchActions.size();
            }
        }
        return nrOfBatchActions;
    }

    public EList<BatchAction> getBatchActions() {
        UniqueEList batchActions = new UniqueEList();
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null) {
            for (BatchActionBlock batchActionBlock : myBatch.getBatchActionBlocks()) {
                EList addBatchActions = batchActionBlock.getBatchActions();
                if (addBatchActions == null) continue;
                batchActions.addAll((Collection)addBatchActions);
            }
        }
        return batchActions;
    }

    public EList<BatchActionController> getBatchActionControllers() {
        UniqueEList batchActionControllers = new UniqueEList();
        Batch myBatch = (Batch)this.getObject();
        if (myBatch != null) {
            for (BatchActionBlock batchActionBlock : myBatch.getBatchActionBlocks()) {
                EList addBatchActions = batchActionBlock.getBatchActions();
                if (addBatchActions == null) continue;
                for (BatchAction addBatchAction : addBatchActions) {
                    batchActionControllers.add((Object)ControllerFactory.create(addBatchAction));
                }
            }
        }
        return batchActionControllers;
    }

    private LocationInBlock getBatchActionLocation(int absoluteIndex) {
        Batch myBatch = (Batch)this.getObject();
        if (myBatch == null) {
            return null;
        }
        if (absoluteIndex >= 0) {
            int batchActionIndex = absoluteIndex;
            EList batchActionBlocks = myBatch.getBatchActionBlocks();
            if (batchActionBlocks != null) {
                for (BatchActionBlock batchActionBlock : batchActionBlocks) {
                    EList checkBatchActions = batchActionBlock.getBatchActions();
                    if (checkBatchActions == null) continue;
                    if (batchActionIndex < checkBatchActions.size()) {
                        return new LocationInBlock(batchActionBlock, batchActionIndex);
                    }
                    batchActionIndex -= checkBatchActions.size();
                }
            }
        } else if (absoluteIndex == -1) {
            int batchActionBlockIndex;
            BatchActionBlock batchActionBlock;
            EList batchActionBlocks = myBatch.getBatchActionBlocks();
            if (batchActionBlocks != null && batchActionBlocks.size() > 0 && (batchActionBlock = (BatchActionBlock)batchActionBlocks.get(batchActionBlockIndex = batchActionBlocks.size() - 1)) != null) {
                EList batchActions = batchActionBlock.getBatchActions();
                int batchActionIndex = batchActions != null ? batchActions.size() : 0;
                return new LocationInBlock(batchActionBlock, batchActionIndex);
            }
            return new LocationInBlock(null, 0);
        }
        return null;
    }

    public BatchAction getBatchAction(int absoluteIndex) {
        Batch myBatch = (Batch)this.getObject();
        if (absoluteIndex < 0 || myBatch == null) {
            return null;
        }
        for (BatchActionBlock batchActionBlock : myBatch.getBatchActionBlocks()) {
            EList checkBatchActions = batchActionBlock.getBatchActions();
            if (checkBatchActions == null) continue;
            if (absoluteIndex < checkBatchActions.size()) {
                return (BatchAction)checkBatchActions.get(absoluteIndex);
            }
            absoluteIndex -= checkBatchActions.size();
        }
        return null;
    }

    public final CommandWithBatchActionListReference addBatchAction() {
        return this.addBatchActions(1);
    }

    private final CommandWithBatchActionListReference addBatchActions(int amount) {
        return this.addBatchActions(amount, -1);
    }

    public final CommandWithBatchActionListReference addBatchActions(int amount, int absoluteIndex) {
        LocationInBlock batchActionLocation = this.getBatchActionLocation(absoluteIndex);
        if (amount <= 0 || batchActionLocation == null) {
            return null;
        }
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        BatchActionBlock batchActionBlock = batchActionLocation.getBatchActionBlock();
        int relativeIndex = batchActionLocation.getIndex();
        if (batchActionBlock == null) {
            relativeIndex = -1;
            batchActionBlock = BatchActionBlockController.create();
            compoundCommandController.appendCommand(this.createAddCommand(batchActionBlock));
        }
        BatchActionBlockController batchActionBlockController = ControllerFactory.create(batchActionBlock);
        return batchActionBlockController.addBatchActions(amount, relativeIndex, compoundCommandController);
    }

    public final CommandWithBatchActionListReference addBatchActions(int amount, Object currentSelectedObject) {
        int batchActionIndex;
        BatchAction batchAction;
        BatchActionReader reader;
        Batch myBatch = (Batch)this.getObject();
        if (amount <= 0 || myBatch == null) {
            return null;
        }
        int relativeIndex = -1;
        BatchActionBlock batchActionBlock = null;
        if (currentSelectedObject instanceof BatchAction && (batchActionBlock = (reader = ReaderFactory.create((BatchAction)(batchAction = (BatchAction)currentSelectedObject))).getBatchActionBlock()) != null && (batchActionIndex = reader.getIndexInContainer()) != -1) {
            relativeIndex = batchActionIndex + 1;
        }
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        if (batchActionBlock == null) {
            EList batchActionBlocks = myBatch.getBatchActionBlocks();
            if (batchActionBlocks.size() > 0) {
                batchActionBlock = (BatchActionBlock)batchActionBlocks.get(batchActionBlocks.size() - 1);
            } else {
                batchActionBlock = BatchActionBlockController.create();
                compoundCommandController.appendCommand(this.createAddCommand(batchActionBlock));
            }
        }
        BatchActionBlockController batchActionBlockController = ControllerFactory.create(batchActionBlock);
        return batchActionBlockController.addBatchActions(amount, relativeIndex, compoundCommandController);
    }

    public final Command createSetStartTypeCommand(TimedStartType newStartType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH__START_TYPE, newStartType);
    }

    public final CommandWithStringReference setIncrementedName(Batch selectedBatch, List<String> takenNames) {
        String newName = OldNamingTools.getIncrementedName((String)selectedBatch.getName(), takenNames);
        Command newCommand = this.createSetNameCommand(newName);
        return new CommandWithStringReference(newCommand, newName);
    }

    private BatchReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((Batch)((Batch)this.getObject()));
        }
        return this.reader;
    }

    public BatchActionBlockReader getFirstBatchActionBlockReader() {
        return this.getReader().getFirstBatchActionBlockReader();
    }

    public List<BatchActionBlockReader> getBatchActionBlockReaders() {
        return this.getReader().getBatchActionBlockReaders();
    }

    public List<BatchActionReader> getBatchActionReaders() {
        return this.getReader().getBatchActionReaders();
    }

    public BatchActionBlockController getFirstBatchActionBlockController() {
        List<BatchActionBlockController> controllers = this.getBatchActionBlockControllers();
        if (controllers.isEmpty()) {
            return null;
        }
        return controllers.get(0);
    }

    public List<BatchActionBlockController> getBatchActionBlockControllers() {
        ArrayList<BatchActionBlockController> list = new ArrayList<BatchActionBlockController>();
        for (BatchActionBlock bab : this.getBatchActionBlocks()) {
            list.add(ControllerFactory.create(bab));
        }
        return list;
    }

    public boolean isAbsoluteTimed() {
        return this.getReader().isAbsoluteTimed();
    }

    public TimedStartType getStartType() {
        return this.getReader().getStartType();
    }

    @Override
    public void createStatuses() {
        List<BatchActionReader> readers = this.getBatchActionReaders();
        if (readers.isEmpty()) {
            this.addErrorStatus("Missing Scenarios");
        }
        for (BatchActionReader reader : readers) {
            if (reader.getScenario() == null) {
                this.addErrorStatus("Missing Scenarios");
                continue;
            }
            this.addDependingStatus("Scenario", (EByteBlowerObjectReader<?>)reader.getScenarioReader());
        }
    }

    public HighResolutionDuration getDuration() {
        return this.getReader().getDuration();
    }

    public static final class CommandWithBatchActionListReference
    extends CommandWithListReference<BatchActionController> {
        protected CommandWithBatchActionListReference(Command myCommand, List<BatchActionController> myBatchActionListCommandReference) {
            super(myCommand, myBatchActionListCommandReference);
        }
    }

    private class LocationInBlock {
        private final BatchActionBlock batchActionBlock;
        private final int index;

        private LocationInBlock(BatchActionBlock batchActionBlock, int index) {
            this.batchActionBlock = batchActionBlock;
            this.index = index;
        }

        private final BatchActionBlock getBatchActionBlock() {
            return this.batchActionBlock;
        }

        private final int getIndex() {
            return this.index;
        }
    }
}

