/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerServerType;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.server.PhysicalPortController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.transfer.PhysicalConfigurationTransfer;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ByteBlowerGuiPortConfigurationController
extends EByteBlowerObjectController<ByteBlowerGuiPortConfiguration>
implements ByteBlowerGuiPortConfigurationReader {
    private ByteBlowerGuiPortConfigurationReader reader = null;

    public ByteBlowerGuiPortConfigurationController(ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration) {
        super(myByteBlowerGuiPortConfiguration);
    }

    public Command dock(PhysicalDockable physicalDockable) {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration = (ByteBlowerGuiPortConfiguration)this.getObject();
        if (myByteBlowerGuiPortConfiguration != null) {
            ByteBlowerServerType newServerType;
            Integer newPortId;
            String newInterfaceId;
            String newServerAddress;
            CompoundCommand compoundCommand = new CompoundCommand();
            String oldServerAddress = myByteBlowerGuiPortConfiguration.getPhysicalServerAddress();
            String oldInterfaceId = myByteBlowerGuiPortConfiguration.getPhysicalInterfaceId();
            Integer oldPortId = myByteBlowerGuiPortConfiguration.getPhysicalPortId();
            ByteBlowerServerType oldServerType = myByteBlowerGuiPortConfiguration.getPhysicalServerType();
            if (physicalDockable instanceof PhysicalPort) {
                PhysicalPort physicalPort = (PhysicalPort)physicalDockable;
                PhysicalPortController physicalPortController = ControllerFactory.create(physicalPort);
                PhysicalInterface physicalInterface = physicalPortController.getPhysicalInterface();
                PhysicalServer physicalServer = physicalInterface.getPhysicalServer();
                newServerAddress = physicalServer.getAddress();
                newInterfaceId = physicalInterface.getId().toString();
                newPortId = physicalPort.getId();
                newServerType = ByteBlowerServerType.BYTE_BLOWER;
            } else if (physicalDockable instanceof PhysicalInterface) {
                PhysicalInterface physicalInterface = (PhysicalInterface)physicalDockable;
                PhysicalServer physicalServer = physicalInterface.getPhysicalServer();
                newServerAddress = physicalServer.getAddress();
                newInterfaceId = physicalInterface.getId().toString();
                newPortId = -1;
                newServerType = ByteBlowerServerType.BYTE_BLOWER;
            } else if (physicalDockable instanceof PhysicalMobileDevice) {
                PhysicalMobileDevice mobileDevice = (PhysicalMobileDevice)physicalDockable;
                MeetingPoint physicalServer = mobileDevice.getMeetingPoint();
                newServerAddress = physicalServer.getAddress();
                newInterfaceId = mobileDevice.getId();
                newPortId = -1;
                newServerType = ByteBlowerServerType.MEETING_POINT;
            } else {
                newServerAddress = null;
                newInterfaceId = null;
                newPortId = null;
                newServerType = null;
            }
            if (!(newServerAddress.equals(oldServerAddress) && newInterfaceId.equals(oldInterfaceId) && newPortId.equals(oldPortId) && newServerType.equals((Object)oldServerType))) {
                CompoundCommandController compoundCommandController = new CompoundCommandController(compoundCommand);
                compoundCommandController.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_SERVER_ADDRESS, newServerAddress));
                compoundCommandController.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_INTERFACE_ID, newInterfaceId));
                compoundCommandController.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_PORT_ID, newPortId));
                compoundCommandController.appendCommand(this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_SERVER_TYPE, newServerType));
            }
            return compoundCommand;
        }
        return null;
    }

    private void undock(CompoundCommandController compoundCommandController) {
        compoundCommandController.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_SERVER_ADDRESS, (Object)null));
        compoundCommandController.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_INTERFACE_ID, (Object)null));
        compoundCommandController.appendCommand(this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_PORT_ID, (Object)null));
    }

    public Command undock() {
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        this.undock(compoundCommandController);
        return compoundCommandController.getCompoundCommand();
    }

    boolean hasPhysicalConfiguration(PhysicalConfigurationTransfer physicalConfigurationTransfer) {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration;
        if (!physicalConfigurationTransfer.isEmpty() && (myByteBlowerGuiPortConfiguration = (ByteBlowerGuiPortConfiguration)this.getObject()) != null) {
            if (physicalConfigurationTransfer.hasPhysicalServerAddress() && !physicalConfigurationTransfer.getPhysicalServerAddress().equals(myByteBlowerGuiPortConfiguration.getPhysicalServerAddress())) {
                return false;
            }
            if (physicalConfigurationTransfer.hasPhysicalInterface() && !physicalConfigurationTransfer.getPhysicalInterface().equals(myByteBlowerGuiPortConfiguration.getPhysicalInterfaceId())) {
                return false;
            }
            return !physicalConfigurationTransfer.hasPhysicalPort() || physicalConfigurationTransfer.getPhysicalPort().equals(myByteBlowerGuiPortConfiguration.getPhysicalPortId());
        }
        return false;
    }

    final Command setPhysicalConfiguration(PhysicalConfigurationTransfer physicalConfigurationTransfer) {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration = (ByteBlowerGuiPortConfiguration)this.getObject();
        if (myByteBlowerGuiPortConfiguration != null && !physicalConfigurationTransfer.isEmpty()) {
            CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
            if (physicalConfigurationTransfer.hasPhysicalServerAddress()) {
                compoundCommandController.appendCommand(this.createSetPhysicalServerAddressCommand(physicalConfigurationTransfer.getPhysicalServerAddress()));
            }
            if (physicalConfigurationTransfer.hasPhysicalInterface()) {
                compoundCommandController.appendCommand(this.createSetPhysicalInterfaceIdCommand(physicalConfigurationTransfer.getPhysicalInterface()));
            }
            if (physicalConfigurationTransfer.hasPhysicalPort()) {
                compoundCommandController.appendCommand(this.createSetPhysicalPortIdCommand(physicalConfigurationTransfer.getPhysicalPort()));
            }
            return compoundCommandController.unwrap();
        }
        return null;
    }

    private final PhysicalConfigurationTransfer getCurrentPhysicalConfigurationTransfer() {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration = (ByteBlowerGuiPortConfiguration)this.getObject();
        if (myByteBlowerGuiPortConfiguration != null) {
            String myPhysicalServerAddress = myByteBlowerGuiPortConfiguration.getPhysicalServerAddress();
            String myPhysicalInterfaceId = myByteBlowerGuiPortConfiguration.getPhysicalInterfaceId();
            Integer myPhysicalPortId = myByteBlowerGuiPortConfiguration.getPhysicalPortId();
            return new PhysicalConfigurationTransfer(myPhysicalServerAddress, myPhysicalInterfaceId, myPhysicalPortId);
        }
        return null;
    }

    protected final synchronized PhysicalConfigurationTransfer getPhysicalConfigurationTransfer() {
        return this.getCurrentPhysicalConfigurationTransfer();
    }

    private EAttribute getPhysicalServerAddressEAttribute() {
        return ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_SERVER_ADDRESS;
    }

    private Command createSetPhysicalServerAddressCommand(String newPhysicalServerAddress) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getPhysicalServerAddressEAttribute(), newPhysicalServerAddress);
    }

    private EAttribute getPhysicalInterfaceIdEAttribute() {
        return ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_INTERFACE_ID;
    }

    private Command createSetPhysicalInterfaceIdCommand(String newPhysicalInterfaceId) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getPhysicalInterfaceIdEAttribute(), newPhysicalInterfaceId);
    }

    private EAttribute getPhysicalPortIdEAttribute() {
        return ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT_CONFIGURATION__PHYSICAL_PORT_ID;
    }

    private Command createSetPhysicalPortIdCommand(Integer newPhysicalPortId) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getPhysicalPortIdEAttribute(), newPhysicalPortId);
    }

    public String getPhysicalServerAddress() {
        return ((ByteBlowerGuiPortConfiguration)this.getObject()).getPhysicalServerAddress();
    }

    static ByteBlowerGuiPortConfiguration create() {
        ByteBlowerGuiPortConfiguration configuration = EByteBlowerObjectController.getByteblowerguimodelFactory().createByteBlowerGuiPortConfiguration();
        return configuration;
    }

    private ByteBlowerGuiPortConfigurationReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((ByteBlowerGuiPortConfiguration)((ByteBlowerGuiPortConfiguration)this.getObject()));
        }
        return this.reader;
    }

    public String getServerAddress() {
        return this.getReader().getServerAddress();
    }

    public String getPhysicalInterfaceId() {
        return this.getReader().getPhysicalInterfaceId();
    }

    public Integer getPhysicalPortId() {
        return this.getReader().getPhysicalPortId();
    }

    public boolean isDocked() {
        return this.getReader().isDocked();
    }

    public boolean isDockedOnPhysicalPort() {
        return this.getReader().isDockedOnPhysicalPort();
    }

    public String getText() {
        return null;
    }

    public ByteBlowerGuiPortReader getPortReader() {
        return this.getReader().getPortReader();
    }

    @Override
    public Command createSetStatusUnknownCommand() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(super.createSetStatusUnknownCommand());
        ByteBlowerGuiPortController controller = this.getByteBlowerGuiPortController();
        compound.appendCommand(controller.createSetStatusUnknownCommand());
        return compound.getCompoundCommand();
    }

    private ByteBlowerGuiPortController getByteBlowerGuiPortController() {
        ByteBlowerGuiPort byteBlowerGuiPort = ((ByteBlowerGuiPortConfiguration)this.getObject()).getByteBlowerGuiPort();
        return ControllerFactory.create(byteBlowerGuiPort);
    }

    public ByteBlowerServerType getServerType() {
        return this.getReader().getServerType();
    }

    public boolean isDockedOnMobileDevice() {
        return this.getReader().isDockedOnMobileDevice();
    }
}

