/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.reader.DhcpReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class DhcpController
extends EByteBlowerObjectController<Dhcp>
implements DhcpReader {
    private static final String newPrefix = "DHCP_";
    private DhcpReader reader;

    DhcpController(Dhcp myDhcp) {
        super(myDhcp);
    }

    private static final Dhcp create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createDhcp();
    }

    public static final Dhcp create(ByteBlowerProject byteblowerProject) {
        return DhcpController.create(byteblowerProject, null);
    }

    private static String getUniqueName(ByteBlowerProject byteblowerProject, Dhcp dhcp, String referenceDhcpName) {
        String newDhcpName = referenceDhcpName;
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)dhcp, (String)newDhcpName)) {
            newDhcpName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)dhcp, (String)newDhcpName, (String)newPrefix);
        }
        return newDhcpName;
    }

    static final Dhcp create(ByteBlowerProject byteblowerProject, String referenceDhcpName) {
        Dhcp newDhcp = DhcpController.create();
        String name = DhcpController.getUniqueName(byteblowerProject, newDhcp, referenceDhcpName);
        newDhcp.setName(name);
        return newDhcp;
    }

    public final Command setMaximumDiscoverRetries(Integer retries) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_DISCOVER_RETRIES, retries);
    }

    public final Command setInitialDiscoverTimeout(HighResolutionCalendar initialDiscoverTimeout) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_DISCOVER_TIMEOUT, initialDiscoverTimeout);
    }

    public final Command setMaximumRequestRetries(Integer maximumRequestRetries) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_REQUEST_RETRIES, maximumRequestRetries);
    }

    public final Command setInitialRequestTimeout(HighResolutionCalendar initialRequestTimeout) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_REQUEST_TIMEOUT, initialRequestTimeout);
    }

    public final Command setRetransmissionPolicy(RetransmissionPolicy retransmissionPolicy) {
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__RETRANSMISSION_POLICY, retransmissionPolicy);
    }

    public DhcpReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((Dhcp)((Dhcp)this.getObject()));
        }
        return this.reader;
    }

    public int getRequestRetries() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getMaximumRequestRetries();
    }

    public RetransmissionPolicy getRetransmissionPolicy() {
        Dhcp dhcp = (Dhcp)this.getObject();
        return dhcp.getRetransmissionPolicy();
    }

    public HighResolutionCalendar getInitialDiscoverTimeout() {
        return this.getReader().getInitialDiscoverTimeout();
    }

    public long getDiscoverTimeoutInNanos() {
        return this.getReader().getDiscoverTimeoutInNanos();
    }

    public int getMaximumDiscoverRetries() {
        return this.getReader().getMaximumDiscoverRetries();
    }

    public HighResolutionCalendar getInitialRequestTimeout() {
        return this.getReader().getInitialRequestTimeout();
    }

    public long getRequestTimeoutInNanos() {
        return this.getReader().getRequestTimeoutInNanos();
    }

    public int getMaximumRequestRetries() {
        return this.getReader().getMaximumRequestRetries();
    }

    public String getInitialDiscoverTimeoutString() {
        return this.getReader().getInitialDiscoverTimeoutString();
    }

    public String getMaximumDiscoverRetriesString() {
        return this.getReader().getMaximumDiscoverRetriesString();
    }

    public String getInitialRequestTimeoutString() {
        return this.getReader().getInitialRequestTimeoutString();
    }

    public String getMaximumRequestRetriesString() {
        return this.getReader().getMaximumRequestRetriesString();
    }

    public String getRetransmissionPolicyString() {
        return this.getReader().getRetransmissionPolicyString();
    }
}

