/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.IpAddressController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.MulticastMemberPortController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.IpAddressReader;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.MulticastMemberPortReader;
import com.excentis.products.byteblower.model.reader.MulticastSourceGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MulticastGroupController
extends EByteBlowerObjectController<MulticastGroup>
implements MulticastGroupReader {
    private static final String newMulticastGroupPrefix = "MULTICAST_";
    private MulticastGroupReader reader;

    MulticastGroupController(MulticastGroup group) {
        super(group);
    }

    public static MulticastGroupController createInstance(MulticastGroup multicastGroup) {
        return ControllerFactory.create(multicastGroup);
    }

    private static final MulticastGroup create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createMulticastGroup();
    }

    protected static final MulticastGroup create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newMulticastGroupName;
        MulticastGroup newMulticastGroup = MulticastGroupController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newMulticastGroup, (String)(newMulticastGroupName = referenceName))) {
            newMulticastGroupName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newMulticastGroup, (String)newMulticastGroupName, (String)newMulticastGroupPrefix);
        }
        newMulticastGroup.setName(newMulticastGroupName);
        Ipv4Address ipv4Address = Ipv4AddressController.create();
        Ipv4AddressController controller = ControllerFactory.create(ipv4Address);
        controller.setAddress("235.0.0.1");
        newMulticastGroup.setMulticastIpAddress((IpAddress)ipv4Address);
        return newMulticastGroup;
    }

    public final Command setMulticastIpAddress(IpAddress ipAddress) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_IP_ADDRESS, ipAddress);
    }

    public final Command setMulticastIpAddress(NetworkAddressBytes networkAddressBytes) {
        IpAddress newIpAddress;
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        IpAddressController<? extends IpAddress> ipAddressController = ControllerFactory.create(myMulticastGroup.getMulticastIpAddress());
        if (ipAddressController.isValidValue(networkAddressBytes)) {
            return ipAddressController.setAddress(networkAddressBytes);
        }
        try {
            newIpAddress = IpAddressController.createFromBytes(networkAddressBytes);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_IP_ADDRESS, newIpAddress);
    }

    protected final EList<MulticastMemberPort> getMulticastMembers() {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return myMulticastGroup.getMulticastMemberPort();
        }
        return null;
    }

    private final Command createAddCommand(MulticastMemberPort multicastMemberPort) {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_MEMBER_PORT, multicastMemberPort);
        }
        return null;
    }

    private final Command createAddCommand(Collection<MulticastMemberPort> multicastMemberPorts) {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_MEMBER_PORT, multicastMemberPorts);
        }
        return null;
    }

    private final Command createAddCommand(MulticastMemberPort multicastMemberPort, int index) {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_MEMBER_PORT, multicastMemberPort, index);
        }
        return null;
    }

    private final Command createAddCommand(Collection<MulticastMemberPort> multicastMemberPorts, int index) {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.MULTICAST_GROUP__MULTICAST_MEMBER_PORT, multicastMemberPorts, index);
        }
        return null;
    }

    public final CommandWithMulticastMemberListReference addMulticastMemberPort(ByteBlowerGuiPort guiPort) {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
        if (myMulticastGroup != null) {
            UniqueEList controllers = new UniqueEList();
            MulticastMemberPort newMember = this.createMulticastMemberPort(guiPort);
            controllers.add(ControllerFactory.create(newMember));
            compoundCommandController.appendCommand(this.createAddCommand(newMember));
            return new CommandWithMulticastMemberListReference(compoundCommandController.unwrap(), (List<MulticastMemberPortController<? extends MulticastMemberPort>>)controllers);
        }
        return null;
    }

    public MulticastMemberPort createMulticastMemberPort(ByteBlowerGuiPort guiPort) {
        MulticastMemberPort result = this.createMulticastMemberPortImpl(guiPort);
        result.setByteBlowerGuiPort(guiPort);
        return result;
    }

    private MulticastMemberPort createMulticastMemberPortImpl(ByteBlowerGuiPort guiPort) {
        if (guiPort.isSetIpv4Configuration() && guiPort.getIpv4Configuration().getIsActive().booleanValue()) {
            return ByteblowerguimodelFactoryImpl.eINSTANCE.createIpv4MulticastMemberPort();
        }
        if (guiPort.isSetIpv6Configuration() && guiPort.getIpv6Configuration().getIsActive().booleanValue()) {
            return ByteblowerguimodelFactoryImpl.eINSTANCE.createIpv6MulticastMemberPort();
        }
        throw new AssertionError((Object)"Invalid Layer3 configuration.");
    }

    private IpAddress getMulticastIpAddress() {
        MulticastGroup myMulticastGroup = (MulticastGroup)this.getObject();
        if (myMulticastGroup != null) {
            return myMulticastGroup.getMulticastIpAddress();
        }
        return null;
    }

    public String getMulticastMacAddressString() {
        IpAddress multicastIpAddress = this.getMulticastIpAddress();
        IpAddressController<? extends IpAddress> ipAddressController = ControllerFactory.create(multicastIpAddress);
        return ipAddressController.getMulticastMacAddressString();
    }

    public CommandWithMulticastMemberListReference pasteMulticastMemberPorts(MulticastMemberPort[] copiedObjects, int pastePos) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        CompoundCommand referenceSetCompound = new CompoundCommand();
        BasicEList pastedObjectControllers = new BasicEList();
        BasicEList pastedObjects = new BasicEList();
        if (copiedObjects != null) {
            MulticastMemberPort duplicate = null;
            MulticastMemberPort[] multicastMemberPortArray = copiedObjects;
            int n = copiedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                MulticastMemberPort copiedObject = multicastMemberPortArray[n2];
                if (!this.usesByteBlowerGuiPort(copiedObject.getByteBlowerGuiPort()) && (duplicate = (MulticastMemberPort)this.duplicate(referenceSetCompound, (EByteBlowerObject)copiedObject)) != null) {
                    MulticastMemberPortController<? extends MulticastMemberPort> controller = ControllerFactory.create(duplicate);
                    pastedObjects.add((Object)duplicate);
                    pastedObjectControllers.add(controller);
                }
                ++n2;
            }
            compound.appendCommand(this.createAddCommand((Collection<MulticastMemberPort>)pastedObjects, pastePos));
            compound.appendCommand((Command)referenceSetCompound);
        }
        return new CommandWithMulticastMemberListReference(compound.unwrap(), (List<MulticastMemberPortController<? extends MulticastMemberPort>>)pastedObjectControllers);
    }

    public boolean usesByteBlowerGuiPort(ByteBlowerGuiPort byteBlowerGuiPort) {
        return this.getReader().usesByteBlowerGuiPort(byteBlowerGuiPort);
    }

    private MulticastGroupReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((MulticastGroup)((MulticastGroup)this.getObject()));
        }
        return this.reader;
    }

    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        return this.getReader().getSupportedLayer3Types();
    }

    public String getMulticastIpAddressString() {
        return this.getReader().getMulticastIpAddressString();
    }

    public boolean isIpv4() {
        return this.getReader().isIpv4();
    }

    public boolean isIpv6() {
        return this.getReader().isIpv6();
    }

    public IpAddress getIpAddress() {
        return this.getReader().getIpAddress();
    }

    public Object[] copyMulticastMemberPorts(UniqueEList<MulticastMemberPort> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (MulticastMemberPort object : objects) {
            MulticastMemberPort copy = (MulticastMemberPort)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        MulticastMemberPort[] array = (MulticastMemberPort[])copiedObjects.toArray((Object[])new MulticastMemberPort[objects.size()]);
        return new Object[]{array};
    }

    public EList<MulticastMemberPort> getMulticastMemberPorts() {
        return this.getReader().getMulticastMemberPorts();
    }

    @Override
    public void createStatuses() {
        IpAddressReader<?> ipAddressReader = this.getMulticastIpAddressReader();
        String address = ipAddressReader.getAddress();
        if (ipAddressReader.isIPv4()) {
            for (String bad : UnsafeIPv4Addresses) {
                if (address.compareTo(bad) != 0) continue;
                this.addWarningStatus("IPv4 address is unsafe for Multicast groups");
            }
        } else {
            for (String bad : UnsafeIPv6Addresses) {
                if (address.compareTo(bad) != 0) continue;
                this.addWarningStatus("IPv6 address is unsafe for Multicast groups");
            }
        }
        if (!ipAddressReader.isValidMulticast()) {
            this.addErrorStatus("IP address (" + ipAddressReader.getAddress() + ") is no valid Multicast address");
        }
        if (this.getMulticastMemberPorts().isEmpty()) {
            this.addWarningStatus("Has no members");
        } else {
            for (MulticastMemberPort multicastMemberPort : this.getMulticastMemberPorts()) {
                MulticastSourceGroupReader sourceGroupReader;
                MulticastMemberPortReader memberReader = ReaderFactory.create((MulticastMemberPort)multicastMemberPort);
                ByteBlowerGuiPortReader portReader = memberReader.getByteBlowerGuiPortReader();
                this.addDependingStatus("Added ByteBlower Port", (EByteBlowerObjectReader<?>)portReader);
                if (portReader.isIPv4() != ipAddressReader.isIPv4()) {
                    if (ipAddressReader.isIPv4()) {
                        this.addErrorStatus("ByteBlower Port (" + portReader.getName() + ") cannot be used in an IPv6 Multicast Group");
                    } else {
                        this.addErrorStatus("ByteBlower Port (" + portReader.getName() + ") cannot be used in an IPv4 Multicast Group");
                    }
                }
                if (!memberReader.isSourceSpecific() || (sourceGroupReader = memberReader.getMulticastSourceGroupReader()) == null) continue;
                this.addDependingStatus("Source Group", (EByteBlowerObjectReader<?>)sourceGroupReader);
                if (this.isIpv4() && sourceGroupReader.containsIpv6()) {
                    this.addErrorStatus("Source Group (" + sourceGroupReader.getName() + ") cannot be used on an IPv4 Multicast Member Port");
                    continue;
                }
                if (!this.isIpv6() || !sourceGroupReader.containsIpv4()) continue;
                this.addErrorStatus("Source Group (" + sourceGroupReader.getName() + ") cannot be used on an IPv6 Multicast Member Port");
            }
        }
    }

    public IpAddressReader<?> getMulticastIpAddressReader() {
        return this.getReader().getMulticastIpAddressReader();
    }

    public boolean matchesLayer3(List<SupportedLayer3Configuration> supportedTypes) {
        return this.getReader().matchesLayer3(supportedTypes);
    }

    public static final class CommandWithMulticastMemberListReference
    extends CommandWithListReference<MulticastMemberPortController<? extends MulticastMemberPort>> {
        private CommandWithMulticastMemberListReference(Command myCommand, List<MulticastMemberPortController<? extends MulticastMemberPort>> myMulticastMemberListCommandReference) {
            super(myCommand, myMulticastMemberListCommandReference);
        }
    }
}

