/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.NetworkAddress;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.object.control.ByteCollectionController;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

abstract class NetworkAddressController<NetworkAddressType extends NetworkAddress>
extends EByteBlowerObjectController<NetworkAddressType> {
    public static final NetworkAddressController<? extends NetworkAddress> getInstance(NetworkAddress networkAddress) {
        if (networkAddress instanceof IpAddress) {
            return ControllerFactory.create((IpAddress)networkAddress);
        }
        if (networkAddress instanceof MacAddress) {
            return new MacAddressController((MacAddress)networkAddress);
        }
        return null;
    }

    protected NetworkAddressController(NetworkAddressType myNetworkAddress) {
        super(myNetworkAddress);
    }

    final Command setAddress(NetworkAddressBytes newAddress) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getNetworkAddressBytesAttribute(), (Collection<?>)((Object)newAddress));
    }

    public abstract void setAddress(String var1) throws NumberFormatException;

    protected final Command setAddressCommand(Collection<Byte> newBytes) {
        return this.createSetCommand((EStructuralFeature)this.getNetworkAddressBytesAttribute(), newBytes);
    }

    CommandWithNetworkAddressReference copyAddress(NetworkAddressType referenceNetworkAddress) {
        NetworkAddress copyNetworkAddress = (NetworkAddress)EByteBlowercoreUtil.copy(referenceNetworkAddress);
        Command command = this.setAddressCommand((Collection<Byte>)copyNetworkAddress.getBytes());
        return new CommandWithNetworkAddressReference(this, command, copyNetworkAddress);
    }

    public CommandWithNetworkAddressReference setIncrementedAddress(NetworkAddressType referenceNetworkAddress) {
        NetworkAddress incrementNetworkAddress = (NetworkAddress)EByteBlowercoreUtil.copy(referenceNetworkAddress);
        ByteCollectionController byteCollectionController = new ByteCollectionController((List)incrementNetworkAddress.getBytes());
        byteCollectionController.increment();
        Command command = this.setAddressCommand((Collection<Byte>)incrementNetworkAddress.getBytes());
        return new CommandWithNetworkAddressReference(this, command, incrementNetworkAddress);
    }

    public CommandWithNetworkAddressReference setDecrementedAddress(NetworkAddressType referenceNetworkAddress) {
        NetworkAddress decrementNetworkAddress = (NetworkAddress)EByteBlowercoreUtil.copy(referenceNetworkAddress);
        ByteCollectionController byteCollectionController = new ByteCollectionController((List)decrementNetworkAddress.getBytes());
        byteCollectionController.decrement();
        Command command = this.setAddressCommand((Collection<Byte>)decrementNetworkAddress.getBytes());
        return new CommandWithNetworkAddressReference(this, command, decrementNetworkAddress);
    }

    protected abstract int getNetworkAddressSize();

    private final EAttribute getNetworkAddressBytesAttribute() {
        return ByteblowerguimodelPackage.Literals.NETWORK_ADDRESS__BYTES;
    }

    protected final void setAddress(String newAddress, char separator, boolean decFormat) throws NumberFormatException {
        NetworkAddress myNetworkAddress = (NetworkAddress)this.getObject();
        if (myNetworkAddress != null) {
            ByteCollectionController byteCollectionController = new ByteCollectionController((List)myNetworkAddress.getBytes());
            byteCollectionController.fromByteString(newAddress, separator, decFormat, this.getNetworkAddressSize());
        }
    }

    protected final void setAddress(String newAddress, char separator) throws NumberFormatException {
        this.setAddress(newAddress, separator, false);
    }

    protected static final String unifyNetworkAddress(String networkAddress, CharSequence charSequence, char c) {
        String unifiedNetworkAddress = networkAddress;
        int numberOfAllowedMacAddressSeparators = charSequence.length();
        int charIndex = 0;
        while (charIndex < numberOfAllowedMacAddressSeparators) {
            unifiedNetworkAddress = unifiedNetworkAddress.replace(charSequence.charAt(charIndex), c);
            ++charIndex;
        }
        return unifiedNetworkAddress;
    }

    public static final class CommandWithNetworkAddressReference
    extends CommandWithReference<NetworkAddressType> {
        final /* synthetic */ NetworkAddressController this$0;

        protected CommandWithNetworkAddressReference(Command myCommand, NetworkAddressType myNetworkAddressCommandReference) {
            this.this$0 = var1_1;
            super(myCommand, myNetworkAddressCommandReference);
        }
    }
}

