/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.PortForwardingProtocol;
import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.reader.PortMappingReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class PortMappingController
extends EByteBlowerObjectController<PortMapping>
implements PortMappingReader {
    private static final String newPortMappingPrefix = "PortMapping_";
    private PortMappingReader reader;

    PortMappingController(PortMapping myPortMapping) {
        super(myPortMapping);
    }

    static final PortMapping create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createPortMapping();
    }

    protected static final PortMapping create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newName;
        PortMapping newPortMapping = PortMappingController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newPortMapping, (String)(newName = referenceName))) {
            newName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newPortMapping, (String)newName, (String)newPortMappingPrefix);
        }
        newPortMapping.setName(newName);
        return newPortMapping;
    }

    public boolean isContained() {
        PortMapping myPortMapping = (PortMapping)this.getObject();
        return myPortMapping != null && myPortMapping.eContainer() != null;
    }

    public final Object[] copyPortMapping(Collection<PortMapping> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (PortMapping object : objects) {
            PortMapping copy = (PortMapping)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        PortMapping[] array = (PortMapping[])copiedObjects.toArray((Object[])new PortMapping[objects.size()]);
        return new Object[]{array};
    }

    private final Command createAddCommand(PortMapping portMappings) {
        PortMapping myPortMapping = (PortMapping)this.getObject();
        if (myPortMapping != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMappings);
        }
        return null;
    }

    private final Command createAddCommand(Collection<PortMapping> portMappings) {
        PortMapping myPortMapping = (PortMapping)this.getObject();
        if (myPortMapping != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_FORWARDING__PORT_MAPPINGS, portMappings);
        }
        return null;
    }

    private PortMappingReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PortMapping)((PortMapping)this.getObject()));
        }
        return this.reader;
    }

    public String getPrivatePortString() {
        return this.getReader().getPrivatePortString();
    }

    public String getPublicPortString() {
        return this.getReader().getPublicPortString();
    }

    public String getProtocolString() {
        return this.getReader().getProtocolString();
    }

    public Command setProtocol(PortForwardingProtocol protocol) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_MAPPING__PROTOCOL, protocol);
    }

    public Command setPrivatePort(Integer port) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_MAPPING__PRIVATE_PORT, port);
    }

    public Command setPublicPort(Integer port) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.PORT_MAPPING__PUBLIC_PORT, port);
    }

    public Integer getPrivatePort() {
        return this.getReader().getPrivatePort();
    }

    public Integer getPublicPort() {
        return this.getReader().getPublicPort();
    }

    public boolean isPrivatePortOverlapping() {
        return this.getReader().isPrivatePortOverlapping();
    }

    public boolean isPublicPortOverlapping() {
        return this.getReader().isPublicPortOverlapping();
    }

    public boolean isPortOverlapping() {
        return this.getReader().isPortOverlapping();
    }

    public PortForwardingProtocol getProtocol() {
        return this.getReader().getProtocol();
    }
}

