/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.MobileDeviceController;
import com.excentis.products.byteblower.model.control.server.PhysicalConfigurationController;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.MeetingPointReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.model.transfer.PhysicalConfigurationTransfer;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.MobileType;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Version;

public final class MeetingPointController
extends AbstractServerController<MeetingPoint>
implements MeetingPointReader {
    private MeetingPointReader reader = null;

    public MeetingPointController(MeetingPoint myMeetingPoint) {
        super(myMeetingPoint);
    }

    private MeetingPointReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((MeetingPoint)((MeetingPoint)this.getObject()));
        }
        return this.reader;
    }

    private static MeetingPoint createEmptyMeetingPoint() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createMeetingPoint();
    }

    public static MeetingPoint create() {
        MeetingPoint MeetingPoint2 = MeetingPointController.createEmptyMeetingPoint();
        return MeetingPoint2;
    }

    public PhysicalConfigurationController getPhysicalConfigurationController() {
        MeetingPoint myMeetingPoint = (MeetingPoint)this.getObject();
        if (myMeetingPoint != null) {
            return new PhysicalConfigurationController(myMeetingPoint.getPhysicalConfiguration());
        }
        return null;
    }

    @Override
    public String getLocalName() {
        MeetingPoint myMeetingPoint = (MeetingPoint)this.getObject();
        if (myMeetingPoint != null) {
            return myMeetingPoint.getLocalName();
        }
        return null;
    }

    public String getAddress() {
        MeetingPoint myMeetingPoint = (MeetingPoint)this.getObject();
        if (myMeetingPoint != null) {
            return myMeetingPoint.getAddress();
        }
        return null;
    }

    public final PhysicalConfigurationTransfer getPhysicalConfigurationTransfer() {
        MeetingPoint myMeetingPoint = (MeetingPoint)this.getObject();
        if (myMeetingPoint != null) {
            String myAddress = myMeetingPoint.getAddress();
            return new PhysicalConfigurationTransfer(myAddress, null, null);
        }
        return null;
    }

    public static final boolean allowOverridePortState(ServerLinkStatus pendingServerStatus) {
        return pendingServerStatus == ServerLinkStatus.ONLINE;
    }

    @Override
    public void setCurrentUsers(List<String> newCurrentUsers) {
        MeetingPoint myMeetingPoint = (MeetingPoint)this.getObject();
        if (myMeetingPoint != null) {
            myMeetingPoint.setCurrentUsers((EList)new BasicEList(newCurrentUsers));
        }
    }

    @Override
    public Version getLatestVersion() {
        return null;
    }

    @Override
    public Command selfDestroy() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.undock());
        compound.appendCommand(this.delete());
        return compound.getCompoundCommand();
    }

    public List<MobileDeviceController> getMobileDeviceControllers() {
        EList<PhysicalMobileDevice> devices = this.getMobileDevices();
        if (devices != null) {
            ArrayList<MobileDeviceController> controllers = new ArrayList<MobileDeviceController>(devices.size());
            for (PhysicalMobileDevice device : devices) {
                controllers.add(ControllerFactory.create(device));
            }
            return controllers;
        }
        return null;
    }

    public EList<PhysicalMobileDevice> getMobileDevices() {
        return this.getReader().getMobileDevices();
    }

    public PhysicalConfigurationController.CommandWithMobileDeviceReference createAddMobileDeviceCommand(String id) {
        PhysicalMobileDevice newDevice = MobileDeviceController.create();
        newDevice.setId(id);
        newDevice.setMobileType(MobileType.UNKNOWN);
        Command addCommand = this.createAddCommand(newDevice);
        MobileDeviceController controller = ControllerFactory.create(newDevice);
        return new PhysicalConfigurationController.CommandWithMobileDeviceReference(addCommand, controller);
    }

    private Command createAddCommand(PhysicalMobileDevice newDevice) {
        return this.createAddCommand(this.getPhysicalMobileDeviceEReference(), newDevice);
    }

    private EStructuralFeature getPhysicalMobileDeviceEReference() {
        return ByteBlowerServerModelPackage.Literals.MEETING_POINT__MOBILE_DEVICES;
    }

    public MobileDeviceController getMobileDeviceController(String id) {
        PhysicalMobileDevice found = null;
        for (PhysicalMobileDevice device : this.getMobileDevices()) {
            if (!device.getId().equals(id)) continue;
            found = device;
        }
        if (found != null) {
            return ControllerFactory.create(found);
        }
        return null;
    }

    public List<MobileDeviceReader> getMobileDeviceReaders() {
        return this.getReader().getMobileDeviceReaders();
    }

    public Command deleteMobileDevice(PhysicalMobileDevice device) {
        return this.createRemoveCommand(this.getPhysicalMobileDeviceEReference(), (EByteBlowerServerObject)device);
    }

    @Override
    public Command setLinkStatusUnknown() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.setServerLinkStatus(ServerLinkStatus.UNKNOWN));
        for (MobileDeviceController mobileDeviceController : this.getMobileDeviceControllers()) {
        }
        return compound.getCompoundCommand();
    }

    @Override
    public Command undock() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (MobileDeviceController controller : this.getMobileDeviceControllers()) {
            compound.appendCommand(controller.undock());
        }
        return compound.getCompoundCommand();
    }
}

