/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.MeetingPointController;
import com.excentis.products.byteblower.model.control.server.MobileDeviceController;
import com.excentis.products.byteblower.model.control.server.PhysicalServerController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.object.control.CommandWithReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import com.excentis.products.byteblower.server.model.ServerRelease;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class PhysicalConfigurationController
extends EByteBlowerServerObjectController<PhysicalConfiguration>
implements PhysicalConfigurationReader {
    private PhysicalConfigurationReader reader = null;

    public PhysicalConfigurationController(PhysicalConfiguration physicalConfiguration) {
        super(physicalConfiguration);
    }

    private PhysicalConfigurationReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PhysicalConfiguration)((PhysicalConfiguration)this.getObject()));
        }
        return this.reader;
    }

    private static PhysicalConfiguration createEmptyPhysicalConfiguration() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalConfiguration();
    }

    public static PhysicalConfiguration create() {
        PhysicalConfiguration physicalConfiguration = PhysicalConfigurationController.createEmptyPhysicalConfiguration();
        return physicalConfiguration;
    }

    public final Command addRelease(String serverType, String version) {
        ServerRelease release = EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createServerRelease();
        release.setServerSeries(serverType);
        release.setVersion(version);
        return AddCommand.create((EditingDomain)editingDomain, this.getObject(), (Object)ByteBlowerServerModelPackage.Literals.PHYSICAL_CONFIGURATION__LATEST_RELEASES, (Object)release);
    }

    private final EReference getPhysicalServerEReference() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_CONFIGURATION__PHYSICAL_SERVER;
    }

    private final Command createAddCommand(PhysicalServer physicalServer) {
        PhysicalConfiguration myPhysicalConfiguration = (PhysicalConfiguration)this.getObject();
        if (myPhysicalConfiguration != null) {
            return AddCommand.create((EditingDomain)editingDomain, (Object)myPhysicalConfiguration, (Object)this.getPhysicalServerEReference(), (Object)physicalServer);
        }
        return null;
    }

    private final EReference getMeetingPointEReference() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_CONFIGURATION__MEETING_POINTS;
    }

    private final Command createAddCommand(MeetingPoint MeetingPoint2) {
        PhysicalConfiguration myPhysicalConfiguration = (PhysicalConfiguration)this.getObject();
        if (myPhysicalConfiguration != null) {
            return AddCommand.create((EditingDomain)editingDomain, (Object)myPhysicalConfiguration, (Object)this.getMeetingPointEReference(), (Object)MeetingPoint2);
        }
        return null;
    }

    public final CommandWithPhysicalServerReference addPhysicalServer() {
        PhysicalConfiguration myPhysicalConfiguration = (PhysicalConfiguration)this.getObject();
        if (myPhysicalConfiguration != null) {
            PhysicalServer newPhysicalServer = PhysicalServerController.create();
            return new CommandWithPhysicalServerReference(this.createAddCommand(newPhysicalServer), ControllerFactory.create(newPhysicalServer));
        }
        return null;
    }

    public final CommandWithMeetingPointReference addMeetingPoint() {
        PhysicalConfiguration myPhysicalConfiguration = (PhysicalConfiguration)this.getObject();
        if (myPhysicalConfiguration != null) {
            MeetingPoint newMeetingPoint = MeetingPointController.create();
            return new CommandWithMeetingPointReference(this.createAddCommand(newMeetingPoint), ControllerFactory.create(newMeetingPoint));
        }
        return null;
    }

    public final CommandWithPhysicalServerReference addPhysicalServer(AbstractServer server) {
        PhysicalConfiguration physicalConfiguration = (PhysicalConfiguration)this.getObject();
        if (physicalConfiguration != null) {
            PhysicalServer physicalServer = PhysicalServerController.create();
            physicalServer.setAddress(server.getAddress());
            physicalServer.setLocalName(server.getLocalName());
            physicalServer.setName(server.getName());
            physicalServer.setServerLinkStatus(ServerLinkStatus.UNKNOWN);
            Command addCommand = this.createAddCommand(physicalServer);
            return new CommandWithPhysicalServerReference(addCommand, ControllerFactory.create(physicalServer));
        }
        return null;
    }

    public EList<AbstractServer> getAbstractServers(String serverAddress) {
        return this.getReader().getAbstractServers(serverAddress);
    }

    public AbstractServerController<?> getServerByHostName(String physicalServerHostName) {
        AbstractServer server = this.getPhysicalServerByHostName(physicalServerHostName);
        if (server != null) {
            return ControllerFactory.create(server);
        }
        return null;
    }

    private AbstractServer getPhysicalServerByHostName(String physicalServerHostName) {
        EList<AbstractServer> servers;
        if (physicalServerHostName != null && (servers = this.getAllServers()) != null) {
            for (AbstractServer physicalServer : servers) {
                if (!physicalServerHostName.equals(physicalServer.getHostName())) continue;
                return physicalServer;
            }
        }
        return null;
    }

    public boolean meetingPointWithAddressExists(String serverAddress) {
        return this.getMeetingPoint(serverAddress) != null;
    }

    public List<AbstractServerController<?>> getPhysicalServerControllers() {
        return this.getServerControllers(null);
    }

    public List<AbstractServerController<?>> getServerControllers(List<String> serverAddresses) {
        Object allServers = this.getAllServers();
        if (allServers != null) {
            allServers = Collections.emptyList();
        }
        ArrayList serverControllers = new ArrayList();
        Iterator iterator = allServers.iterator();
        while (iterator.hasNext()) {
            AbstractServer server = (AbstractServer)iterator.next();
            if (serverAddresses != null && !serverAddresses.contains(server.getAddress())) continue;
            serverControllers.add(ControllerFactory.create(server));
        }
        return serverControllers;
    }

    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortReader portReader) {
        return this.getReader().getPhysicalDockable(portReader);
    }

    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return this.getReader().getPhysicalDockable(portConfigReader);
    }

    public List<AbstractServerReader<?>> getAllServerReaders() {
        return this.getReader().getAllServerReaders();
    }

    public EList<AbstractServer> getAllServers() {
        return this.getReader().getAllServers();
    }

    public EList<MeetingPoint> getMeetingPoints() {
        return this.getReader().getMeetingPoints();
    }

    public AbstractServerReader<?> getServerReader(String serverAddress) {
        return this.getReader().getServerReader(serverAddress);
    }

    public List<String> getServerAddresses() {
        return this.getReader().getServerAddresses();
    }

    public List<AbstractServerReader<?>> getUsedServerReaders(ByteBlowerProjectReader projectReader) {
        return this.getReader().getUsedServerReaders(projectReader);
    }

    public PhysicalServerController getPhysicalServerController(String serverAddress) {
        PhysicalServer server = this.getPhysicalServer(serverAddress);
        if (server == null) {
            return null;
        }
        return ControllerFactory.create(server);
    }

    public MeetingPointController getMeetingPointController(String serverAddress) {
        MeetingPoint server = this.getMeetingPoint(serverAddress);
        if (server == null) {
            return null;
        }
        return ControllerFactory.create(server);
    }

    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortReader reader) {
        return this.getReader().getDockedPort(reader);
    }

    public PhysicalDockableReader<?> getPhysicalDockableReader(ByteBlowerGuiPortReader reader) {
        return this.getReader().getPhysicalDockableReader(reader);
    }

    public EList<DockedByteBlowerPort> getDockedPorts(List<ByteBlowerGuiPortReader> portReaders) {
        return this.getReader().getDockedPorts(portReaders);
    }

    public CompoundCommand clear() {
        List<DockedByteBlowerPortReader> readers = this.getAllDockedPortReaders();
        return this.delete(readers);
    }

    public CompoundCommand clearReleases() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(RemoveCommand.create((EditingDomain)editingDomain, this.getObject(), (Object)ByteBlowerServerModelPackage.Literals.PHYSICAL_CONFIGURATION__LATEST_RELEASES, (Collection)((PhysicalConfiguration)this.getObject()).getLatestReleases()));
        return compound.getCompoundCommand();
    }

    private CompoundCommand delete(List<DockedByteBlowerPortReader> readers) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (DockedByteBlowerPortReader reader : readers) {
            DockedByteBlowerPort object = (DockedByteBlowerPort)reader.getObject();
            DockedByteBlowerPortController controller = ControllerFactory.create(object);
            compound.appendCommand(controller.delete());
        }
        return compound.getCompoundCommand();
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public EList<PhysicalServer> getPhysicalServers() {
        return this.getReader().getPhysicalServers();
    }

    public MeetingPoint getMeetingPoint(String serverAddress) {
        return this.getReader().getMeetingPoint(serverAddress);
    }

    public PhysicalServer getPhysicalServer(String serverAddress) {
        return this.getReader().getPhysicalServer(serverAddress);
    }

    public static final class CommandWithMeetingPointReference
    extends CommandWithReference<MeetingPointController> {
        private CommandWithMeetingPointReference(Command myCommand, MeetingPointController myMeetingPointListReference) {
            super(myCommand, (Object)myMeetingPointListReference);
        }
    }

    public static final class CommandWithMobileDeviceReference
    extends CommandWithReference<MobileDeviceController> {
        protected CommandWithMobileDeviceReference(Command myCommand, MobileDeviceController controller) {
            super(myCommand, (Object)controller);
        }
    }

    public static final class CommandWithPhysicalServerReference
    extends CommandWithReference<PhysicalServerController> {
        private CommandWithPhysicalServerReference(Command myCommand, PhysicalServerController myPhysicalServerListReference) {
            super(myCommand, (Object)myPhysicalServerListReference);
        }
    }
}

