/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.DockedPortAdapter;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.CapabilityReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelFactory;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.Capability;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class PhysicalDockableController<PhysicalDockableType extends PhysicalDockable>
extends EByteBlowerServerObjectController<PhysicalDockableType>
implements PhysicalDockableReader<PhysicalDockableType> {
    private final PhysicalDockableReader<?> reader = ReaderFactory.create((PhysicalDockable)((PhysicalDockable)this.getObject()));

    PhysicalDockableController(PhysicalDockableType myPhysicalDockable) {
        super(myPhysicalDockable);
    }

    public Command dock(ByteBlowerGuiPortConfiguration portConfig) {
        DockedByteBlowerPort dockedByteBlowerPort = ByteBlowerServerModelFactory.eINSTANCE.createDockedByteBlowerPort();
        dockedByteBlowerPort.setDockedConfiguration(portConfig);
        DockedPortAdapter.create(dockedByteBlowerPort, portConfig);
        return this.createAddCommand((EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_DOCKABLE__DOCKED_PORTS, dockedByteBlowerPort);
    }

    public Command undock(ByteBlowerGuiPortConfiguration portConfig) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        DockedByteBlowerPort currentlyDockedPort = this.getDockedPort(portConfig);
        System.out.println(currentlyDockedPort);
        compound.appendCommand(PhysicalDockableController.createDeleteCommand((EByteBlowerServerObject)currentlyDockedPort));
        ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
        compound.appendCommand(controller.undock());
        return compound.getCompoundCommand();
    }

    public List<DockedByteBlowerPortReader> getDockedPortReaders() {
        return this.reader.getDockedPortReaders();
    }

    public List<DockedByteBlowerPortController> getAllDockedPortControllers() {
        ArrayList<DockedByteBlowerPortController> controllers = new ArrayList<DockedByteBlowerPortController>();
        EList dockedPorts = this.getAllDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            controllers.add(ControllerFactory.create(dockedPort));
        }
        return controllers;
    }

    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortConfiguration portConfig) {
        return this.reader.getDockedPort(portConfig);
    }

    public DockedByteBlowerPort getDockedPort(ByteBlowerGuiPortReader port) {
        return this.reader.getDockedPort(port);
    }

    public String getInterfaceString() {
        return this.reader.getInterfaceString();
    }

    public int getRemainingCapacity() {
        return this.reader.getRemainingCapacity();
    }

    public List<CapabilityReader> getCapabilities() {
        return this.reader.getCapabilities();
    }

    public Command removeAllCapabilities() {
        EList currentCapabilities = ((PhysicalDockable)this.getObject()).getCapabilities();
        if (!currentCapabilities.isEmpty()) {
            return this.createRemoveCommand((EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_DOCKABLE__CAPABILITIES, (Collection<EByteBlowerServerObject>)currentCapabilities);
        }
        return this.createEmptyCommand();
    }

    public Command addCapability(Capability cap) {
        return this.createAddCommand((EStructuralFeature)ByteBlowerServerModelPackage.Literals.PHYSICAL_DOCKABLE__CAPABILITIES, cap);
    }

    public boolean hasCapability(CapabilityReader.TYPE capability) {
        return this.reader.hasCapability(capability);
    }

    public boolean needsRefresh() {
        return this.reader.needsRefresh();
    }
}

