/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.PhysicalDockableController;
import com.excentis.products.byteblower.model.control.server.PhysicalPortController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.InterfaceType;
import com.excentis.products.byteblower.server.model.LinkType;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PortLinkStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PhysicalInterfaceController
extends PhysicalDockableController<PhysicalInterface>
implements PhysicalInterfaceReader {
    private PhysicalInterfaceReader reader = null;

    private PhysicalInterfaceReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PhysicalInterface)((PhysicalInterface)this.getObject()));
        }
        return this.reader;
    }

    public PhysicalInterfaceController(PhysicalInterface myPhysicalInterface) {
        super(myPhysicalInterface);
    }

    private static PhysicalInterface createEmptyPhysicalInterface() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalInterface();
    }

    public static PhysicalInterface create() {
        PhysicalInterface physicalInterface = PhysicalInterfaceController.createEmptyPhysicalInterface();
        return physicalInterface;
    }

    public final Command setId(String newId) {
        return this.createSetIdCommand(newId);
    }

    protected final Command setVendor(String newVendor) {
        return this.createSetVendorCommand(newVendor);
    }

    protected final Command setProduct(String newProduct) {
        return this.createSetProductCommand(newProduct);
    }

    public Command setMacAddress(String mac) {
        return this.createSetMacAddressCommand(mac);
    }

    private Command createSetMacAddressCommand(String mac) {
        return this.checkAndCreateSetCommand(this.getMacAddressEAttribute(), mac);
    }

    public Command setProductName(String productName) {
        return this.createSetProductNameCommand(productName);
    }

    private Command createSetProductNameCommand(String productName) {
        return this.checkAndCreateSetCommand(this.getProductNameEAttribute(), productName);
    }

    private EStructuralFeature getProductNameEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__PRODUCT;
    }

    public Command setVendorName(String vendorName) {
        return this.createSetVendorNameCommand(vendorName);
    }

    private Command createSetVendorNameCommand(String vendorName) {
        return this.checkAndCreateSetCommand(this.getVendorNameEAttribute(), vendorName);
    }

    private EStructuralFeature getVendorNameEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__VENDOR;
    }

    public final void updateNow() {
        PhysicalInterface myPhysicalInterface = (PhysicalInterface)this.getObject();
        if (myPhysicalInterface != null) {
            myPhysicalInterface.setNeedsUpdate(1);
        }
    }

    public InterfaceType getInterfaceType() {
        PhysicalInterface myPhysicalInterface = (PhysicalInterface)this.getObject();
        if (myPhysicalInterface != null) {
            return myPhysicalInterface.getInterfaceType();
        }
        return null;
    }

    public final Command setInterfaceType(InterfaceType newInterfaceType) {
        return this.createSetInterfaceTypeCommand(newInterfaceType);
    }

    public Command setInterfaceLinkStatus(InterfaceLinkStatus linkStatus) {
        return this.createSetLinkStatusCommand(linkStatus);
    }

    private Command createSetLinkStatusCommand(InterfaceLinkStatus linkStatus) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getLinkStatusEAttribute(), linkStatus);
    }

    private EAttribute getLinkStatusEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__INTERFACE_LINK_STATUS;
    }

    public Command setLinkType(LinkType linkType) {
        return this.createSetLinkTypeCommand(linkType);
    }

    private Command createSetLinkTypeCommand(LinkType linkType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getLinkTypeEAttribute(), linkType);
    }

    private EAttribute getLinkTypeEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__LINK_TYPE;
    }

    private EStructuralFeature getMacAddressEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__MAC_ADDRESS;
    }

    public List<PhysicalPortController> getPhysicalPortControllers() {
        EList<PhysicalPort> myPhysicalPorts = this.getPhysicalPorts();
        if (myPhysicalPorts != null) {
            ArrayList<PhysicalPortController> physicalPortControllers = new ArrayList<PhysicalPortController>(myPhysicalPorts.size());
            for (PhysicalPort physicalPort : myPhysicalPorts) {
                physicalPortControllers.add(new PhysicalPortController(physicalPort));
            }
            return physicalPortControllers;
        }
        return null;
    }

    private final PhysicalPort getPhysicalPort(Integer physicalPortId) {
        EList<PhysicalPort> myPhysicalPorts = this.getPhysicalPorts();
        if (myPhysicalPorts != null) {
            for (PhysicalPort port : myPhysicalPorts) {
                if (port.getId() != physicalPortId) continue;
                return port;
            }
        }
        return null;
    }

    public final PhysicalPortController getPhysicalPortController(Integer physicalPortId) {
        PhysicalPort physicalPort = this.getPhysicalPort(physicalPortId);
        if (physicalPort != null) {
            return new PhysicalPortController(physicalPort);
        }
        return null;
    }

    private EAttribute getIdEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__ID;
    }

    private Command createSetIdCommand(String newId) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getIdEAttribute(), newId);
    }

    private EAttribute getInterfaceTypeEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__INTERFACE_TYPE;
    }

    private Command createSetInterfaceTypeCommand(InterfaceType newInterfaceType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getInterfaceTypeEAttribute(), newInterfaceType);
    }

    private EAttribute getVendorEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__VENDOR;
    }

    private Command createSetVendorCommand(String newVendor) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getVendorEAttribute(), newVendor);
    }

    private EAttribute getProductEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__PRODUCT;
    }

    private Command createSetProductCommand(String newProduct) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getProductEAttribute(), newProduct);
    }

    private EReference getPhysicalPortEReference() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_INTERFACE__PHYSICAL_PORT;
    }

    public final Command createAddCommand(PhysicalPort physicalPort) {
        return this.createAddCommand((EStructuralFeature)this.getPhysicalPortEReference(), physicalPort);
    }

    public final Command createAddCommand(PhysicalPort physicalPort, int index) {
        return this.createAddCommand((EStructuralFeature)this.getPhysicalPortEReference(), physicalPort, index);
    }

    public final Command createAddCommand(EList<PhysicalPort> physicalPorts, int index) {
        return this.createAddCommand((EStructuralFeature)this.getPhysicalPortEReference(), (Collection<?>)physicalPorts, index);
    }

    public PhysicalDockable getPhysicalDockable() {
        return (PhysicalDockable)this.getObject();
    }

    public EList<ByteBlowerGuiPortConfiguration> getDockedPortConfigurations() {
        return this.getReader().getDockedPortConfigurations();
    }

    public String getInterfaceId() {
        return this.getReader().getInterfaceId();
    }

    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return this.getReader().getPhysicalDockable(portConfigReader);
    }

    public List<PhysicalPortReader> getPhysicalPortReaders() {
        return this.getReader().getPhysicalPortReaders();
    }

    public EList<PhysicalPort> getPhysicalPorts() {
        return this.getReader().getPhysicalPorts();
    }

    public AbstractServer getServer() {
        return this.getReader().getServer();
    }

    public PhysicalServerReader getPhysicalServerReader() {
        return this.getReader().getPhysicalServerReader();
    }

    public PhysicalPortReader getPhysicalPortReader(Integer portId) {
        return this.getReader().getPhysicalPortReader(portId);
    }

    public String getMacAddressString() {
        return this.getReader().getMacAddressString();
    }

    public InterfaceLinkStatus getInterfaceLinkStatus() {
        return this.getReader().getInterfaceLinkStatus();
    }

    public int getNofPhysicalPorts() {
        return this.getReader().getNofPhysicalPorts();
    }

    private CommandWithPhysicalPortListReference addPhysicalPort(int portId, int index) {
        PhysicalPort physicalPort = PhysicalPortController.create(portId);
        physicalPort.setPortLinkStatus(PortLinkStatus.ONLINE);
        Command addCommand = this.createAddCommand(physicalPort, index);
        PhysicalPortController controller = ControllerFactory.create(physicalPort);
        UniqueEList controllers = new UniqueEList();
        controllers.add((Object)controller);
        return new CommandWithPhysicalPortListReference(addCommand, (List<PhysicalPortController>)controllers);
    }

    public CommandWithPhysicalPortListReference addPhysicalPort(int portId) {
        return this.addPhysicalPort(portId, -1);
    }

    public Command deletePhysicalPort(PhysicalPort physicalPort) {
        return this.createRemoveCommand((EStructuralFeature)this.getPhysicalPortEReference(), (EByteBlowerServerObject)physicalPort);
    }

    public EList<DockedByteBlowerPort> getDockedPorts() {
        return this.getReader().getDockedPorts();
    }

    public Command undock() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
            compound.appendCommand(controller.undock());
            compound.appendCommand(this.undock(portConfig));
        }
        for (PhysicalPortController portController : this.getPhysicalPortControllers()) {
            compound.appendCommand(portController.undock());
        }
        return compound.getCompoundCommand();
    }

    Command setLinkStatusUnknown() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.setInterfaceLinkStatus(InterfaceLinkStatus.UNKNOWN));
        for (PhysicalPortController controller : this.getPhysicalPortControllers()) {
            compound.appendCommand(controller.setPortLinkStatus(PortLinkStatus.UNKNOWN));
        }
        return compound.getCompoundCommand();
    }

    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        return this.getReader().getAllDockedPorts();
    }

    @Override
    public List<DockedByteBlowerPortController> getAllDockedPortControllers() {
        ArrayList<DockedByteBlowerPortController> controllers = new ArrayList<DockedByteBlowerPortController>();
        EList<DockedByteBlowerPort> dockedPorts = this.getAllDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            controllers.add(ControllerFactory.create(dockedPort));
        }
        return controllers;
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public EList<ByteBlowerGuiPortConfiguration> getAllDockedPortConfigurations() {
        return this.getReader().getAllDockedPortConfigurations();
    }

    public Command deleteAllPhysicalPorts() {
        return this.createRemoveCommand((EStructuralFeature)this.getPhysicalPortEReference(), (Collection<? extends EByteBlowerServerObject>)this.getPhysicalPorts());
    }

    public int getInterfaceNumber() {
        return this.getReader().getInterfaceNumber();
    }

    public String getDetailedInterfaceString() {
        return this.getReader().getDetailedInterfaceString();
    }

    Command refreshPorts() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
            compound.appendCommand(controller.createSetStatusUnknownCommand());
        }
        for (PhysicalPortController controller : this.getPhysicalPortControllers()) {
            compound.appendCommand(controller.refreshPorts());
        }
        return compound.getCompoundCommand();
    }

    public boolean isNonTrunking() {
        return this.getReader().isNonTrunking();
    }

    private static final class CommandWithPhysicalPortListReference
    extends CommandWithListReference<PhysicalPortController> {
        private CommandWithPhysicalPortListReference(Command myCommand, List<PhysicalPortController> myPhysicalPortReference) {
            super(myCommand, myPhysicalPortReference);
        }
    }
}

