/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.edit.util.storage;

import com.excentis.products.byteblower.model.edit.util.storage.EReferenceStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class EReferenceStorageHelper {
    private final EObject eObject;
    private final EReferenceStorage eReferenceStorage;

    protected EReferenceStorageHelper(EObject eObject, EReferenceStorage eReferenceStorage) {
        this.eObject = eObject;
        this.eReferenceStorage = eReferenceStorage;
    }

    EReferenceStorageHelper(EObject eObject, EObject affectedEObject) {
        this(eObject, new EReferenceStorage(affectedEObject));
    }

    public final EObject getEObject() {
        return this.eObject;
    }

    protected final EReferenceStorage getEReferenceStorage() {
        return this.eReferenceStorage;
    }

    public final EObject getAffectedEObject() {
        return this.eReferenceStorage != null ? this.eReferenceStorage.getEObject() : null;
    }

    public final Collection<EReference> getAllEReferences() {
        Map<EReference, Object> eReferenceMap = this.getEReferenceMap();
        return eReferenceMap != null ? eReferenceMap.keySet() : null;
    }

    public final Object getReferencedObject(EReference eReference) {
        return this.getStoredReferencedObject(eReference);
    }

    public final void setReferencedObject(EReference eReference, Object newReferencedObject) {
        this.storeReferencedObject(eReference, newReferencedObject);
    }

    public final void addReferencedObject(EReference eReference, Object referencedObject) {
        Collection<Object> referencedCollection = this.initializeReferencedCollection(eReference);
        referencedCollection.add(referencedObject);
        this.storeReferencedCollection(eReference, referencedCollection);
    }

    private final Map<EReference, Object> getEReferenceMap() {
        return this.eReferenceStorage != null ? this.eReferenceStorage.getEReferenceMap() : null;
    }

    private final Object getStoredReferencedObject(EReference eReference) {
        Map<EReference, Object> eReferenceMap = this.getEReferenceMap();
        return eReferenceMap != null ? eReferenceMap.get(eReference) : null;
    }

    private final Collection<Object> initializeReferencedCollection(EReference eReference) {
        ArrayList<Object> newCollection;
        Object currentReferencedObject = this.getStoredReferencedObject(eReference);
        if (currentReferencedObject == null) {
            newCollection = new ArrayList<Object>();
        } else if (currentReferencedObject instanceof Collection) {
            newCollection = new ArrayList((Collection)currentReferencedObject);
        } else {
            newCollection = new ArrayList();
            newCollection.add(currentReferencedObject);
        }
        return newCollection;
    }

    private final void storeReferencedCollection(EReference eReference, Collection<Object> referencedCollection) {
        this.getEReferenceMap().put(eReference, referencedCollection);
    }

    private final void storeReferencedObject(EReference eReference, Object referencedObject) {
        this.getEReferenceMap().put(eReference, referencedObject);
    }
}

