/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.BatchActionGuiReader;
import com.excentis.products.byteblower.gui.model.reader.ScenarioGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.BatchActionBlockReader;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.BatchActionBlockReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.BatchActionReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ScenarioReaderImpl;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class BatchActionItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int COLUMN_START_TIME = 0;
    public static final int COLUMN_SCENARIO = 1;
    public static final int COLUMN_DURATION = 2;
    private static final String STARTTYPE_RELATIVE_BATCH = "Relative (to start of Batch)";
    private static final String STARTTYPE_RELATIVE_PREVIOUS = "Relative (to end of previous Scenario)";
    private static final String STARTTYPE_ABSOLUTE = TimedStartType.ABSOLUTE.getName();
    private static final String[] STARTTYPE_CHOICES_UNKNOWN = new String[0];
    private static final String[] STARTTYPE_CHOICES_FIRST = new String[]{"Relative (to start of Batch)", STARTTYPE_ABSOLUTE};
    private static final String[] STARTTYPE_CHOICES = new String[]{"Relative (to end of previous Scenario)", STARTTYPE_ABSOLUTE};
    private static final int POSITION_INVALID = 0;
    private static final int POSITION_RELATIVE_BATCH = -1;
    private static final int POSITION_RELATIVE_PREVIOUS = -2;
    private static final int POSITION_ABSOLUTE = -3;

    public BatchActionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addStartTimePropertyDescriptor(object);
            this.addInitializationTimePropertyDescriptor(object);
            this.addScenarioPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getTextGen(Object object) {
        String label = ((BatchAction)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_BatchAction_type") : String.valueOf(this.getString("_UI_BatchAction_type")) + " " + label;
    }

    protected void addStartTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BatchAction_startTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BatchAction_startTime_feature", "_UI_BatchAction_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__START_TIME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addInitializationTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BatchAction_initializationTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BatchAction_initializationTime_feature", "_UI_BatchAction_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__INITIALIZATION_TIME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addScenarioPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BatchAction_scenario_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BatchAction_scenario_feature", "_UI_BatchAction_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__SCENARIO, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/BatchAction"));
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(3, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__START_TIME);
            }
            case 1: {
                return new FeatureInfo(1, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BATCH_ACTION__SCENARIO);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }

    private int getAbsolutePosition(BatchAction batchAction) {
        BatchActionBlock batchActionBlock = batchAction.getBatchActionBlock();
        if (batchActionBlock != null) {
            EList batchActions = batchActionBlock.getBatchActions();
            int batchActionIndex = batchActions.indexOf((Object)batchAction);
            Batch batch = batchActionBlock.getBatch();
            if (batch != null) {
                EList batchActionBlocks = batch.getBatchActionBlocks();
                for (BatchActionBlock prevBatchActionBlock : batchActionBlocks) {
                    if (prevBatchActionBlock == batchActionBlock) break;
                    batchActionIndex += prevBatchActionBlock.getBatchActions().size();
                }
                return batchActionIndex;
            }
        }
        return 0;
    }

    private String getText(BatchAction batchAction) {
        return Integer.toString(this.getAbsolutePosition(batchAction) + 1);
    }

    @Override
    public String getText(Object object) {
        if (object instanceof BatchAction) {
            return this.getText((BatchAction)object);
        }
        return "";
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(BatchAction.class)) {
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    private final int getPositionDependentStartType(BatchAction batchAction) {
        BatchActionBlockReader reader;
        EList batchActions;
        BatchActionBlock myBatchActionBlock = batchAction.getBatchActionBlock();
        if (myBatchActionBlock != null && (batchActions = (reader = this.getBatchActionBlockReader(myBatchActionBlock)).getBatchActions()) != null) {
            TimedStartType startType;
            int batchActionIndex = batchActions.indexOf((Object)this);
            if (batchActionIndex > 0) {
                return -2;
            }
            if (batchActionIndex == 0 && (startType = reader.getStartType()) != null) {
                switch (startType.getValue()) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return -3;
                    }
                }
            }
        }
        return 0;
    }

    public String[] getStartTypeChoices(BatchAction batchAction) {
        int startType = this.getPositionDependentStartType(batchAction);
        switch (startType) {
            case -1: {
                return STARTTYPE_CHOICES_FIRST;
            }
            case -3: 
            case -2: {
                return STARTTYPE_CHOICES;
            }
        }
        return STARTTYPE_CHOICES_UNKNOWN;
    }

    public Object getValue(Object object, int columnIndex) {
        if (object instanceof BatchAction) {
            BatchAction batchAction = (BatchAction)object;
            BatchActionReaderImpl reader = new BatchActionReaderImpl(batchAction);
            switch (columnIndex) {
                case 0: {
                    return batchAction.getStartTime();
                }
                case 1: {
                    ScenarioReader scenarioReader = this.getScenarioReader((BatchActionReader)reader);
                    return new Integer(scenarioReader == null ? 0 : scenarioReader.getIndexInContainer() + 1);
                }
                case 2: {
                    ScenarioReader scenarioReader = this.getScenarioReader((BatchActionReader)reader);
                    return scenarioReader.getDuration();
                }
            }
        }
        return null;
    }

    private ScenarioReader getScenarioReader(BatchActionReader reader) {
        Scenario scenario = reader.getScenario();
        if (scenario == null) {
            return null;
        }
        return new ScenarioReaderImpl(scenario);
    }

    private String getDurationString(Object object) {
        if (object instanceof BatchAction) {
            return this.getDurationString((BatchAction)object);
        }
        return "";
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        BatchActionGuiReader reader = GuiReaderFactory.create((BatchAction)((BatchAction)object));
        switch (columnIndex) {
            case 0: {
                return reader.getStartTimeString();
            }
            case 1: {
                return reader.getScenarioString();
            }
            case 2: {
                return reader.getDurationString();
            }
        }
        return "";
    }

    public Object getColumnImage(Object object, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                BatchAction batchAction = (BatchAction)object;
                BatchActionGuiReader guiReader = GuiReaderFactory.create((BatchAction)batchAction);
                ScenarioGuiReader scenarioGuiReader = guiReader.getScenarioGuiReader();
                return scenarioGuiReader.getImage();
            }
        }
        return null;
    }

    @Override
    public Color getBackground(Object element, int columnIndex) {
        int batchActionBlockIndex;
        BatchAction batchAction = (BatchAction)element;
        BatchActionBlock batchActionBlock = batchAction.getBatchActionBlock();
        BatchActionBlockReaderImpl reader = new BatchActionBlockReaderImpl(batchActionBlock);
        if (batchActionBlock != null && (batchActionBlockIndex = reader.getIndexInContainer()) >= 0) {
            return batchActionBlockIndex % 2 == 0 ? EByteBlowerObjectItemProvider.BACKGROUND_COLOR_EVEN_ROW : EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ODD_ROW();
        }
        return EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ERROR;
    }

    public Color getForeground(Object element, int columnIndex) {
        BatchAction action = (BatchAction)element;
        Scenario scenario = action.getScenario();
        ScenarioReader reader = ReaderFactory.create((Scenario)scenario);
        switch (columnIndex) {
            case 1: {
                if (scenario != null && !reader.hasErrorStatus()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private BatchActionBlockReader getBatchActionBlockReader(BatchActionBlock batchActionBlock) {
        return new BatchActionBlockReaderImpl(batchActionBlock);
    }
}

