/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.ByteBlowerGuiPortGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.Ipv6AddressConfigType;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.impl.ByteBlowerGuiPortImpl;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.EthernetConfigurationReader;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.Ipv6AddressReader;
import com.excentis.products.byteblower.model.reader.Ipv6ConfigurationReader;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class ByteBlowerGuiPortItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    private static final String notSpecified = "Not specified";
    public static final int COLUMN_IPV4_PORTNAME = 0;
    public static final int COLUMN_IPV4_MACADDRESS = 1;
    public static final int COLUMN_IPV4_CONFIGURATION = 2;
    public static final int COLUMN_IPV4_IPV4ADDRESS = 3;
    public static final int COLUMN_IPV4_GATEWAY = 4;
    public static final int COLUMN_IPV4_NETMASK = 5;
    public static final int COLUMN_IPV4_NAT = 6;
    public static final int COLUMN_IPV4_VLAN_STACK = 7;
    public static final int COLUMN_IPV4_MTU = 8;
    public static final int COLUMN_IPV4_DOCKED = 9;
    public static final int COLUMN_IPV6_PORTNAME = 0;
    public static final int COLUMN_IPV6_MACADDRESS = 1;
    public static final int COLUMN_IPV6_CONFIGURATION = 2;
    public static final int COLUMN_IPV6_IPV6ADDRESS = 3;
    public static final int COLUMN_IPV6_ROUTERADDRESS = 4;
    public static final int COLUMN_IPV6_PREFIXLENGTH = 5;
    public static final int COLUMN_IPV6_FIREWALL = 6;
    public static final int COLUMN_IPV6_VLAN_STACK = 7;
    public static final int COLUMN_IPV6_MTU = 8;
    public static final int COLUMN_IPV6_DOCKED = 9;

    public ByteBlowerGuiPortItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTheSourceOfFlowPropertyDescriptor(object);
            this.addTheDestinationOfFlowPropertyDescriptor(object);
            this.addNattedPropertyDescriptor(object);
            this.addFlowPropertyDescriptor(object);
            this.addByteBlowerGuiPortToMulticastMemberPortPropertyDescriptor(object);
            this.addMulticastSourceByteBlowerGuiPortPropertyDescriptor(object);
            this.addAddressConfigurationSucceededPropertyDescriptor(object);
            this.addMtuPropertyDescriptor(object);
            this.addPortForwardingPropertyDescriptor(object);
            this.addVlansPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTheSourceOfFlowPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AddressableSource_theSourceOfFlow_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AddressableSource_theSourceOfFlow_feature", "_UI_AddressableSource_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.ADDRESSABLE_SOURCE__THE_SOURCE_OF_FLOW, true, false, true, null, null, null));
    }

    protected void addTheDestinationOfFlowPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_AddressableDestination_theDestinationOfFlow_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_AddressableDestination_theDestinationOfFlow_feature", "_UI_AddressableDestination_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.ADDRESSABLE_DESTINATION__THE_DESTINATION_OF_FLOW, true, false, true, null, null, null));
    }

    protected void addFlowPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_Flow_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_Flow_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__FLOW, true, false, true, null, null, null));
    }

    protected void addByteBlowerGuiPortToMulticastMemberPortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_byteBlowerGuiPortToMulticastMemberPort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_byteBlowerGuiPortToMulticastMemberPort_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__BYTE_BLOWER_GUI_PORT_TO_MULTICAST_MEMBER_PORT, true, false, true, null, null, null));
    }

    protected void addMulticastSourceByteBlowerGuiPortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_MulticastSourceByteBlowerGuiPort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_MulticastSourceByteBlowerGuiPort_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__MULTICAST_SOURCE_BYTE_BLOWER_GUI_PORT, true, false, true, null, null, null));
    }

    protected void addMtuPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_mtu_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_mtu_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__MTU, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addPortForwardingPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_portForwarding_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_portForwarding_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__PORT_FORWARDING, true, false, true, null, null, null));
    }

    protected void addVlansPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_vlans_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_vlans_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLANS, true, false, true, null, null, null));
    }

    protected void addAddressConfigurationSucceededPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_addressConfigurationSucceeded_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_addressConfigurationSucceeded_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__ADDRESS_CONFIGURATION_SUCCEEDED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addNattedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ByteBlowerGuiPort_natted_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ByteBlowerGuiPort_natted_feature", "_UI_ByteBlowerGuiPort_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__NATTED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__LAYER2_CONFIGURATION);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__BYTE_BLOWER_GUI_PORT_CONFIGURATION);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLAN_STACK);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ByteBlowerGuiPort"));
    }

    public String getTextGen(Object object) {
        String label = ((ByteBlowerGuiPort)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_ByteBlowerGuiPort_type") : String.valueOf(this.getString("_UI_ByteBlowerGuiPort_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ByteBlowerGuiPort.class)) {
            case 10: 
            case 14: 
            case 16: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__LAYER2_CONFIGURATION, ByteblowerguimodelFactory.eINSTANCE.createEthernetConfiguration()));
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION, ByteblowerguimodelFactory.eINSTANCE.createIpv4Configuration()));
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION, ByteblowerguimodelFactory.eINSTANCE.createIpv6Configuration()));
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__BYTE_BLOWER_GUI_PORT_CONFIGURATION, ByteblowerguimodelFactory.eINSTANCE.createByteBlowerGuiPortConfiguration()));
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLAN_STACK, ByteblowerguimodelFactory.eINSTANCE.createVlanStackPart()));
    }

    private ByteBlowerGuiPortReader getReader(ByteBlowerGuiPort port) {
        return new ByteBlowerGuiPortReaderImpl(port);
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        ByteBlowerGuiPortReader reader = this.getReader((ByteBlowerGuiPort)object);
        if (reader.hasActiveIpv4Configuration()) {
            return this.getIpv4ColumnText(object, columnIndex);
        }
        if (reader.hasActiveIpv6Configuration()) {
            return this.getIpv6ColumnText(object, columnIndex);
        }
        return null;
    }

    private String getIpv4ColumnText(Object object, int columnIndex) {
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)object;
        Ipv4Configuration ipv4Config = port.getIpv4Configuration();
        ByteBlowerGuiPortReader reader = this.getReader(port);
        boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
        switch (columnIndex) {
            case 0: {
                return reader.getName();
            }
            case 1: {
                return reader.getMacAddressString();
            }
            case 2: {
                if (isDockedOnMobileDevice) {
                    return "Fixed";
                }
                return this.getDhcpv4Info(ipv4Config);
            }
            case 3: {
                return reader.getIPAddress();
            }
            case 4: {
                if (isDockedOnMobileDevice) {
                    return "mobile device";
                }
                return reader.getDefaultIpv4Gateway();
            }
            case 5: {
                if (isDockedOnMobileDevice) {
                    return "mobile device";
                }
                return reader.getNetmask();
            }
            case 6: {
                return reader.getNatInfo();
            }
            case 7: {
                if (isDockedOnMobileDevice) {
                    return "No";
                }
                return this.getVlanInfo(port);
            }
            case 8: {
                if (isDockedOnMobileDevice) {
                    return "mobile device";
                }
                return this.getMtuString(port);
            }
            case 9: {
                return reader.getDockedStatus();
            }
        }
        return "";
    }

    private String getMtuString(ByteBlowerGuiPort port) {
        return Long.toString(port.getMtu());
    }

    private String getDhcpv4Info(Ipv4Configuration ipv4Configuration) {
        Ipv4AddressConfigType type = ipv4Configuration.getAddressConfiguration();
        if (type == Ipv4AddressConfigType.FIXED) {
            return ipv4Configuration.getAddressConfiguration().getName();
        }
        Dhcp dhcp = ipv4Configuration.getDhcpOptions();
        if (dhcp == null) {
            return notSpecified;
        }
        return dhcp.getName();
    }

    private String getDhcpv6Info(Ipv6Configuration ipv6Configuration) {
        Ipv6AddressConfigType type = ipv6Configuration.getAddressConfiguration();
        if (type != Ipv6AddressConfigType.DHC_PV6_LITERAL) {
            return type.getName();
        }
        Dhcp dhcp = ipv6Configuration.getDhcpOptions();
        if (dhcp == null) {
            return notSpecified;
        }
        return dhcp.getName();
    }

    private String getVlanInfo(ByteBlowerGuiPort port) {
        ByteBlowerGuiPortReader reader = this.getReader(port);
        return reader.getVlanStackString();
    }

    private String getIpv6ColumnText(Object object, int columnIndex) {
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)object;
        Ipv6Configuration ipv6Config = port.getIpv6Configuration();
        ByteBlowerGuiPortReader reader = this.getReader(port);
        boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
        switch (columnIndex) {
            case 0: {
                return reader.getName();
            }
            case 1: {
                return reader.getMacAddressString();
            }
            case 2: {
                if (isDockedOnMobileDevice) {
                    return "Fixed";
                }
                return this.getDhcpv6Info(ipv6Config);
            }
            case 3: {
                return reader.getIPAddress();
            }
            case 4: {
                if (isDockedOnMobileDevice) {
                    return "mobile device";
                }
                return reader.getDefaultIpv6Router();
            }
            case 5: {
                return reader.getPrefixLengthString();
            }
            case 6: {
                return reader.isNatted() ? "Yes" : "No";
            }
            case 7: {
                if (isDockedOnMobileDevice) {
                    return "No";
                }
                return this.getVlanInfo(port);
            }
            case 8: {
                if (isDockedOnMobileDevice) {
                    return "mobile device";
                }
                return this.getMtuString(port);
            }
            case 9: {
                return reader.getDockedStatus();
            }
        }
        return "";
    }

    public Object getColumnImage(Object object, int columnIndex) {
        ByteBlowerGuiPortImpl port = (ByteBlowerGuiPortImpl)object;
        ByteBlowerGuiPortReaderImpl reader = new ByteBlowerGuiPortReaderImpl((ByteBlowerGuiPort)port);
        if (reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV4)) {
            return this.getIpv4ColumnImage(port, columnIndex);
        }
        if (reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV6)) {
            return this.getIpv6ColumnImage(port, columnIndex);
        }
        return null;
    }

    private Object getIpv4ColumnImage(ByteBlowerGuiPortImpl port, int columnIndex) {
        ByteBlowerGuiPortGuiReader reader = GuiReaderFactory.create((ByteBlowerGuiPort)port);
        switch (columnIndex) {
            case 0: {
                return reader.getImage();
            }
            case 2: {
                return reader.getDhcpImage();
            }
            case 6: {
                return reader.getNatImage();
            }
            case 7: {
                return reader.getVlanStackImage();
            }
        }
        return null;
    }

    private Object getIpv6ColumnImage(ByteBlowerGuiPortImpl port, int columnIndex) {
        ByteBlowerGuiPortGuiReader reader = GuiReaderFactory.create((ByteBlowerGuiPort)port);
        switch (columnIndex) {
            case 0: {
                return reader.getImage();
            }
            case 2: {
                return reader.getDhcpImage();
            }
            case 7: {
                return reader.getVlanStackImage();
            }
        }
        return null;
    }

    public Color getForeground(Object object, int columnIndex) {
        ByteBlowerGuiPortReader reader = this.getReader((ByteBlowerGuiPort)object);
        if (reader.hasActiveIpv4Configuration()) {
            return this.getIpv4Foreground(reader, columnIndex);
        }
        if (reader.hasActiveIpv6Configuration()) {
            return this.getIpv6Foreground(reader, columnIndex);
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
    }

    private Color getIpv4Foreground(ByteBlowerGuiPortReader reader, int columnIndex) {
        EthernetConfigurationReader ethernetConfigReader = reader.getEthernetConfigurationReader();
        Ipv4ConfigurationReader ipConfigReader = reader.getIpv4ConfigurationReader();
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)reader.getObject();
        boolean fixedAddress = ipConfigReader.usesFixedAdress();
        boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
        switch (columnIndex) {
            case 1: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                MacAddressReader macReader = ethernetConfigReader.getMacAddressReader();
                if (macReader.isValid()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 2: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                return this.getConfigurationForeGround(reader);
            }
            case 3: {
                if (isDockedOnMobileDevice || !fixedAddress) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                Ipv4AddressReader ipReader = ipConfigReader.getAddressReader();
                if (ipReader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 4: {
                if (isDockedOnMobileDevice || !fixedAddress) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                Ipv4AddressReader gwReader = ipConfigReader.getGatewayReader();
                if (!isDockedOnMobileDevice && gwReader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 5: {
                if (isDockedOnMobileDevice || !fixedAddress) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                Ipv4AddressReader maskReader = ipConfigReader.getNetmaskReader();
                if (maskReader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 7: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                return this.getVlanColumnForeGround(reader);
            }
            case 8: {
                if (!isDockedOnMobileDevice) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
            }
            case 9: {
                return this.getDockedColumnForeGround(reader);
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private Color getIpv6Foreground(ByteBlowerGuiPortReader reader, int columnIndex) {
        EthernetConfigurationReader ethernetConfigReader = reader.getEthernetConfigurationReader();
        Ipv6ConfigurationReader ipConfigReader = reader.getIpv6ConfigurationReader();
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)reader.getObject();
        boolean fixedAddress = ipConfigReader.usesFixedAdress();
        boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
        switch (columnIndex) {
            case 1: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                MacAddressReader macReader = ethernetConfigReader.getMacAddressReader();
                if (macReader.isValid()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 2: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                return this.getConfigurationForeGround(reader);
            }
            case 3: {
                if (isDockedOnMobileDevice) {
                    String address = reader.getIPAddress();
                    if (address.isEmpty()) {
                        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
                    }
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                if (!fixedAddress) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                Ipv6AddressReader ipReader = ipConfigReader.getAddressReader();
                if (ipReader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 4: {
                if (isDockedOnMobileDevice || !fixedAddress) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                Ipv6AddressReader routerReader = ipConfigReader.getDefaultRouterReader();
                if (routerReader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 5: {
                if (!isDockedOnMobileDevice && fixedAddress) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
            }
            case 7: {
                if (isDockedOnMobileDevice) {
                    return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
                }
                return this.getVlanColumnForeGround(reader);
            }
            case 8: {
                if (!isDockedOnMobileDevice) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
            }
            case 9: {
                return this.getDockedColumnForeGround(reader);
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private Color getConfigurationForeGround(ByteBlowerGuiPortReader reader) {
        return reader.hasDeletedDhcp() ? EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR() : EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private Color getVlanColumnForeGround(ByteBlowerGuiPortReader reader) {
        return !reader.usesVlanStack() || reader.hasValidVlanStack() ? EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK : EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
    }

    private Color getDockedColumnForeGround(ByteBlowerGuiPortReader reader) {
        return reader.isDockingOk() ? EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK : EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        Command addCommand = super.createAddCommand(domain, owner, feature, collection, index);
        return addCommand;
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)object));
        if (reader.isIPv4()) {
            return this.getIpv4FeatureInfoOnColumn(object, columnIndex);
        }
        return this.getIpv6FeatureInfoOnColumn(object, columnIndex);
    }

    private FeatureInfo getIpv4FeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(2, (EStructuralFeature)ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME);
            }
            case 1: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__LAYER2_CONFIGURATION);
            }
            case 2: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION);
            }
            case 3: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION);
            }
            case 4: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION);
            }
            case 5: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV4_CONFIGURATION);
            }
            case 6: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__NATTED);
            }
            case 7: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLAN_STACK);
            }
            case 8: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__MTU);
            }
            case 9: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__BYTE_BLOWER_GUI_PORT_CONFIGURATION);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }

    private FeatureInfo getIpv6FeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(2, (EStructuralFeature)ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME);
            }
            case 1: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__LAYER2_CONFIGURATION);
            }
            case 2: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION);
            }
            case 3: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION);
            }
            case 4: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION);
            }
            case 5: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__IPV6_CONFIGURATION);
            }
            case 6: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__NATTED);
            }
            case 7: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__VLAN_STACK);
            }
            case 8: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__MTU);
            }
            case 9: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_GUI_PORT__BYTE_BLOWER_GUI_PORT_CONFIGURATION);
            }
        }
        System.err.println("Unknown column for IPv6");
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }

    @Override
    protected Color getAlternatingBackground(EByteBlowerObject object, Color oddRowColor, Color evenRowColor) {
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)object;
        ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)port);
        if (!reader.isContained()) {
            return null;
        }
        int index = reader.getIndexInContainer();
        if (reader.isPartOfGroup()) {
            index = reader.getGroup().getMembers().indexOf((Object)port);
        } else {
            List allPorts = reader.getProjectReader().getByteBlowerGuiPortReaders();
            UniqueEList ports = new UniqueEList();
            for (ByteBlowerGuiPortReader portReader : allPorts) {
                if (portReader.isIPv4() != reader.isIPv4() || portReader.isPartOfGroup()) continue;
                ports.add((Object)((ByteBlowerGuiPort)portReader.getObject()));
            }
            index = ports.indexOf((Object)port);
        }
        return (index + 1) % 2 == 0 ? evenRowColor : oddRowColor;
    }
}

