/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.AddressableDestinationGuiReader;
import com.excentis.products.byteblower.gui.model.reader.AddressableSourceGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowTemplateGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.impl.FlowReaderImpl;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class FlowItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_FLOWTEMPLATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_DESTINATION = 3;
    public static final int COLUMN_LATENCY_JITTER = 4;
    public static final int COLUMN_OOS = 5;
    public static final int COLUMN_TOS = 6;

    public FlowItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcePropertyDescriptor(object);
            this.addDestinationPropertyDescriptor(object);
            this.addFlowTemplatePropertyDescriptor(object);
            this.addLatencyAndJitterTypePropertyDescriptor(object);
            this.addOutOfSequenceDetectionPropertyDescriptor(object);
            this.addFlowMeasurementPropertyDescriptor(object);
            this.addByteBlowerGuiPortPropertyDescriptor(object);
            this.addTosPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_source_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_source_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__SOURCE, true, false, true, null, null, null));
    }

    protected void addDestinationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_destination_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_destination_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__DESTINATION, true, false, true, null, null, null));
    }

    protected void addFlowTemplatePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_FlowTemplate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_FlowTemplate_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE, true, false, true, null, null, null));
    }

    protected void addFlowMeasurementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_flowMeasurement_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_flowMeasurement_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__FLOW_MEASUREMENT, true, false, true, null, null, null));
    }

    protected void addLatencyAndJitterTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_latencyAndJitterType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_latencyAndJitterType_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__LATENCY_AND_JITTER_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addByteBlowerGuiPortPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_ByteBlowerGuiPort_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_ByteBlowerGuiPort_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__BYTE_BLOWER_GUI_PORT, true, false, true, null, null, null));
    }

    protected void addTosPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_tos_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_tos_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__TOS, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Flow"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Flow.class)) {
            case 7: 
            case 8: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void addOutOfSequenceDetectionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Flow_outOfSequenceDetection_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Flow_outOfSequenceDetection_feature", "_UI_Flow_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__OUT_OF_SEQUENCE_DETECTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public String getText(Object object) {
        String label = ((Flow)object).getName();
        return label == null || label.length() == 0 ? "" : label;
    }

    private FlowTemplate getFlowTemplate(Flow flow) {
        return flow.getFlowTemplate();
    }

    private AddressableDestination getDestination(Flow flow) {
        return flow.getDestination();
    }

    private List<ByteBlowerGuiPort> getEavesDroppers(Flow flow) {
        return flow.getByteBlowerGuiPort();
    }

    private boolean hasEavesDroppers(Flow flow) {
        List<ByteBlowerGuiPort> eavesDroppers = this.getEavesDroppers(flow);
        return eavesDroppers != null && !eavesDroppers.isEmpty();
    }

    private LatencyAndJitterType getLatencyAndJitterType(Flow flow) {
        return flow.getLatencyAndJitterType();
    }

    private OutOfSequenceType getOutOfSequenceType(Flow flow) {
        return flow.getOutOfSequenceDetection();
    }

    private boolean flowSupportsLatencyAndOos(Object object) {
        if (object instanceof Flow) {
            return this.flowSupportsLatencyAndOos((Flow)object);
        }
        return false;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        Flow flow = (Flow)object;
        FlowGuiReader reader = GuiReaderFactory.create((Flow)flow);
        switch (columnIndex) {
            case 0: {
                return reader.getName();
            }
            case 1: {
                return reader.getFlowTemplateName();
            }
            case 2: {
                return reader.getAddressableSourceName();
            }
            case 3: {
                return reader.getAddressableDestinationName();
            }
            case 4: {
                return reader.getLatencyString();
            }
            case 5: {
                return reader.getOosString();
            }
            case 6: {
                return reader.getTosString();
            }
        }
        return null;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Flow flow = (Flow)object;
        FlowGuiReader reader = GuiReaderFactory.create((Flow)flow);
        switch (columnIndex) {
            case 0: {
                return reader.getImage();
            }
            case 1: {
                FlowTemplateGuiReader templateReader = reader.getFlowTemplateGuiReader();
                if (templateReader == null) {
                    return null;
                }
                return templateReader.getImage();
            }
            case 2: {
                AddressableSourceGuiReader sourceReader = reader.getAddressableSourceGuiReader();
                if (sourceReader == null) {
                    return null;
                }
                return sourceReader.getImage();
            }
            case 3: {
                AddressableDestinationGuiReader destinationReader = reader.getAddressableDestinationGuiReader();
                if (destinationReader == null) {
                    return null;
                }
                return destinationReader.getImage();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        Flow flow = (Flow)element;
        FlowReader reader = this.getReader(flow);
        switch (columnIndex) {
            case 1: {
                if (!reader.hasErrorInFlowTemplate()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 2: {
                if (!reader.hasErrorInSource()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 3: {
                if (!reader.hasErrorInDestination()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 5: {
                if (!reader.hasInvalidOoS()) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
            case 6: {
                if (reader.getTcpFlowReader() != null) {
                    return null;
                }
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_DISABLED();
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private FlowReader getReader(Flow flow) {
        return new FlowReaderImpl(flow);
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(2, (EStructuralFeature)ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME);
            }
            case 1: {
                return new FeatureInfo(1, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__FLOW_TEMPLATE);
            }
            case 2: {
                return new FeatureInfo(1, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__SOURCE);
            }
            case 3: {
                return new FeatureInfo(1, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__DESTINATION);
            }
            case 4: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__LATENCY_AND_JITTER_TYPE);
            }
            case 5: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__OUT_OF_SEQUENCE_DETECTION);
            }
            case 6: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW__TOS);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }
}

