/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.IpAddressItemProvider;
import com.excentis.products.byteblower.model.reader.Ipv6AddressReader;
import com.excentis.products.byteblower.model.reader.impl.Ipv6AddressReaderImpl;
import com.excentis.products.byteblower.object.control.ByteController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.graphics.Color;

public class Ipv6AddressItemProvider
extends IpAddressItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    private static final int COLUMN_NAME = 0;

    public Ipv6AddressItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Ipv6Address"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    private final String getAddress(Ipv6Address ipv6Address) {
        return this.getAddress(ipv6Address, false);
    }

    private final String getAddress(Ipv6Address ipv6Address, boolean compressed) {
        String ipv6String = "";
        int length = 0;
        EList bytes = ipv6Address.getBytes();
        int size = bytes.size();
        if (size != 16) {
            System.out.println("ERROR : IPv6 Address Length is " + size);
        }
        int i = 0;
        while (i < 16) {
            Byte by = (Byte)bytes.get(i);
            String hexPart = ByteController.toString((byte)by);
            if (hexPart.length() == 1) {
                hexPart = "0" + hexPart;
            }
            ipv6String = String.valueOf(ipv6String) + hexPart;
            if ((length += 2) % 4 == 0 && i != 15) {
                ipv6String = String.valueOf(ipv6String) + ":";
            }
            ++i;
        }
        return ipv6String.toLowerCase();
    }

    @Override
    public String getText(Object object) {
        if (object instanceof Ipv6Address) {
            return this.getAddress((Ipv6Address)object);
        }
        return "";
    }

    public Object getColumnImage(Object object, int columnIndex) {
        return null;
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(object);
            }
        }
        return "";
    }

    @Override
    public Color getBackground(Object element, int columnIndex) {
        return EByteBlowerObjectItemProvider.BACKGROUND_COLOR_NONE;
    }

    public Color getForeground(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Ipv6AddressReader reader = this.getIpv6AddressReader((Ipv6Address)element);
                if (reader.isValid(false)) break;
                return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
            }
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    private Ipv6AddressReader getIpv6AddressReader(Ipv6Address object) {
        return new Ipv6AddressReaderImpl(object);
    }
}

