/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.Ipv6AddressConfigType;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.Layer2Configuration;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.VlanStackPart;
import com.excentis.products.byteblower.model.reader.Activator;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.EthernetConfigurationReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.Ipv4ConfigurationReader;
import com.excentis.products.byteblower.model.reader.Ipv6ConfigurationReader;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.AddressableDestinationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortConfigurationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.EthernetConfigurationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.Ipv4ConfigurationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.Ipv6ConfigurationReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.MacAddressReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.VlanReaderImpl;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalDockableReader;
import com.excentis.products.byteblower.model.reader.server.impl.PhysicalConfigurationReaderImpl;
import com.excentis.products.byteblower.server.model.AbstractServer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ByteBlowerGuiPortReaderImpl
extends AddressableDestinationReaderImpl<ByteBlowerGuiPort>
implements ByteBlowerGuiPortReader {
    private static final String StatusNotAttached = new String("No");
    private static final String StatusUnknownAttach = new String(" - Needs Refresh");

    public ByteBlowerGuiPortReaderImpl(ByteBlowerGuiPort port) {
        super(port);
    }

    @Override
    public final ByteBlowerGuiPortConfiguration getByteBlowerGuiPortConfiguration() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            return myByteBlowerGuiPort.getByteBlowerGuiPortConfiguration();
        }
        return null;
    }

    public final ByteBlowerGuiPortConfigurationReaderImpl getByteBlowerGuiPortConfigurationController() {
        ByteBlowerGuiPortConfiguration myByteBlowerGuiPortConfiguration = this.getByteBlowerGuiPortConfiguration();
        if (myByteBlowerGuiPortConfiguration != null) {
            return new ByteBlowerGuiPortConfigurationReaderImpl(myByteBlowerGuiPortConfiguration);
        }
        return null;
    }

    @Override
    public final Ipv4Configuration getIpv4Configuration() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            return myByteBlowerGuiPort.getIpv4Configuration();
        }
        return null;
    }

    @Override
    public final Ipv6Configuration getIpv6Configuration() {
        ByteBlowerGuiPort myByteBlowerGuiPort = (ByteBlowerGuiPort)this.getObject();
        if (myByteBlowerGuiPort != null) {
            return myByteBlowerGuiPort.getIpv6Configuration();
        }
        return null;
    }

    @Override
    public final Ipv4ConfigurationReader getIpv4ConfigurationReader() {
        Ipv4Configuration myIpv4Configuration = this.getIpv4Configuration();
        if (myIpv4Configuration != null) {
            return new Ipv4ConfigurationReaderImpl(myIpv4Configuration);
        }
        return null;
    }

    @Override
    public final Ipv6ConfigurationReader getIpv6ConfigurationReader() {
        Ipv6Configuration myIpv6Configuration = this.getIpv6Configuration();
        if (myIpv6Configuration != null) {
            return new Ipv6ConfigurationReaderImpl(myIpv6Configuration);
        }
        return null;
    }

    @Override
    public VlanStack getVlanStack() {
        return ((ByteBlowerGuiPort)this.getObject()).getVlans();
    }

    @Override
    public Dhcp getDhcpv4() {
        Dhcp dhcp = null;
        Ipv4Configuration ipv4Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration();
        if (ipv4Configuration != null) {
            dhcp = ipv4Configuration.getDhcpOptions();
        }
        return dhcp;
    }

    @Override
    public Dhcp getDhcpv6() {
        Dhcp dhcp = null;
        Ipv6Configuration ipv6Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration();
        if (ipv6Configuration != null) {
            dhcp = ipv6Configuration.getDhcpOptions();
        }
        return dhcp;
    }

    @Override
    public VlanStackReader getVlanStackReader() {
        return ReaderFactory.create(this.getVlanStack());
    }

    public EList<VlanStackPart> getVlanStackParts() {
        return ((ByteBlowerGuiPort)this.getObject()).getVlanStack();
    }

    private boolean hasValidDeprecatedVlan() {
        if (this.getVlanStackParts().isEmpty()) {
            return false;
        }
        for (VlanStackPart stackPart : this.getVlanStackParts()) {
            if (stackPart.getVlan() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean usesOldDhcpv4() {
        boolean noDhcpRef;
        Ipv4Configuration ipv4Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration();
        if (ipv4Configuration == null) {
            return false;
        }
        boolean usesDhcp = ipv4Configuration.getAddressConfiguration() == Ipv4AddressConfigType.DHC_PV4;
        boolean bl = noDhcpRef = ipv4Configuration.getDhcpOptions() == null;
        return usesDhcp && noDhcpRef;
    }

    @Override
    public boolean usesOldDhcpv6() {
        boolean noDhcpRef;
        Ipv6Configuration ipv6Configuration = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration();
        if (ipv6Configuration == null) {
            return false;
        }
        boolean usesDhcp = ipv6Configuration.getAddressConfiguration() == Ipv6AddressConfigType.DHC_PV6_LITERAL;
        boolean bl = noDhcpRef = ipv6Configuration.getDhcpOptions() == null;
        return usesDhcp && noDhcpRef;
    }

    public Long getMTU() {
        return ((ByteBlowerGuiPort)this.getObject()).getMtu();
    }

    @Override
    public ByteBlowerGuiPortConfigurationReader getByteBlowerGuiPortConfigurationReader() {
        return new ByteBlowerGuiPortConfigurationReaderImpl(((ByteBlowerGuiPort)this.getObject()).getByteBlowerGuiPortConfiguration());
    }

    @Override
    public EthernetConfigurationReader getEthernetConfigurationReader() {
        EthernetConfigurationReaderImpl reader = null;
        Layer2Configuration layer2 = ((ByteBlowerGuiPort)this.getObject()).getLayer2Configuration();
        if (layer2 instanceof EthernetConfiguration) {
            EthernetConfiguration ethernet = (EthernetConfiguration)layer2;
            reader = new EthernetConfigurationReaderImpl(ethernet);
        }
        return reader;
    }

    private boolean hasIPv4Configuration() {
        return ((ByteBlowerGuiPort)this.getObject()).isSetIpv4Configuration();
    }

    private boolean hasIPv6Configuration() {
        return ((ByteBlowerGuiPort)this.getObject()).isSetIpv6Configuration();
    }

    @Override
    public boolean isIPv4() {
        return this.hasIPv4Configuration() && this.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV4);
    }

    @Override
    public boolean isIPv6() {
        return this.hasIPv6Configuration() && this.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV6);
    }

    @Override
    public boolean isNatted() {
        return ((ByteBlowerGuiPort)this.getObject()).isNatted();
    }

    @Override
    public String getMacAddressString() {
        if (this.isDockedOnMobileDevice()) {
            return "mobile device";
        }
        EthernetConfiguration ethernetConfig = (EthernetConfiguration)((ByteBlowerGuiPort)this.getObject()).getLayer2Configuration();
        MacAddressReaderImpl reader = new MacAddressReaderImpl(ethernetConfig.getMacAddress());
        return reader.getAddress();
    }

    @Override
    public boolean isDockedOnMobileDevice() {
        return this.getByteBlowerGuiPortConfigurationReader().isDockedOnMobileDevice();
    }

    @Override
    public String getServerAddress() {
        return ((ByteBlowerGuiPort)this.getObject()).getByteBlowerGuiPortConfiguration().getPhysicalServerAddress();
    }

    @Override
    public boolean usesDHCP() {
        return this.isIPv4() && ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration().getAddressConfiguration() == Ipv4AddressConfigType.DHC_PV4 || this.isIPv6() && ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getAddressConfiguration() == Ipv6AddressConfigType.DHC_PV6_LITERAL;
    }

    @Override
    public boolean usesFixedIPConfiguration() {
        boolean fixedConfig = false;
        if (this.isIPv4()) {
            Ipv4AddressConfigType ipv4AddressConfigType = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration().getAddressConfiguration();
            fixedConfig = ipv4AddressConfigType == Ipv4AddressConfigType.FIXED;
        } else if (this.isIPv6()) {
            Ipv6AddressConfigType ipv6AddressConfigType = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getAddressConfiguration();
            fixedConfig = ipv6AddressConfigType == Ipv6AddressConfigType.FIXED_LITERAL;
        }
        return fixedConfig;
    }

    @Override
    public boolean usesStatelessAutoconfiguration() {
        if (!this.isIPv6()) {
            return false;
        }
        Ipv6AddressConfigType conf = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getAddressConfiguration();
        int value = conf.getValue();
        return value == Ipv6AddressConfigType.AUTO_CONFIGURATION_LITERAL.getValue();
    }

    @Override
    public String getIPAddress() {
        if (this.isDockedOnMobileDevice()) {
            MobileDeviceReader reader = (MobileDeviceReader)this.getPhysicalDockableReader();
            String ipAddress = null;
            if (this.isIPv4()) {
                ipAddress = reader.getIpAddress();
            } else if (this.isIPv6()) {
                ipAddress = reader.getIpv6Address();
            }
            if (ipAddress == null || ipAddress.isEmpty()) {
                ipAddress = StatusNotAttached;
            }
            return ipAddress;
        }
        if (this.hasFixedAddress()) {
            Ipv4Address ipAddress = null;
            if (this.isIPv4()) {
                ipAddress = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration().getIpAddress();
            } else if (this.isIPv6()) {
                ipAddress = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getIpAddress();
            }
            return IpAddressReaderImpl.getAddress(ipAddress);
        }
        return "-";
    }

    @Override
    public String getDefaultIpv4Gateway() {
        if (this.hasFixedAddress()) {
            Ipv4Address gateway = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration().getDefaultGateway();
            return IpAddressReaderImpl.getAddress((IpAddress)gateway);
        }
        return "-";
    }

    @Override
    public String getNetmask() {
        if (this.hasFixedAddress()) {
            Ipv4Address netmask = ((ByteBlowerGuiPort)this.getObject()).getIpv4Configuration().getNetmask();
            return IpAddressReaderImpl.getAddress((IpAddress)netmask);
        }
        return "-";
    }

    @Override
    public String getDefaultIpv6Router() {
        if (this.hasFixedAddress()) {
            Ipv6Address router = ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getDefaultRouter();
            return IpAddressReaderImpl.getAddress((IpAddress)router);
        }
        return "-";
    }

    @Override
    public int getPrefixLength() {
        return ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getPrefixLength();
    }

    @Override
    public String getPrefixLengthString() {
        if (this.isDockedOnMobileDevice()) {
            MobileDeviceReader reader = (MobileDeviceReader)this.getPhysicalDockableReader();
            if (reader.hasIpv6()) {
                return Integer.toString(reader.getPrefixLength());
            }
            return "N/A";
        }
        if (this.hasFixedAddress()) {
            return ((ByteBlowerGuiPort)this.getObject()).getIpv6Configuration().getPrefixLength().toString();
        }
        return "-";
    }

    @Override
    public boolean hasVlanStack() {
        return this.getVlanStack() != null;
    }

    @Override
    @Deprecated
    public boolean usesDeprecatedVlan() {
        return !((ByteBlowerGuiPort)this.getObject()).getVlanStack().isEmpty();
    }

    @Override
    public Vlan getDeprecatedVlan() {
        Vlan vlan = null;
        if (this.usesDeprecatedVlan()) {
            vlan = ((VlanStackPart)((ByteBlowerGuiPort)this.getObject()).getVlanStack().get(0)).getVlan();
        }
        return vlan;
    }

    @Override
    public long getMtuLong() {
        return ((ByteBlowerGuiPort)this.getObject()).getMtu();
    }

    @Override
    public Integer getMtuInteger() {
        return this.safeLongToInteger(this.getMtuLong());
    }

    @Override
    public String getVlanInfoForReport() {
        if (this.hasValidDeprecatedVlan()) {
            Vlan vlan = this.getDeprecatedVlan();
            VlanReaderImpl vlanReader = new VlanReaderImpl(vlan);
            String vlanName = vlanReader.getName();
            String vlanId = vlanReader.getVlanId();
            return String.valueOf(vlanName) + " (ID=" + vlanId + ")";
        }
        return "No";
    }

    @Override
    public boolean isActiveLayer3Configuration(SupportedLayer3Configuration layer3Configuration) {
        if (layer3Configuration != null) {
            switch (layer3Configuration.getValue()) {
                case 0: {
                    return this.hasActiveIpv4Configuration();
                }
                case 1: {
                    return this.hasActiveIpv6Configuration();
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasActiveIpv4Configuration() {
        ByteBlowerGuiPort obj = (ByteBlowerGuiPort)this.getObject();
        if (obj == null) {
            return false;
        }
        return obj.isSetIpv4Configuration() && this.getIpv4Configuration().getIsActive() != false;
    }

    @Override
    public boolean hasActiveIpv6Configuration() {
        ByteBlowerGuiPort obj = (ByteBlowerGuiPort)this.getObject();
        if (obj == null) {
            return false;
        }
        return obj.isSetIpv6Configuration() && this.getIpv6Configuration().getIsActive() != false;
    }

    @Override
    public boolean hasActiveConfiguration() {
        return this.hasActiveIpv4Configuration() || this.hasActiveIpv6Configuration();
    }

    @Override
    public Layer2Configuration getLayer2Configuration() {
        return ((ByteBlowerGuiPort)this.getObject()).getLayer2Configuration();
    }

    @Override
    public boolean isAddressConfigurationSucceeded() {
        return ((ByteBlowerGuiPort)this.getObject()).isAddressConfigurationSucceeded();
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        ArrayList<SupportedLayer3Configuration> activeLayer3Configurations = new ArrayList<SupportedLayer3Configuration>();
        if (this.hasActiveIpv4Configuration()) {
            activeLayer3Configurations.add(SupportedLayer3Configuration.IPV4);
        }
        if (this.hasActiveIpv6Configuration()) {
            activeLayer3Configurations.add(SupportedLayer3Configuration.IPV6);
        }
        return activeLayer3Configurations;
    }

    @Override
    public MacAddressReader getMacAddressReader() {
        MacAddress macAddress = this.getMacAddress();
        return ReaderFactory.create(macAddress);
    }

    private MacAddress getMacAddress() {
        EthernetConfiguration ethernet = this.getEthernetConfiguration();
        return ethernet.getMacAddress();
    }

    private EthernetConfiguration getEthernetConfiguration() {
        Layer2Configuration layer2Configuration = ((ByteBlowerGuiPort)this.getObject()).getLayer2Configuration();
        if (layer2Configuration instanceof EthernetConfiguration) {
            return (EthernetConfiguration)layer2Configuration;
        }
        return null;
    }

    @Override
    public String getDockedStatus() {
        String returnString = null;
        if (!PhysicalConfigurationReaderImpl.isPhysicalConfigurationInitialized()) {
            return this.getBasicDockingInfo();
        }
        String serverVersion = "";
        PhysicalDockableReader<?> dockable = this.getPhysicalDockableReader();
        if (dockable == null) {
            returnString = StatusNotAttached;
        } else {
            String interf = dockable.getInterfaceString();
            AbstractServer server = dockable.getServer();
            AbstractServerReader<?> serverReader = ReaderFactory.create(server);
            String serverName = serverReader.getLocalName();
            if (serverName.equals("ByteBlower Server") || serverName.equals("Meeting Point")) {
                serverName = this.getByteBlowerGuiPortConfigurationReader().getServerAddress();
            }
            returnString = String.valueOf(interf) + " on " + serverName;
            serverVersion = serverReader.getServerVersionString();
            if (!serverVersion.isEmpty()) {
                returnString = String.valueOf(returnString) + " - " + serverVersion;
            }
            if (dockable.needsRefresh()) {
                returnString = String.valueOf(returnString) + StatusUnknownAttach;
            }
        }
        return returnString;
    }

    private String getBasicDockingInfo() {
        Integer interfaceId;
        ByteBlowerGuiPortConfigurationReader configReader = this.getByteBlowerGuiPortConfigurationReader();
        try {
            interfaceId = new Integer(configReader.getPhysicalInterfaceId());
        }
        catch (NumberFormatException ex) {
            interfaceId = -1;
        }
        Activator.log(String.format("Building docking info: %s on using id=%s", configReader, interfaceId));
        Activator.log(String.format("Port id is %s", configReader.getPhysicalPortId()));
        return String.valueOf(configReader.getServerAddress()) + " - interface " + (interfaceId + 1) + " - port " + (configReader.getPhysicalPortId() + 1);
    }

    @Override
    public PhysicalDockableReader<?> getPhysicalDockableReader() {
        PhysicalConfigurationReader reader = PhysicalConfigurationReaderImpl.getInstance();
        return reader.getPhysicalDockableReader(this);
    }

    @Override
    public String getNatInfo() {
        if (this.usesPortForwarding()) {
            return this.getPortForwarding().getName();
        }
        return ((ByteBlowerGuiPort)this.getObject()).isNatted() ? "Yes" : "No";
    }

    @Override
    public Boolean isNatAutoDiscovery() {
        return ((ByteBlowerGuiPort)this.getObject()).isNatted();
    }

    @Override
    public VlanReader getVlanReader() {
        Vlan vlan = this.getDeprecatedVlan();
        if (vlan != null) {
            return ReaderFactory.create(vlan);
        }
        return null;
    }

    @Override
    public boolean isDocked() {
        return this.getByteBlowerGuiPortConfigurationReader().isDocked();
    }

    @Override
    public boolean hasFixedAddress() {
        if (this.isIPv4()) {
            return this.getIpv4ConfigurationReader().usesFixedAdress();
        }
        return this.getIpv6ConfigurationReader().usesFixedAdress();
    }

    @Override
    public PortForwarding getPortForwarding() {
        return ((ByteBlowerGuiPort)this.getObject()).getPortForwarding();
    }

    @Override
    public boolean usesPortForwarding() {
        return this.getPortForwarding() != null;
    }

    @Override
    public boolean hasValidVlanStack() {
        if (this.hasVlanStack()) {
            VlanStackReader vlanStackReader = this.getVlanStackReader();
            return !vlanStackReader.hasErrorStatus();
        }
        return false;
    }

    @Override
    public String getVlanStackString() {
        if (this.hasVlanStack()) {
            return this.getVlanStack().getName();
        }
        return "No";
    }

    @Override
    public boolean usesVlanStack() {
        return this.getVlanStack() != null;
    }

    @Override
    public boolean hasDeletedDhcp() {
        if (this.usesDHCP()) {
            if (this.isIPv4()) {
                return this.getDhcpv4() == null;
            }
            return this.getDhcpv6() == null;
        }
        return false;
    }

    @Override
    public FrameReader.Layer3Type getLayer3Type() {
        return this.isIPv4() ? FrameReader.Layer3Type.IPV4 : FrameReader.Layer3Type.IPV6;
    }

    @Override
    public boolean isDockingOk() {
        if (!PhysicalConfigurationReaderImpl.isPhysicalConfigurationInitialized()) {
            return false;
        }
        PhysicalDockableReader<?> dockable = this.getPhysicalDockableReader();
        if (dockable == null) {
            return false;
        }
        return !dockable.needsRefresh();
    }

    @Override
    public EByteBlowerObjectReader<?> getPortForwardingReader() {
        return ReaderFactory.create(this.getPortForwarding());
    }

    @Override
    public boolean hasPortForwarding() {
        return this.getPortForwarding() != null;
    }

    @Override
    public boolean isPartOfGroup() {
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)this.getObject();
        ByteBlowerProject project = this.getProject();
        if (project == null) {
            return false;
        }
        for (ByteBlowerPortGroup group : project.getPortGroup()) {
            if (!group.getMembers().contains((Object)port)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ByteBlowerPortGroup getGroup() {
        ByteBlowerGuiPort port = (ByteBlowerGuiPort)this.getObject();
        for (ByteBlowerPortGroup group : this.getProject().getPortGroup()) {
            if (!group.getMembers().contains((Object)port)) continue;
            return group;
        }
        return null;
    }
}

