/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.BatchReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.MacAddressReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FrameBlastingFlowReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.VlanReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;

public class ByteBlowerProjectReaderImpl
extends EByteBlowerObjectReaderImpl<ByteBlowerProject>
implements ByteBlowerProjectReader {
    public ByteBlowerProjectReaderImpl(ByteBlowerProject myByteBlowerProject) {
        super(myByteBlowerProject);
    }

    public final String getDhcpRetries() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getDhcpRetries();
        }
        return null;
    }

    public final HighResolutionCalendar getDhcpTimeout() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getDhcpTimeout();
        }
        return null;
    }

    public final Integer getNumberOfDecimals() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getNumberOfDecimals();
        }
        return null;
    }

    public final String getWarningLossLevel() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getWarningLossLevel();
        }
        return null;
    }

    public final String getErrorLossLevel() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getErrorLossLevel();
        }
        return null;
    }

    private EList<FlowTemplate> getFlowTemplates() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getFlowTemplate();
        }
        return null;
    }

    @Override
    public EList<TcpFlow> getTcpFlows() {
        EList<FlowTemplate> flowTemplates = this.getFlowTemplates();
        BasicEList tcpFlows = new BasicEList();
        for (FlowTemplate flowTemplate : flowTemplates) {
            if (!(flowTemplate instanceof TcpFlow)) continue;
            tcpFlows.add((Object)((TcpFlow)flowTemplate));
        }
        return tcpFlows;
    }

    @Override
    public EList<FrameBlastingFlow> getFrameBlastingFlows() {
        EList<FlowTemplate> flowTemplates = this.getFlowTemplates();
        BasicEList frameBlastingFlows = new BasicEList();
        for (FlowTemplate flowTemplate : flowTemplates) {
            if (!(flowTemplate instanceof FrameBlastingFlow)) continue;
            frameBlastingFlows.add((Object)((FrameBlastingFlow)flowTemplate));
        }
        return frameBlastingFlows;
    }

    public List<FrameBlastingFlowReader> getFrameBlastingFlowReaders() {
        EList<FrameBlastingFlow> frameBlastingFlows = this.getFrameBlastingFlows();
        if (frameBlastingFlows != null) {
            ArrayList<FrameBlastingFlowReader> frameReaders = new ArrayList<FrameBlastingFlowReader>(frameBlastingFlows.size());
            for (FrameBlastingFlow frameBlastingFlow : frameBlastingFlows) {
                frameReaders.add(new FrameBlastingFlowReaderImpl(frameBlastingFlow));
            }
            return frameReaders;
        }
        return null;
    }

    @Override
    public List<String> getUsedServerAddresses() {
        ArrayList<String> usedAddresses = new ArrayList<String>();
        for (ByteBlowerGuiPortReader portReader : this.getByteBlowerGuiPortReaders()) {
            ByteBlowerGuiPortConfigurationReader portConfigReader = portReader.getByteBlowerGuiPortConfigurationReader();
            String usedServerAddress = portConfigReader.getServerAddress();
            if (usedServerAddress == null || usedAddresses.contains(usedServerAddress)) continue;
            usedAddresses.add(usedServerAddress);
        }
        return usedAddresses;
    }

    @Override
    public List<ByteBlowerGuiPortReader> getByteBlowerGuiPortReaders() {
        ArrayList<ByteBlowerGuiPortReader> portReaders = new ArrayList<ByteBlowerGuiPortReader>();
        for (ByteBlowerGuiPort port : this.getByteBlowerGuiPorts()) {
            portReaders.add(new ByteBlowerGuiPortReaderImpl(port));
        }
        return portReaders;
    }

    @Override
    public final ThroughputType getThroughputType() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getThroughputType();
        }
        return null;
    }

    @Override
    public final DataRateUnit getThroughputUnit() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getThroughputUnit();
        }
        return null;
    }

    private final EList<ByteBlowerGuiPort> getByteBlowerGuiPorts() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getByteBlowerGuiPort();
        }
        return null;
    }

    private EList<Frame> getFrames() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getFrame();
        }
        return null;
    }

    @Override
    public ScenarioReader getScenarioReader(String scenarioName) {
        EList scenarios = ((ByteBlowerProject)this.getObject()).getScenario();
        for (Scenario scenario : scenarios) {
            if (!scenario.getName().equals(scenarioName)) continue;
            return ReaderFactory.create(scenario);
        }
        return null;
    }

    @Override
    public BatchReader getBatchReader(String batchName) {
        EList batches = ((ByteBlowerProject)this.getObject()).getBatch();
        for (Batch batch : batches) {
            if (!batch.getName().equals(batchName)) continue;
            return ReaderFactory.create(batch);
        }
        return null;
    }

    @Override
    public String getAuthor() {
        return ((ByteBlowerProject)this.getObject()).getAuthor();
    }

    @Override
    public Long getLatencyDistributionRangeStartNs() {
        return ((ByteBlowerProject)this.getObject()).getLatencyRangeStart().getTimeInNanoseconds();
    }

    @Override
    public Long getLatencyDistributionRangeEndNs() {
        return ((ByteBlowerProject)this.getObject()).getLatencyRangeEnd().getTimeInNanoseconds();
    }

    @Override
    public EList<MulticastSourceGroup> getMulticastSourceGroups() {
        ByteBlowerProject myByteBlowerProject = (ByteBlowerProject)this.getObject();
        if (myByteBlowerProject != null) {
            return myByteBlowerProject.getMulticastSourceGroup();
        }
        return null;
    }

    @Override
    public List<String> getTakenNames() {
        ArrayList<String> takenNames = new ArrayList<String>();
        TreeIterator treeIterator = ((ByteBlowerProject)this.getObject()).eAllContents();
        while (treeIterator.hasNext()) {
            EObject child = (EObject)treeIterator.next();
            if (!(child instanceof EByteBlowerObject)) continue;
            EByteBlowerObject object = (EByteBlowerObject)child;
            takenNames.add(object.getName());
        }
        return takenNames;
    }

    @Override
    public EList<ByteBlowerGuiPort> getIPv4ByteBlowerGuiPorts() {
        UniqueEList ports = new UniqueEList();
        for (ByteBlowerGuiPortReader reader : this.getByteBlowerGuiPortReaders()) {
            if (!reader.isIPv4()) continue;
            ports.add((Object)((ByteBlowerGuiPort)reader.getObject()));
        }
        return ports;
    }

    @Override
    public EList<ByteBlowerGuiPort> getDockedIPv4ByteBlowerGuiPorts() {
        UniqueEList ports = new UniqueEList();
        for (ByteBlowerGuiPortReader reader : this.getByteBlowerGuiPortReaders()) {
            if (!reader.isIPv4() || !reader.isDocked()) continue;
            ports.add((Object)((ByteBlowerGuiPort)reader.getObject()));
        }
        return ports;
    }

    @Override
    public HighResolutionCalendar getScenarioHttpAllowAlive() {
        return HighResolutionCalendar.MAX_VALUE();
    }

    @Override
    public List<VlanReader> getVlanReaders() {
        ArrayList<VlanReader> readers = new ArrayList<VlanReader>();
        for (Vlan vlan : this.getVlans()) {
            readers.add(new VlanReaderImpl(vlan));
        }
        return readers;
    }

    @Override
    public EList<Vlan> getVlans() {
        return ((ByteBlowerProject)this.getObject()).getVlan();
    }

    @Override
    public EList<VlanStack> getVlanStacks() {
        return ((ByteBlowerProject)this.getObject()).getVlanStack();
    }

    @Override
    public List<MacAddressReader> getAllMacAddresses() {
        ArrayList<MacAddressReader> readers = new ArrayList<MacAddressReader>();
        for (ByteBlowerGuiPortReader reader : this.getByteBlowerGuiPortReaders()) {
            readers.add(reader.getMacAddressReader());
        }
        return readers;
    }

    @Override
    public boolean isAutomaticTcpRestart() {
        return ((ByteBlowerProject)this.getObject()).isScenarioAutomaticTcpRestart();
    }

    @Override
    public boolean isResultsOverTimeEnabled() {
        return ((ByteBlowerProject)this.getObject()).isResultsOverTimeEnabled();
    }

    @Override
    public Long getScenarioHeartbeatInterval() {
        return ((ByteBlowerProject)this.getObject()).getScenarioHeartbeatInterval();
    }

    @Override
    public boolean hasScenarioHeartbeat() {
        return this.getScenarioHeartbeatInterval() != BYTE_BLOWER_PROJECT__SCENARIO_HEARTBEAT_INTERVAL_OFF;
    }
}

