/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import java.util.regex.Pattern;

public class ByteReader {
    private static Byte normalByte;
    private static final String[] hexValues;
    private static final String hexBytePattern = "[0-9a-fA-F]{2}";
    private static final String hexBytePartPattern = "[0-9a-fA-F]{0,2}";

    static {
        hexValues = new String[256];
        int i = 0;
        while (i < 256) {
            String s = Integer.toHexString(i).toUpperCase();
            ByteReader.hexValues[i] = s.length() < 2 ? "0" + s : s;
            ++i;
        }
    }

    private static boolean setHexByte(String string) {
        try {
            int integer = Integer.parseInt(string, 16);
            if (integer > 127) {
                integer -= 256;
            }
            normalByte = new Byte((byte)integer);
        }
        catch (NumberFormatException exception) {
            System.out.println("NumberFormatException " + exception.getMessage());
            return false;
        }
        return true;
    }

    private static boolean setByte(String string) {
        try {
            int integer = Integer.parseInt(string);
            if (integer > 127) {
                integer -= 256;
            }
            normalByte = new Byte((byte)integer);
        }
        catch (NumberFormatException exception) {
            System.out.println("NumberFormatException " + exception.getMessage());
            return false;
        }
        return true;
    }

    private static Byte getByte() {
        return normalByte;
    }

    public static Byte getHexByte(String string) {
        ByteReader.setHexByte(string);
        return ByteReader.getByte();
    }

    public static Byte byteToByte(byte bte) {
        ByteReader.setByte(Byte.toString(bte));
        return normalByte;
    }

    public static boolean isHexByteString(String value) {
        return Pattern.matches(hexBytePattern, value);
    }

    public static boolean isHexByteStringPart(String value) {
        return Pattern.matches(hexBytePartPattern, value);
    }

    public static String toHexString(byte b) {
        return hexValues[b & 0xFF];
    }

    public static Byte toByte(String s) {
        byte b1 = Byte.parseByte("" + s.charAt(0), 16);
        byte b2 = Byte.parseByte("" + s.charAt(1), 16);
        return (byte)((b1 & 0xF) << 4 | b2);
    }
}

