/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.Broadcast;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.ScenarioEvent;
import com.excentis.products.byteblower.model.ScenarioFlowStopEvent;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.Unicast;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FlowReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.MultipleBurstReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class FlowMeasurementReaderImpl
extends EByteBlowerObjectReaderImpl<FlowMeasurement>
implements FlowMeasurementReader {
    public FlowMeasurementReaderImpl(FlowMeasurement myFlowMeasurement) {
        super(myFlowMeasurement);
    }

    @Override
    public HighResolutionCalendar getStartTime() {
        FlowMeasurement myFlowMeasurement = (FlowMeasurement)this.getObject();
        return myFlowMeasurement.getFlowStartEvent().getScheduledTime();
    }

    @Override
    public Long getStartTimeInNanoseconds() {
        return this.getStartTime().getTimeInNanoseconds();
    }

    @Override
    public HighResolutionDuration getDuration() {
        HighResolutionDuration myStopTime = this.getStopTime();
        if (myStopTime != null) {
            return myStopTime.subtractRelative(this.getStartTime());
        }
        return null;
    }

    @Override
    public Long getDurationInNanoseconds() {
        if (this.getDuration() == null) {
            return null;
        }
        return this.getDuration().getTimeInNanoseconds();
    }

    @Override
    public HighResolutionDuration getStopTime() {
        FlowMeasurement flowMeasurement = (FlowMeasurement)this.getObject();
        HighResolutionCalendar scheduledTime = flowMeasurement.getFlowStopEvent().getScheduledTime();
        HighResolutionDuration stopTime = new HighResolutionDuration(scheduledTime);
        if (!this.hasFixedEndTime()) {
            stopTime.setMaybeLonger();
        }
        return stopTime;
    }

    @Override
    public Long getStopTimeInNanoseconds() {
        if (this.getStopTime() == null) {
            return null;
        }
        return this.getStopTime().getTimeInNanoseconds();
    }

    @Override
    public Flow getFlow() {
        return ((FlowMeasurement)this.getObject()).getFlow();
    }

    @Override
    public Long getByteCount() {
        Flow flow = this.getFlow();
        Long nofFrames = this.getNumberOfFrames();
        long totalBytes = 0L;
        if (nofFrames == null) {
            return null;
        }
        FlowTemplate flowTemplate = flow.getFlowTemplate();
        if (flowTemplate instanceof FrameBlastingFlow) {
            FrameBlastingFlowReader frameBlasting = ReaderFactory.create((FrameBlastingFlow)flowTemplate);
            List<FrameReader> frames = frameBlasting.getRepeatedFrameReaders();
            long singleCycle = 0L;
            for (FrameReader frame : frames) {
                singleCycle += (long)frame.getByteSize(ThroughputType.FRAME_ONLY);
            }
            long repetitions = nofFrames / (long)frames.size();
            long remainder = nofFrames % (long)frames.size();
            totalBytes = repetitions * singleCycle;
            int ctr = 0;
            while ((long)ctr < remainder) {
                FrameReader reader = frames.get(ctr);
                totalBytes += (long)reader.getByteSize(ThroughputType.FRAME_AND_ALL_OTHER_FIELDS);
                ++ctr;
            }
        }
        return totalBytes;
    }

    @Override
    public BigInteger getNumberOfFramesBigInteger() {
        Flow flow = this.getFlow();
        BigInteger nofFrames = null;
        if (flow == null) {
            return null;
        }
        FlowTemplate flowTemplate = flow.getFlowTemplate();
        if (flowTemplate == null) {
            return null;
        }
        if (flowTemplate instanceof TcpFlow) {
            return null;
        }
        if (flowTemplate instanceof FrameBlastingFlow) {
            FrameBlastingFlow frameBlasting = (FrameBlastingFlow)flowTemplate;
            BigInteger frameInterval = BigInteger.valueOf(frameBlasting.getFrameInterval().getTimeInNanoseconds());
            BigInteger durationNanos = BigInteger.valueOf(this.getDuration().getTimeInNanoseconds());
            TimingModifier timing = frameBlasting.getTimingModifier();
            if (timing == null) {
                nofFrames = durationNanos.divide(frameInterval);
            } else if (timing instanceof MultipleBurst) {
                MultipleBurst multipleBurst = (MultipleBurst)timing;
                MultipleBurstReaderImpl multipleBurstReader = new MultipleBurstReaderImpl(multipleBurst);
                BigInteger nofFramesPerBurst = multipleBurstReader.getNofFramesPerBurstBigInteger();
                BigInteger interBurstGap = new BigInteger(multipleBurst.getInterBurstGap());
                BigInteger burstDuration = nofFramesPerBurst.multiply(frameInterval);
                BigInteger burstAndIntervalDuration = burstDuration.add(interBurstGap);
                BigInteger nofCompleteBursts = durationNanos.divide(burstAndIntervalDuration);
                BigInteger lastBurstDuration = durationNanos.remainder(burstAndIntervalDuration);
                if (lastBurstDuration.compareTo(burstDuration) == 1) {
                    lastBurstDuration = burstDuration;
                }
                BigInteger nofFramesInLastBurst = lastBurstDuration.divide(frameInterval);
                nofFrames = nofCompleteBursts.multiply(nofFramesPerBurst).add(nofFramesInLastBurst);
            }
        }
        return nofFrames;
    }

    @Override
    public HighResolutionCalendar getLastFrameTime() {
        BigInteger lastFrameTime = null;
        Flow myFlow = this.getFlow();
        if (myFlow == null) {
            return null;
        }
        FlowTemplate flowTemplate = myFlow.getFlowTemplate();
        if (flowTemplate == null) {
            return null;
        }
        if (flowTemplate instanceof FrameBlastingFlow) {
            FrameBlastingFlow frameBlasting = (FrameBlastingFlow)flowTemplate;
            TimingModifier timing = frameBlasting.getTimingModifier();
            if (timing == null) {
                HighResolutionCalendar frameInterval = frameBlasting.getFrameInterval();
                return this.getFlowStopEvent().getScheduledTime().subtractRelative(frameInterval);
            }
            if (timing instanceof MultipleBurst) {
                MultipleBurst multipleBurst = (MultipleBurst)timing;
                BigInteger frameInterval = BigInteger.valueOf(frameBlasting.getFrameInterval().getTimeInNanoseconds());
                BigInteger durationNanos = BigInteger.valueOf(this.getDuration().getTimeInNanoseconds());
                MultipleBurstReaderImpl reader = new MultipleBurstReaderImpl(multipleBurst);
                BigInteger nofFramesPerBurst = reader.getNofFramesPerBurstBigInteger();
                BigInteger interBurstGap = new BigInteger(multipleBurst.getInterBurstGap());
                BigInteger burstDuration = nofFramesPerBurst.multiply(frameInterval);
                BigInteger burstAndIntervalDuration = burstDuration.add(interBurstGap);
                BigInteger nofCompleteBursts = durationNanos.divide(burstAndIntervalDuration);
                lastFrameTime = nofCompleteBursts.multiply(burstAndIntervalDuration);
                BigInteger lastBurstDuration = durationNanos.remainder(burstAndIntervalDuration);
                if (lastBurstDuration.compareTo(burstDuration) == 1) {
                    lastBurstDuration = burstDuration;
                }
                BigInteger nofFramesInLastBurst = lastBurstDuration.divide(frameInterval);
                lastFrameTime = lastFrameTime.add(nofFramesInLastBurst.subtract(BigInteger.ONE).multiply(frameInterval));
                BigInteger startNanos = BigInteger.valueOf(this.getStartTime().getTimeInNanoseconds());
                return new HighResolutionCalendar(Long.valueOf(startNanos.add(lastFrameTime).longValue()));
            }
            return null;
        }
        if (flowTemplate instanceof TcpFlow) {
            return null;
        }
        return null;
    }

    private ScenarioEvent getFlowStartEvent() {
        return ((FlowMeasurement)this.getObject()).getFlowStartEvent();
    }

    private ScenarioFlowStopEvent getFlowStopEvent() {
        return ((FlowMeasurement)this.getObject()).getFlowStopEvent();
    }

    @Override
    public FlowReader getFlowReader() {
        return new FlowReaderImpl(this.getFlow());
    }

    @Override
    public EList<ByteBlowerGuiPort> getInvolvedPorts() {
        UniqueEList involvedPorts = new UniqueEList();
        involvedPorts.add((Object)this.getSourcePort());
        involvedPorts.addAll(this.getDestinationPorts());
        involvedPorts.addAll(this.getEavesdropperPorts());
        return involvedPorts;
    }

    @Override
    public ByteBlowerGuiPort getSourcePort() {
        AddressableSource mSource = ((FlowMeasurement)this.getObject()).getFlow().getSource();
        if (mSource instanceof ByteBlowerGuiPort) {
            return (ByteBlowerGuiPort)mSource;
        }
        throw new IllegalStateException("Unsupported flow source type " + mSource.getClass().getSimpleName() + " found.");
    }

    @Override
    public EList<ByteBlowerGuiPort> getDestinationPorts() {
        UniqueEList mFlowDestinationPorts = new UniqueEList();
        AddressableDestination mDestination = ((FlowMeasurement)this.getObject()).getFlow().getDestination();
        if (mDestination instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPort mDestPort = (ByteBlowerGuiPort)mDestination;
            mFlowDestinationPorts.add((Object)mDestPort);
        } else if (mDestination instanceof MulticastGroup) {
            MulticastGroup mDestMulticastGroup = (MulticastGroup)mDestination;
            for (MulticastMemberPort mMulticastMemberPort : mDestMulticastGroup.getMulticastMemberPort()) {
                mFlowDestinationPorts.add((Object)mMulticastMemberPort.getByteBlowerGuiPort());
            }
        } else if (mDestination instanceof Broadcast) {
            Broadcast mDestBroadcast = (Broadcast)mDestination;
            mFlowDestinationPorts.addAll(this.getProjectReader().getDockedIPv4ByteBlowerGuiPorts());
        } else if (!(mDestination instanceof Unicast)) {
            if (mDestination instanceof ByteBlowerPortGroup) {
                for (ByteBlowerGuiPort port : ((ByteBlowerPortGroup)mDestination).getMembers()) {
                    mFlowDestinationPorts.add((Object)port);
                }
            } else {
                throw new IllegalStateException("Unsupported flow destination type " + mDestination.getClass().getSimpleName() + " found.");
            }
        }
        return mFlowDestinationPorts;
    }

    @Override
    public EList<ByteBlowerGuiPort> getEavesdropperPorts() {
        return ((FlowMeasurement)this.getObject()).getFlow().getByteBlowerGuiPort();
    }

    @Override
    public boolean hasDestinationPorts() {
        return !this.getDestinationPorts().isEmpty();
    }

    @Override
    public boolean hasEavesdropperPorts() {
        return !this.getEavesdropperPorts().isEmpty();
    }

    @Override
    public int getPositionInScenario() {
        ScenarioReader scenarioReader = ReaderFactory.create(((FlowMeasurement)this.getObject()).getScenario());
        List<FlowMeasurement> sortedFlowMeasurements = scenarioReader.getSortedFlowMeasurements();
        return sortedFlowMeasurements.indexOf(this.getObject());
    }

    @Override
    public Long getNumberOfFrames() {
        BigInteger bigint = this.getNumberOfFramesBigInteger();
        if (bigint == null) {
            return null;
        }
        return bigint.longValue();
    }

    @Override
    public boolean hasFixedEndTime() {
        FlowReader flowReader = this.getFlowReader();
        if (flowReader.objectIsNull()) {
            return true;
        }
        FlowTemplate mFlowTemplate = flowReader.getFlowTemplate();
        if (mFlowTemplate == null) {
            return true;
        }
        if (mFlowTemplate instanceof TcpFlow) {
            TcpFlowReader mHttpFlowTemplateReader = ReaderFactory.create((TcpFlow)mFlowTemplate);
            return mHttpFlowTemplateReader.isTimeBased();
        }
        if (mFlowTemplate instanceof FrameBlastingFlow) {
            return true;
        }
        if (mFlowTemplate instanceof FrameBlastingBenchmark) {
            return false;
        }
        throw new IllegalStateException("Unsupported flow type");
    }

    @Override
    public boolean isOverlapping() {
        ScenarioReader scenarioReader = this.getScenarioReader();
        if (scenarioReader.objectIsNull()) {
            return false;
        }
        HighResolutionCalendar thisStart = this.getFlowStartEvent().getScheduledTime();
        HighResolutionCalendar thisStop = this.getFlowStopEvent().getScheduledTime();
        for (FlowMeasurement flowMeasurement : scenarioReader.getFlowMeasurements()) {
            if (flowMeasurement == this.getObject() || flowMeasurement.getFlow() != this.getFlow()) continue;
            HighResolutionCalendar otherStart = flowMeasurement.getFlowStartEvent().getScheduledTime();
            HighResolutionCalendar otherStop = flowMeasurement.getFlowStopEvent().getScheduledTime();
            if (!(thisStart.compareTo((Calendar)otherStart) >= 0 && thisStart.compareTo((Calendar)otherStop) < 0 || thisStop.compareTo((Calendar)otherStart) > 0 && thisStop.compareTo((Calendar)otherStop) <= 0) && (thisStart.compareTo((Calendar)otherStart) > 0 || thisStop.compareTo((Calendar)otherStop) < 0)) continue;
            return true;
        }
        return false;
    }

    private ScenarioReader getScenarioReader() {
        return ReaderFactory.create(this.getScenario());
    }

    @Override
    public Scenario getScenario() {
        return ((FlowMeasurement)this.getObject()).getScenario();
    }

    @Override
    public boolean isFrameBlasting() {
        FlowReader flowReader = this.getFlowReader();
        if (flowReader.objectIsNull()) {
            return false;
        }
        FrameBlastingFlowReader frameBlastingFlowReader = flowReader.getFrameBlastingFlowReader();
        return frameBlastingFlowReader != null;
    }

    @Override
    public String getTos() {
        return this.getFlowReader().getTosString();
    }
}

