/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingFrameReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.FrameReaderImpl;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class FrameBlastingFrameReaderImpl
extends EByteBlowerObjectReaderImpl<FrameBlastingFrame>
implements FrameBlastingFrameReader {
    private static final BigDecimal hundred = new BigDecimal(100);
    public static final int OVERWEIGHT_WARNING = 100;

    public FrameBlastingFrameReaderImpl(FrameBlastingFrame myFrameBlastingFrame) {
        super(myFrameBlastingFrame);
    }

    @Override
    public String getWeightString() {
        int weight = this.getWeight();
        return Integer.toString(weight);
    }

    @Override
    public int getWeight() {
        return this.getFrameBlastingFrame().getWeight();
    }

    private FrameBlastingFlow getFrameBlastingFlow() {
        return (FrameBlastingFlow)this.getFrameBlastingFrame().eContainer();
    }

    private FrameBlastingFrame getFrameBlastingFrame() {
        return (FrameBlastingFrame)this.getObject();
    }

    @Override
    public int getByteWeight() {
        if (this.getFrame() == null) {
            return 0;
        }
        ByteBlowerProjectReader projectReader = this.getProjectReader();
        ThroughputType throughputType = projectReader.getThroughputType();
        if (projectReader.getObject() == null) {
            return 1;
        }
        return this.getByteWeight(throughputType);
    }

    private int getByteWeight(ThroughputType throughputType) {
        Frame frame = this.getFrame();
        FrameReaderImpl frameReader = new FrameReaderImpl(frame);
        int frameByteSize = frameReader.getByteSize(throughputType);
        return this.getWeight() * frameByteSize;
    }

    protected Frame getFrame() {
        return this.getFrameBlastingFrame().getFrame();
    }

    @Override
    public String getByteWeightPercentage() {
        int totalByteWeight = this.getTotalByteWeight();
        int byteWeight = this.getByteWeight();
        return this.getPercentage(byteWeight, totalByteWeight);
    }

    private int getTotalByteWeight() {
        int totalWeight = this.getByteWeight();
        for (FrameBlastingFrame frameBlastingFrame : this.getSiblings()) {
            FrameBlastingFrameReaderImpl frameReader = new FrameBlastingFrameReaderImpl(frameBlastingFrame);
            totalWeight += frameReader.getByteWeight();
        }
        return totalWeight;
    }

    private String getPercentage(int weight, int totalWeight) {
        BigDecimal weightPercentage = new BigDecimal(weight);
        BigDecimal totalWeightDecimal = new BigDecimal(totalWeight);
        if (totalWeight == 0) {
            return Float.toString(Float.NaN);
        }
        weightPercentage = weightPercentage.multiply(hundred);
        weightPercentage = weightPercentage.divide(totalWeightDecimal, 2, RoundingMode.HALF_EVEN);
        return Utils.trim((String)weightPercentage.toString());
    }

    @Override
    public String getFrameWeightPercentage() {
        FrameBlastingFlow flowTemplate = this.getFrameBlastingFlow();
        int totalWeight = this.getTotalFrameWeight(flowTemplate);
        int weight = this.getWeight();
        return this.getPercentage(weight, totalWeight);
    }

    private int getTotalFrameWeight(FrameBlastingFlow flowTemplate) {
        int totalWeight = 0;
        for (FrameBlastingFrame frameBlastingFrame : flowTemplate.getFrameBlastingFrames()) {
            totalWeight += frameBlastingFrame.getWeight();
        }
        return totalWeight;
    }

    @Override
    public EList<FrameBlastingFrame> getSiblings() {
        UniqueEList siblings = new UniqueEList();
        if (this.isContained()) {
            siblings.addAll((Collection)this.getFrameBlastingFlow().getFrameBlastingFrames());
            siblings.remove((Object)this.getFrameBlastingFrame());
        }
        return siblings;
    }

    @Override
    public boolean hasCorrectFrame() {
        Frame firstFrame;
        Frame frame = this.getFrame();
        if (frame == null) {
            return false;
        }
        EList frameBlastingFrames = this.getFrameBlastingFlow().getFrameBlastingFrames();
        if (frameBlastingFrames.size() > 1 && (firstFrame = ((FrameBlastingFrame)frameBlastingFrames.get(0)).getFrame()) != null) {
            FrameReaderImpl firstReader = new FrameReaderImpl(firstFrame);
            FrameReader.Layer3Type firstLayer3Type = firstReader.getLayer3Type();
            FrameReaderImpl thisReader = new FrameReaderImpl(frame);
            FrameReader.Layer3Type thisLayer3Type = thisReader.getLayer3Type();
            return thisLayer3Type != null && thisLayer3Type.isCompatible(firstLayer3Type);
        }
        return true;
    }

    @Override
    public FrameReader getFrameReader() {
        return new FrameReaderImpl(((FrameBlastingFrame)this.getObject()).getFrame());
    }

    @Override
    public boolean hasFrame() {
        return ((FrameBlastingFrame)this.getObject()).getFrame() != null;
    }

    @Override
    public boolean allowSetWeight() {
        return this.getNofSiblings() >= 1;
    }

    @Override
    public boolean hasOverweight() {
        return this.getWeight() > 100;
    }
}

