/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.reader.Ipv4AddressReader;
import com.excentis.products.byteblower.model.reader.NetworkAddressBytes;
import com.excentis.products.byteblower.model.reader.impl.ByteCollectionReader;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.utils.Utils;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;

public class Ipv4AddressReaderImpl
extends IpAddressReaderImpl<Ipv4Address>
implements Ipv4AddressReader {
    private final String typeName;
    private static String ipv4_Part = "(\\d|[0-9]\\d|[0-1]\\d\\d|2[0-4]\\d|25[0-5])";
    private static String netmask_Part = "(0|[12]|1[29]|128|192|2[245]|224|24[08]|25[245])";
    private static String netmask_Part_Complete = "(128|192|224|24[08]|25[245]|0)";
    private static String ipv4_InputPattern = "^(" + ipv4_Part + "(\\.(" + ipv4_Part + "(\\.(" + ipv4_Part + "(\\.(" + ipv4_Part + ")?)?)?)?)?)?)?$";
    private static String ipv4_Pattern = "^" + ipv4_Part + "\\." + ipv4_Part + "\\." + ipv4_Part + "\\." + ipv4_Part + "$";
    private static String ipv4_InputPattern_ForNetmask = "^(" + netmask_Part + ")?$|" + "^(" + netmask_Part_Complete + "\\.){1,3}" + netmask_Part + "?$";
    private static String ipv4_Pattern_ForNetmask = "^" + netmask_Part_Complete + "\\." + netmask_Part_Complete + "\\." + netmask_Part_Complete + "\\." + netmask_Part_Complete + "$";

    private Ipv4AddressReaderImpl(Ipv4Address address, String myTypeName) {
        super(address);
        this.typeName = myTypeName;
    }

    public Ipv4AddressReaderImpl(Ipv4Address address) {
        this(address, "IPv4 Address");
    }

    @Override
    public final int getNetworkAddressSize() {
        return 4;
    }

    @Override
    public final String getNetworkAddressTypeName() {
        return this.typeName;
    }

    public static boolean isValidPartialInput(String string) {
        return Pattern.matches(ipv4_InputPattern, string);
    }

    public static boolean isValid(String string) {
        return Pattern.matches(ipv4_Pattern, string);
    }

    public static boolean isValidNonZero(String string) {
        if (Pattern.matches(ipv4_Pattern, string)) {
            String nodotsnozeros = string.replaceAll("0", "");
            return (nodotsnozeros = nodotsnozeros.replaceAll("\\.", "")).length() != 0;
        }
        return false;
    }

    private static boolean isValidNetmask(String string) {
        if (!Pattern.matches(ipv4_Pattern_ForNetmask, string)) {
            return false;
        }
        String[] bytes = string.split("\\.");
        if (bytes.length != 4) {
            return false;
        }
        String bitMask = "";
        int i = 0;
        while (i < 4) {
            String byto = bytes[i];
            Integer integer = Integer.valueOf(byto);
            int val = integer;
            String bits = Integer.toBinaryString(val);
            while (bits.length() != 8) {
                bits = String.valueOf(bits) + "0";
            }
            if (bits.length() != 8) {
                return false;
            }
            bitMask = String.valueOf(bitMask) + bits;
            ++i;
        }
        int lastOneBit = bitMask.length() - 1;
        while (lastOneBit > 0 && bitMask.charAt(lastOneBit) == '0') {
            --lastOneBit;
        }
        return lastOneBit >= 0 && bitMask.indexOf("0") > lastOneBit;
    }

    public static boolean isValidNetmaskPartialInput(String string) {
        return Pattern.matches(ipv4_InputPattern_ForNetmask, string);
    }

    public static boolean isValid(NetworkAddressBytes networkAddressBytes) {
        return networkAddressBytes.size() == 4;
    }

    @Override
    public boolean isValidValue(NetworkAddressBytes networkAddressBytes) {
        Ipv4Address myIpv4Address = (Ipv4Address)this.getObject();
        return myIpv4Address != null && networkAddressBytes.size() == 4;
    }

    @Override
    public String getMulticastMacAddressString() {
        EList<Byte> addressBytes;
        Ipv4Address myIpv4Address = (Ipv4Address)this.getObject();
        if (myIpv4Address != null && (addressBytes = this.checkValidMulticast()) != null) {
            byte byte1 = (Byte)addressBytes.get(1);
            byte1 = (byte)(byte1 & 0x7F);
            byte byte2 = (Byte)addressBytes.get(2);
            byte byte3 = (Byte)addressBytes.get(3);
            return "01-00-5E-" + Utils.byte2string((byte)byte1) + "-" + Utils.byte2string((byte)byte2) + "-" + Utils.byte2string((byte)byte3);
        }
        return null;
    }

    @Override
    public EList<Byte> checkValidMulticast() {
        EList myBytes = ((Ipv4Address)this.getObject()).getBytes();
        if (myBytes != null) {
            return ((Byte)myBytes.get(0) & 0xF0) == 224 ? myBytes : null;
        }
        return null;
    }

    @Override
    public String getAddress() {
        ByteCollectionReader reader = new ByteCollectionReader((List<Byte>)((Ipv4Address)this.getObject()).getBytes());
        return reader.toByteString(Character.valueOf('.'), 1, true);
    }

    @Override
    public Ipv4Address getIncrementedAddress() {
        Ipv4Address newAddress = ByteblowerguimodelFactory.eINSTANCE.createIpv4Address();
        newAddress.getBytes().addAll(this.getIncrementedBytes());
        return newAddress;
    }

    private EList<Byte> checkValid() {
        EList<Byte> myBytes = this.getBytes();
        return myBytes != null && myBytes.size() == 4 ? myBytes : null;
    }

    @Override
    public boolean isValid(boolean allowZero) {
        EList<Byte> myBytes = this.checkValid();
        if (myBytes != null) {
            if (!allowZero) {
                for (Byte aByte : myBytes) {
                    if (aByte == 0) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValidMulticast() {
        return this.checkValidMulticast() != null;
    }

    private boolean isValidNetmask(boolean allowZero) {
        if (!this.isValid(allowZero)) {
            return false;
        }
        return Ipv4AddressReaderImpl.isValidNetmask(this.getAddress());
    }

    @Override
    public boolean isValidNetmask() {
        return this.isValidNetmask(false);
    }
}

