/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.Ipv6Address;
import com.excentis.products.byteblower.model.reader.Ipv6AddressReader;
import com.excentis.products.byteblower.model.reader.NetworkAddressBytes;
import com.excentis.products.byteblower.model.reader.impl.ByteReader;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigInteger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class Ipv6AddressReaderImpl
extends IpAddressReaderImpl<Ipv6Address>
implements Ipv6AddressReader {
    private final String typeName;
    private static final BigInteger maxIpv6 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
    private static final EList<Byte> allZeros = new BasicEList(16);

    static {
        int i = 0;
        while (i < 16) {
            allZeros.add((Object)0);
            ++i;
        }
    }

    private Ipv6AddressReaderImpl(Ipv6Address myIpv6Address, String myTypeName) {
        super(myIpv6Address);
        this.typeName = myTypeName;
    }

    public Ipv6AddressReaderImpl(Ipv6Address myIpv6Address) {
        this(myIpv6Address, "IPv6 Address");
    }

    @Override
    public boolean isValidValue(NetworkAddressBytes networkAddressBytes) {
        Ipv6Address myIpv6Address = (Ipv6Address)this.getObject();
        return myIpv6Address != null && networkAddressBytes.size() == 16;
    }

    @Override
    public String getMulticastMacAddressString() {
        EList<Byte> addressBytes;
        Ipv6Address myIpv6Address = (Ipv6Address)this.getObject();
        if (myIpv6Address != null && (addressBytes = this.checkValidMulticast()) != null) {
            byte byte1 = (Byte)addressBytes.get(12);
            byte byte2 = (Byte)addressBytes.get(13);
            byte byte3 = (Byte)addressBytes.get(14);
            byte byte4 = (Byte)addressBytes.get(15);
            return "33-33-" + Utils.byte2string((byte)byte1) + "-" + Utils.byte2string((byte)byte2) + "-" + Utils.byte2string((byte)byte3) + "-" + Utils.byte2string((byte)byte4);
        }
        return null;
    }

    @Override
    public EList<Byte> checkValidMulticast() {
        Ipv6Address myIpv6Address = (Ipv6Address)this.getObject();
        EList myBytes = myIpv6Address.getBytes();
        if (myBytes != null) {
            return (Byte)myBytes.get(0) == -1 ? myBytes : null;
        }
        return null;
    }

    @Override
    protected final int getNetworkAddressSize() {
        return 16;
    }

    @Override
    protected final String getNetworkAddressTypeName() {
        return this.typeName;
    }

    @Override
    public String getAddress() {
        return this.getAddress(false);
    }

    private final String getAddress(boolean compressed) {
        String ipv6String = "";
        int length = 0;
        int i = 0;
        while (i < 16) {
            Byte by = (Byte)((Ipv6Address)this.getObject()).getBytes().get(i);
            String hexPart = ByteReader.toHexString(by);
            if (hexPart.length() == 1) {
                hexPart = "0" + hexPart;
            }
            ipv6String = String.valueOf(ipv6String) + hexPart;
            if ((length += 2) % 4 == 0 && i != 15) {
                ipv6String = String.valueOf(ipv6String) + ":";
            }
            ++i;
        }
        return ipv6String.toLowerCase();
    }

    @Override
    public Ipv6Address getIncrementedAddress() {
        Ipv6Address newAddress = ByteblowerguimodelFactory.eINSTANCE.createIpv6Address();
        newAddress.getBytes().addAll(this.getIncrementedBytes());
        return newAddress;
    }

    private BigInteger bytesToBigInteger(EList<Byte> bytes) {
        BigInteger ipv6Value = BigInteger.ZERO;
        try {
            if (bytes.size() == 16) {
                int i = 0;
                while (i < 16) {
                    Byte by = (Byte)bytes.get(i);
                    String val = Utils.byte2string((byte)by);
                    BigInteger addInt = new BigInteger(val, 16);
                    ipv6Value = ipv6Value.shiftLeft(8).add(addInt);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipv6Value;
    }

    private EList<Byte> bigIntegerToBytes(BigInteger newValue) {
        byte[] byteArray = newValue.toByteArray();
        int nofZeros = 16 - byteArray.length;
        BasicEList bytes = new BasicEList();
        int i = 0;
        while (i < 16) {
            if (i < nofZeros) {
                bytes.add((Object)new Byte("0"));
            } else {
                bytes.add((Object)new Byte(byteArray[i - nofZeros]));
            }
            ++i;
        }
        return bytes;
    }

    private EList<Byte> checkValid() {
        EList<Byte> myBytes = this.getBytes();
        return myBytes != null && myBytes.size() == 16 ? myBytes : null;
    }

    @Override
    public boolean isValid(boolean allowZero) {
        EList<Byte> myBytes = this.checkValid();
        if (myBytes != null) {
            return allowZero || !this.bytesToBigInteger(this.getBytes()).equals(BigInteger.ZERO);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValidMulticast() {
        return this.checkValidMulticast() != null;
    }
}

