/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.Ipv4MulticastMemberPort;
import com.excentis.products.byteblower.model.Ipv6MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastFilterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.MulticastMemberPortReader;
import com.excentis.products.byteblower.model.reader.MulticastSourceGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.Ipv4MulticastMemberPortReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.Ipv6MulticastMemberPortReaderImpl;

public abstract class MulticastMemberPortReaderImpl<MulticastMemberPortType extends MulticastMemberPort>
extends EByteBlowerObjectReaderImpl<MulticastMemberPortType>
implements MulticastMemberPortReader<MulticastMemberPortType> {
    public MulticastMemberPortReaderImpl(MulticastMemberPortType multicastMemberPort) {
        super(multicastMemberPort);
    }

    @Override
    public String getName() {
        ByteBlowerGuiPort port = ((MulticastMemberPort)this.getObject()).getByteBlowerGuiPort();
        if (port != null) {
            return port.getName();
        }
        return null;
    }

    public static final MulticastMemberPortReaderImpl<? extends MulticastMemberPort> getInstance(MulticastMemberPort multicastMemberPort) {
        if (multicastMemberPort instanceof Ipv4MulticastMemberPort) {
            return new Ipv4MulticastMemberPortReaderImpl((Ipv4MulticastMemberPort)multicastMemberPort);
        }
        if (multicastMemberPort instanceof Ipv6MulticastMemberPort) {
            return new Ipv6MulticastMemberPortReaderImpl((Ipv6MulticastMemberPort)multicastMemberPort);
        }
        return null;
    }

    @Override
    public ByteBlowerGuiPort getByteBlowerGuiPort() {
        return ((MulticastMemberPort)this.getObject()).getByteBlowerGuiPort();
    }

    @Override
    public ByteBlowerGuiPortReader getByteBlowerGuiPortReader() {
        return ReaderFactory.create(this.getByteBlowerGuiPort());
    }

    @Override
    public MulticastFilterType getMulticastSourceFilter() {
        return ((MulticastMemberPort)this.getObject()).getMulticastSourceFilter();
    }

    @Override
    public MulticastSourceGroup getMulticastSourceGroup() {
        return ((MulticastMemberPort)this.getObject()).getMulticastSourceGroup();
    }

    @Override
    public MulticastSourceGroupReader getMulticastSourceGroupReader() {
        return ReaderFactory.create(this.getMulticastSourceGroup());
    }

    @Override
    public boolean isSourceSpecific() {
        return ((MulticastMemberPort)this.getObject()).getMulticastSourceGroup() != null;
    }

    @Override
    public MulticastGroupReader getMulticastGroupReader() {
        MulticastGroup multicastGroup = ((MulticastMemberPort)this.getObject()).getMulticastGroup();
        return ReaderFactory.create(multicastGroup);
    }

    @Override
    public boolean hasHiddenError() {
        ByteBlowerGuiPortReader reader = this.getByteBlowerGuiPortReader();
        return !this.getMulticastGroupReader().matchesLayer3(reader.getSupportedLayer3Types());
    }
}

