/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.reader.impl.UnitReader;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import java.math.MathContext;

class PayloadReader
extends UnitReader {
    PayloadReader() {
    }

    static BigDecimal convertPayload(BigDecimal payload, PayloadUnit fromUnit, PayloadUnit toUnit) {
        if (fromUnit == toUnit) {
            return payload;
        }
        UnitReader.UnitPrefix fromPrefix = PayloadReader.getUnitPrefix(fromUnit);
        UnitReader.UnitPrefix toPrefix = PayloadReader.getUnitPrefix(toUnit);
        payload = PayloadReader.convert(payload, fromPrefix, toPrefix);
        if (PayloadReader.usesBytes(fromUnit) != PayloadReader.usesBytes(toUnit)) {
            payload = PayloadReader.usesBytes(toUnit) ? PayloadReader.convertBitsToBytes(payload) : PayloadReader.convertBytesToBits(payload);
        }
        return payload;
    }

    private static BigDecimal convertBitsToBytes(BigDecimal throughput) {
        return throughput.divide(BITS_PER_BYTE, MathContext.DECIMAL128);
    }

    static BigDecimal convertBytesToBits(BigDecimal throughput) {
        return throughput.multiply(BITS_PER_BYTE, MathContext.DECIMAL128);
    }

    static BigDecimal convertFrom(BigDecimal value, PayloadUnit fromUnit) {
        UnitReader.UnitPrefix fromPrefix = PayloadReader.getUnitPrefix(fromUnit);
        switch (fromUnit) {
            case BYTES: 
            case KBYTES: 
            case MBYTES: 
            case GBYTES: {
                value = PayloadReader.convertBytesToBits(value);
                break;
            }
        }
        return PayloadReader.convertFrom(value, fromPrefix);
    }

    static BigDecimal convertTo(BigDecimal value, PayloadUnit toUnit) {
        UnitReader.UnitPrefix toPrefix = PayloadReader.getUnitPrefix(toUnit);
        switch (toUnit) {
            case BYTES: 
            case KBYTES: 
            case MBYTES: 
            case GBYTES: {
                value = PayloadReader.convertBitsToBytes(value);
                break;
            }
        }
        return PayloadReader.convertTo(value, toPrefix);
    }

    private static UnitReader.UnitPrefix getUnitPrefix(PayloadUnit unit) {
        switch (unit) {
            case BITS: 
            case BYTES: {
                return UnitReader.UnitPrefix.BASE;
            }
            case KBITS: 
            case KBYTES: {
                return UnitReader.UnitPrefix.KILO;
            }
            case MBITS: 
            case MBYTES: {
                return UnitReader.UnitPrefix.MEGA;
            }
            case GBITS: 
            case GBYTES: {
                return UnitReader.UnitPrefix.GIGA;
            }
        }
        System.err.println("ThroughputReader::getUnitPrefix : unsupported unit : " + unit);
        return null;
    }

    private static boolean usesBytes(PayloadUnit unit) {
        return unit == PayloadUnit.BYTES || unit == PayloadUnit.KBYTES || unit == PayloadUnit.MBYTES || unit == PayloadUnit.GBYTES;
    }

    static String getThroughputString(BigDecimal payload, PayloadUnit unit) {
        int scale;
        switch (unit.getValue()) {
            case 1: 
            case 5: {
                scale = 6;
                break;
            }
            case 2: 
            case 6: {
                scale = 9;
                break;
            }
            case 3: 
            case 7: {
                scale = 12;
                break;
            }
            default: {
                scale = 3;
            }
        }
        String humanReadable = payload.toString();
        humanReadable = Utils.trim((String)humanReadable, (int)scale);
        return humanReadable;
    }
}

