/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.impl;

import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.impl.EByteBlowerObjectReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.PayloadReader;
import com.excentis.products.byteblower.model.reader.impl.ThroughputReader;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TcpFlowReaderImpl
extends EByteBlowerObjectReaderImpl<TcpFlow>
implements TcpFlowReader {
    public TcpFlowReaderImpl(TcpFlow tcpFlow) {
        super(tcpFlow);
    }

    @Override
    public TCPCongestionAvoidanceAlgorithm getTCPCongestionAvoidanceAlgorithm() {
        return ((TcpFlow)this.getObject()).getTCPCongestionAvoidanceAlgorithm();
    }

    @Override
    public boolean hasAutomaticClientPort() {
        return this.getClientPort().equals("Automatic");
    }

    @Override
    public String getClientPort() {
        return ((TcpFlow)this.getObject()).getClientPort();
    }

    @Override
    public boolean hasAutomaticServerPort() {
        return this.getServerPort().equals("Automatic");
    }

    @Override
    public String getServerPort() {
        return ((TcpFlow)this.getObject()).getServerPort();
    }

    @Override
    public boolean usesReceiveWindowScaling() {
        return ((TcpFlow)this.getObject()).isWindowScaling();
    }

    @Override
    public int getRcvWindowScale() {
        return ((TcpFlow)this.getObject()).getRcvWindowScale();
    }

    @Override
    public boolean isPayloadBased() {
        return !this.isTimeBased();
    }

    @Override
    public boolean isTimeBased() {
        String payload = ((TcpFlow)this.getObject()).getPayloadSize();
        return payload.equals("Unlimited") || Float.parseFloat(payload) == 0.0f;
    }

    @Override
    public String getPayloadSizeString() {
        if (this.isTimeBased()) {
            return "Time Based -> Set in Scenario";
        }
        String payload = Utils.formatFloat((Float)Float.valueOf(this.getPayloadSize()));
        PayloadUnit unit = this.getPayloadUnit();
        return "Payload Based -> " + payload + " " + unit;
    }

    @Override
    public PayloadUnit getPayloadUnit() {
        return ((TcpFlow)this.getObject()).getPayloadUnit();
    }

    @Override
    public boolean isRateLimited() {
        TcpFlow tcp = (TcpFlow)this.getObject();
        return tcp.getRateLimit() != 0.0f;
    }

    @Override
    public long getRateLimitInBytesps() {
        TcpFlow tcp = (TcpFlow)this.getObject();
        float rateLimitFloat = tcp.getRateLimit();
        BigDecimal rateLimit = new BigDecimal(rateLimitFloat);
        DataRateUnit fromUnit = this.getRateLimitUnit();
        DataRateUnit toUnit = DataRateUnit.BYTESPS;
        BigDecimal bytesps = ThroughputReader.convertThroughput(rateLimit, fromUnit, toUnit);
        return bytesps.longValue();
    }

    @Override
    public DataRateUnit getRateLimitUnit() {
        return ((TcpFlow)this.getObject()).getRateLimitUnit();
    }

    @Override
    public String getRateLimitString() {
        if (this.isRateLimited()) {
            TcpFlow tcp = (TcpFlow)this.getObject();
            float rateLimit = tcp.getRateLimit();
            String rate = Utils.formatFloat((Float)Float.valueOf(rateLimit));
            DataRateUnit unit = tcp.getRateLimitUnit();
            return String.valueOf(rate) + " " + unit;
        }
        return "No";
    }

    @Override
    public String getWindowSizeString() {
        String windowSize = ((TcpFlow)this.getObject()).getWindowSize();
        return Utils.trim((String)windowSize);
    }

    @Override
    public String isL4SString() {
        if (this.isL4S()) {
            return "Yes";
        }
        return "No";
    }

    @Override
    public String isWindowScalingString() {
        if (((TcpFlow)this.getObject()).isWindowScaling()) {
            return "Yes";
        }
        return "No";
    }

    @Override
    public String getRcvWindowScaleString() {
        return String.valueOf(this.getRcvWindowScale());
    }

    @Override
    public String getHTTPMethodString() {
        return ((TcpFlow)this.getObject()).getHTTPMethod().getName();
    }

    @Override
    public String getTCPCongestionAvoidanceAlgorithmString() {
        return ((TcpFlow)this.getObject()).getTCPCongestionAvoidanceAlgorithm().getName();
    }

    @Override
    public String getClientPortString() {
        return Utils.trim((String)((TcpFlow)this.getObject()).getClientPort());
    }

    @Override
    public String getServerPortString() {
        return Utils.trim((String)((TcpFlow)this.getObject()).getServerPort());
    }

    @Override
    public float getRateLimit() {
        return ((TcpFlow)this.getObject()).getRateLimit();
    }

    @Override
    public long getRateLimitInBitsps() {
        float rateLimitFloat = this.getRateLimit();
        BigDecimal rateLimit = new BigDecimal(rateLimitFloat);
        DataRateUnit fromUnit = this.getRateLimitUnit();
        DataRateUnit toUnit = DataRateUnit.BPS;
        BigDecimal bps = ThroughputReader.convertThroughput(rateLimit, fromUnit, toUnit);
        return bps.longValue();
    }

    @Override
    public float getPayloadSize() {
        try {
            return Float.parseFloat(((TcpFlow)this.getObject()).getPayloadSize());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    @Override
    public float getPayloadSizeInBytes() {
        float payloadSize = this.getPayloadSize();
        BigDecimal payload = new BigDecimal(payloadSize);
        PayloadUnit fromUnit = this.getPayloadUnit();
        PayloadUnit toUnit = PayloadUnit.BYTES;
        BigDecimal bytes = PayloadReader.convertPayload(payload, fromUnit, toUnit);
        return bytes.floatValue();
    }

    @Override
    public Integer getClientPortNumber() {
        try {
            return Integer.parseInt(((TcpFlow)this.getObject()).getClientPort());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getServerPortNumber() {
        try {
            return Integer.parseInt(((TcpFlow)this.getObject()).getServerPort());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getInitialReceiveWindowSizeNumber() {
        try {
            return Integer.parseInt(((TcpFlow)this.getObject()).getWindowSize());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Integer getReceiveWindowScalingValueNumber() {
        return new Integer(((TcpFlow)this.getObject()).getRcvWindowScale());
    }

    @Override
    public String getSlowStartString() {
        int slowStartValue = this.getSlowStartThreshold();
        String string = Integer.toString(slowStartValue);
        if (slowStartValue == 65535) {
            string = "65535 (old default)";
        } else if (slowStartValue == Integer.MAX_VALUE) {
            string = predefinedInfiniteSlowStartString;
        }
        return string;
    }

    @Override
    public int getSlowStartThreshold() {
        return ((TcpFlow)this.getObject()).getSlowStart();
    }

    @Override
    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        ArrayList<SupportedLayer3Configuration> supported = new ArrayList<SupportedLayer3Configuration>();
        supported.add(SupportedLayer3Configuration.IPV4);
        supported.add(SupportedLayer3Configuration.IPV6);
        return supported;
    }

    @Override
    public boolean hasInvalidPayloadSize() {
        return this.isPayloadBased() && this.getPayloadSizeInBytes() < 500.0f;
    }

    @Override
    public boolean isL4S() {
        return ((TcpFlow)this.getObject()).isL4s();
    }
}

