/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.impl.EByteBlowerServerObjectReaderImpl;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.LicenseType;
import com.excentis.products.byteblower.server.model.PhysicalConfiguration;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import com.excentis.products.byteblower.server.model.ServerRelease;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.osgi.framework.Version;

public class AbstractServerReaderImpl<ServerType extends AbstractServer>
extends EByteBlowerServerObjectReaderImpl<ServerType>
implements AbstractServerReader<ServerType> {
    private static final Logger LOGGER = Logger.getGlobal();

    public AbstractServerReaderImpl(ServerType server) {
        super(server);
    }

    @Override
    public boolean isAvahiAvailable() {
        return ((AbstractServer)this.getObject()).isAvahiAvailable();
    }

    @Override
    public ServerLinkStatus getServerLinkStatus() {
        return ((AbstractServer)this.getObject()).getServerLinkStatus();
    }

    @Override
    public String getServerAddress() {
        return ((AbstractServer)this.getObject()).getAddress();
    }

    @Override
    public Version getCurrentVersion() {
        try {
            return Version.parseVersion((String)((AbstractServer)this.getObject()).getVersion());
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Could not parse version string while searching for update", ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.FINEST, "Could not parse version string while searching for update", ex);
        }
        return Version.emptyVersion;
    }

    @Override
    public boolean hasUpdateAvailable() {
        Version latestVersion = this.getLatestVersion();
        return this.getCurrentVersion().compareTo(latestVersion) < 0;
    }

    private PhysicalConfiguration getPhysicalConfiguration() {
        return (PhysicalConfiguration)((AbstractServer)this.getObject()).eContainer();
    }

    @Override
    public Version getLatestVersion() {
        try {
            PhysicalConfiguration physicalConfiguration = this.getPhysicalConfiguration();
            if (physicalConfiguration != null) {
                EList releases = physicalConfiguration.getLatestReleases();
                String serverSeries = ((AbstractServer)this.getObject()).getServerType();
                for (ServerRelease release : releases) {
                    if (!serverSeries.equals(release.getServerSeries())) continue;
                    return Version.parseVersion((String)release.getVersion());
                }
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Could not parse version string while searchin for update", ex);
        }
        return Version.emptyVersion;
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return null;
    }

    @Override
    public Collection<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return null;
    }

    @Override
    public String getLocalName() {
        return ((AbstractServer)this.getObject()).getLocalName();
    }

    @Override
    public String getServerVersionString() {
        if (this.getServerLinkStatus() == ServerLinkStatus.INCOMPATIBLE_VERSION) {
            return "Incompatible Version. Please update your server.";
        }
        Version version = this.getCurrentVersion();
        if (Version.emptyVersion.compareTo(version) == 0) {
            return "";
        }
        String value = version.toString();
        Version latest = this.getLatestVersion();
        if (version.compareTo(latest) < 0) {
            value = String.valueOf(value) + "    New version available: " + latest.toString();
        }
        return value;
    }

    @Override
    public String getServerInfoString() {
        String localName = this.getLocalName();
        String versionInfo = this.getServerVersionString();
        String address = this.getServerAddress();
        String returnText = String.valueOf(localName) + " (" + address + ") " + versionInfo;
        if (this.hasUpdateAvailable()) {
            Version latestVersion = this.getLatestVersion();
            returnText = String.valueOf(returnText) + " - Update available - v " + latestVersion;
        }
        return returnText;
    }

    @Override
    public LicenseType getLicenseType() {
        return ((AbstractServer)this.getObject()).getLicenseType();
    }

    @Override
    public boolean needsRefresh() {
        return this.getServerLinkStatus() == ServerLinkStatus.UNKNOWN;
    }

    @Override
    public boolean isLicenseNotBought() {
        return this.getLicenseType() == LicenseType.NOT_BOUGHT;
    }

    @Override
    public String getServerType() {
        return ((AbstractServer)this.getObject()).getServerType();
    }
}

