/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.reader.server.impl;

import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.MeetingPointReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.model.reader.server.impl.AbstractServerReaderImpl;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;

public class MeetingPointReaderImpl
extends AbstractServerReaderImpl<MeetingPoint>
implements MeetingPointReader {
    public MeetingPointReaderImpl(MeetingPoint object) {
        super(object);
    }

    @Override
    public EList<PhysicalMobileDevice> getMobileDevices() {
        return ((MeetingPoint)this.getObject()).getMobileDevices();
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        ArrayList<DockedByteBlowerPortReader> dockedPortReaders = new ArrayList<DockedByteBlowerPortReader>();
        List<MobileDeviceReader> readers = this.getMobileDeviceReaders();
        for (MobileDeviceReader reader : readers) {
            dockedPortReaders.addAll(reader.getAllDockedPortReaders());
        }
        return dockedPortReaders;
    }

    @Override
    public List<MobileDeviceReader> getMobileDeviceReaders() {
        ArrayList<MobileDeviceReader> readers = new ArrayList<MobileDeviceReader>();
        for (PhysicalMobileDevice device : this.getMobileDevices()) {
            readers.add(ReaderFactory.create(device));
        }
        return readers;
    }

    @Override
    public EList<PhysicalDockable> getDockables() {
        UniqueEList dockables = new UniqueEList();
        List<MobileDeviceReader> readers = this.getMobileDeviceReaders();
        for (MobileDeviceReader reader : readers) {
            dockables.addAll(reader.getDockables());
        }
        return dockables;
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        String thisServerAddress;
        if (!portConfigReader.isDocked()) {
            return null;
        }
        String configServerAddress = portConfigReader.getServerAddress();
        if (!configServerAddress.equals(thisServerAddress = this.getServerAddress())) {
            return null;
        }
        String interfaceId = portConfigReader.getPhysicalInterfaceId();
        for (MobileDeviceReader reader : this.getMobileDeviceReaders()) {
            if (!reader.getDeviceId().equals(interfaceId)) continue;
            return (PhysicalDockable)reader.getObject();
        }
        return null;
    }
}

